/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.parser.plsql.TabCol;
import oracle.dbtools.raptor.controls.grid.EditableResultSetTableModel;
import oracle.dbtools.raptor.controls.grid.RSTMSql;
import oracle.dbtools.raptor.controls.grid.RaptorGridPersistedSettings;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;

public class OracleERSTM
extends EditableResultSetTableModel {
    public final String EXTERNAL_TABLE_SQL = "SELECT OWNER,TABLE_NAME FROM all_external_tables";
    protected boolean _isExternalTable = false;
    protected static final String EDITABLE_COLS_SQL = "select column_name from  all_updatable_columns A where TABLE_NAME = :OBJECT_NAME and owner = :OBJECT_OWNER and A.updatable = 'YES'";
    private boolean _isEditableView = true;
    public static final String NO_DATA_INTEGRITY_COLS = "NO_DATA_INTEGRITY_COLS";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean isExternalTable() {
        ResultSet resultSet;
        ArrayList<String> arrayList;
        String string;
        block5: {
            string = this._schemaName + "." + this._tablename;
            string = string.replaceAll("\"", "");
            arrayList = new ArrayList<String>();
            resultSet = null;
            try {
                Connections.getInstance().lock(this.getConnectionName());
                resultSet = DBUtil.getInstance((String)this.getConnectionName()).executeQuery("SELECT OWNER,TABLE_NAME FROM all_external_tables", (Map)null);
                if (resultSet == null) break block5;
                while (resultSet.next()) {
                    String string2 = resultSet.getString(1) + "." + resultSet.getString(2);
                    arrayList.add(string2);
                }
            }
            catch (SQLException sQLException) {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(this.getConnectionName());
                catch (Throwable throwable) {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(this.getConnectionName());
                    throw throwable;
                }
            }
        }
        DBUtil.closeResultSet((ResultSet)resultSet);
        Connections.getInstance().unlock(this.getConnectionName());
        return arrayList.contains(string);
    }

    @Override
    protected ResultSet openResultSet() throws SQLException, DBException {
        this.fecthTableName();
        if (new Version("8.0").compareTo(DBUtil.getDbVersion((Connection)this.getConnection())) < 0) {
            this._isExternalTable = this.isExternalTable();
        }
        Connection connection = null;
        try {
            connection = this.getConnection();
        }
        catch (DBException dBException) {
            // empty catch block
        }
        if (connection != null) {
            if (this._queryObj == null) {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                Version version = DBUtil.getDbVersion((Connection)connection);
                Version version2 = new Version("10.2");
                this._addRowScnColumn = Preference_USE_SCN;
                if (this._isExternalTable && version2.compareTo(version) > 0 || this.getEditableColumnNames().size() == 0) {
                    this._addRowIdColumn = false;
                    this._addRowScnColumn = false;
                }
                if (version2.compareTo(version) > 0) {
                    this._addRowScnColumn = false;
                }
                if (this._dbObject != null && this._dbObject.getObjectType().equals("VIEW")) {
                    this._addRowScnColumn = false;
                    dBUtil.setRaiseError(false);
                    String string = "select   NULLIF((select count(1) from all_updatable_columns where owner = '%s' and table_name = '%s' and insertable = 'YES'),0),  (select rowid from %s.%s where rownum = 1) from dual";
                    String string2 = String.format(string, this.removeDoubleQuote(this._schemaName), this.removeDoubleQuote(this._tablename), DBUtil.addDoubleQuote((String)this.removeDoubleQuote(this._schemaName)), DBUtil.addDoubleQuote((String)this.removeDoubleQuote(this._tablename)));
                    String string3 = dBUtil.executeOracleReturnOneCol(string2, (Map)null);
                    if (string3 == null) {
                        this._isEditableView = false;
                    }
                    if (!this._isEditableView) {
                        this._addRowIdColumn = false;
                    }
                }
            } else {
                this._addRowIdColumn = false;
                this._addRowScnColumn = false;
            }
        }
        if (this._bindMap != null) {
            if (this._bindMap.containsKey(NO_DATA_INTEGRITY_COLS)) {
                this._addRowIdColumn = false;
                this._addRowScnColumn = false;
            }
        }
        this._rs = super.openResultSet();
        return this._rs;
    }

    private String removeDoubleQuote(String string) {
        String string2 = string;
        if (string.startsWith("\"")) {
            string2 = string.substring(1, string.length() - 1);
        }
        return string2;
    }

    @Override
    public boolean isCellEditorEditable(int n, int n2) {
        return !this._isExternalTable && super.isCellEditorEditable(n, n2);
    }

    public List<String> getEditableColumnNames() {
        if (this._editableColNames == null) {
            final ArrayList arrayList = new ArrayList();
            try {
                final Connection connection = this.getConnection();
                Connections.getInstance().executeWithLock(connection, new Callable<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call() throws Exception {
                        ResultSet resultSet;
                        block8: {
                            resultSet = null;
                            try {
                                if (OracleERSTM.this._dbObject != null) {
                                    resultSet = DBUtil.getInstance((Connection)connection).executeQuery(OracleERSTM.EDITABLE_COLS_SQL, OracleERSTM.this.getDBObject().getDictionary());
                                } else if (OracleERSTM.this._tablename != null && OracleERSTM.this._schemaName != null) {
                                    HashMap<String, String> hashMap = new HashMap<String, String>();
                                    String string = OracleERSTM.this._tablename.toUpperCase();
                                    String string2 = OracleERSTM.this._schemaName.toUpperCase();
                                    hashMap.put("OBJECT_NAME", string);
                                    hashMap.put("OBJECT_OWNER", string2);
                                    resultSet = DBUtil.getInstance((Connection)connection).executeQuery(OracleERSTM.EDITABLE_COLS_SQL, hashMap);
                                }
                                if (resultSet == null) break block8;
                                while (resultSet.next()) {
                                    arrayList.add(resultSet.getString(1));
                                }
                            }
                            catch (SQLException sQLException) {
                                try {
                                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, sQLException.getStackTrace()[0].toString(), sQLException);
                                }
                                catch (Throwable throwable) {
                                    DBUtil.closeResultSet(resultSet);
                                    throw throwable;
                                }
                                DBUtil.closeResultSet((ResultSet)resultSet);
                            }
                        }
                        DBUtil.closeResultSet((ResultSet)resultSet);
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
            }
            this._editableColNames = arrayList;
        }
        return this._editableColNames;
    }

    @Override
    public boolean isEditable() {
        if (!this.isOracle()) {
            return false;
        }
        if (this._isExternalTable) {
            return false;
        }
        if (this._dbObject != null && this._dbObject.getObjectType().equals("VIEW") && !this._isEditableView) {
            return false;
        }
        return this.getEditableColumnNames() != null && this.getEditableColumnNames().size() != 0;
    }

    @Override
    public void closeModel() {
        this._isEditableView = true;
        super.closeModel();
    }

    @Override
    public String getModifiedSql() {
        return this.getModifiedSql(false);
    }

    public String getModifiedSql(boolean bl) {
        ArrayList<TabCol.Column> arrayList;
        String[] stringArray;
        Object object;
        StringBuilder stringBuilder;
        block20: {
            if (this._sql == null) {
                return null;
            }
            stringBuilder = new StringBuilder();
            if (bl && this._expandedSql == null) {
                try {
                    if (!Connections.getInstance().isOracle(this.getConnectionName())) break block20;
                    object = new TabCol(this.getConnectionName());
                    this._rstmsql.setTableName(this._tablename);
                    stringArray = null;
                    if (this._addRowIdColumn && this._addRowScnColumn) {
                        stringArray = new String[]{(String)this.DATA_INTEGRITY_COLS.get(0), (String)this.DATA_INTEGRITY_COLS.get(1)};
                    } else if (this._addRowIdColumn) {
                        stringArray = new String[]{(String)this.DATA_INTEGRITY_COLS.get(0)};
                    } else if (this._addRowIdColumn) {
                        stringArray = new String[]{(String)this.DATA_INTEGRITY_COLS.get(1)};
                    }
                    if (stringArray != null) {
                        arrayList = ((TabCol)object).fetchColumns(this._rstmsql.getModifiedSql(), false);
                        stringBuilder = new StringBuilder(((TabCol)object).disambiguate(arrayList, stringArray));
                        this._expandedSql = stringBuilder.toString();
                        break block20;
                    }
                    stringBuilder.append(this._rstmsql.getModifiedSql());
                }
                catch (Exception exception) {
                    stringBuilder.append(this._rstmsql.getModifiedSql());
                }
            } else if (this._expandedSql != null) {
                stringBuilder.append(this._rstmsql.getModifiedSql(this._expandedSql));
            } else {
                stringBuilder.append(this._rstmsql.getModifiedSql());
            }
        }
        object = this.getSortString();
        if (this._autoApplyPersistedSort && object == null && this._rs == null) {
            String string;
            stringArray = RaptorGridPersistedSettings.loadPersistedSettings((String)this.getModelUniqueName());
            arrayList = null;
            if (stringArray != null && (arrayList = stringArray.getSortClauses()) != null && arrayList.size() > 0 && (string = (String)arrayList.get(0)) != null && !string.equals("")) {
                object = string;
            }
        }
        if (object != null && ((String)object).trim().length() > 0) {
            if (this.hasDuplicateColumnNames()) {
                try {
                    if (Connections.getInstance().isOracle(this.getConnectionName())) {
                        stringArray = new TabCol(this.getConnectionName());
                        arrayList = stringArray.fetchColumns(stringBuilder.toString());
                        stringBuilder = new StringBuilder(stringArray.disambiguate(arrayList));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            stringBuilder.insert(0, "select * from (\n");
            stringBuilder.append("\n ) sub1 order by ");
            stringBuilder.append((String)object);
        }
        stringArray = "/* + NO_PARALLEL */" + RSTMSql.sanitizeSql(stringBuilder.toString());
        return stringArray;
    }

    @Override
    protected PreparedStatement prepareStatement() throws SQLException, DBException {
        String string = this.getModifiedSql(true);
        PreparedStatement preparedStatement = null;
        if (ModelUtil.hasLength((String)string)) {
            preparedStatement = this.getConnection().prepareStatement(string);
            preparedStatement.setEscapeProcessing(false);
            if (this.getBindList() != null && this.getBindList().size() > 0) {
                DBUtil.bind((PreparedStatement)preparedStatement, this.getBindList());
            } else if (this.getBindMap() != null && this.getBindMap().size() > 0) {
                DBUtil.bind((String)string, (PreparedStatement)preparedStatement, this.getBindMap());
            }
        }
        return preparedStatement;
    }
}

