/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display.chart;

import java.util.Map;
import oracle.dbtools.raptor.controls.display.chart.Archiver;
import oracle.dbtools.raptor.controls.display.chart.ChartPropertyManagerImpl;
import oracle.dbtools.raptor.controls.display.chart.PropertyName;

class EnumArchiver<T extends Enum<T>>
extends Archiver<T> {
    private Class<T> enumType;
    private T defaultValue;

    EnumArchiver(Class<T> clazz, T[] TArray) {
        this.enumType = clazz;
        this.defaultValue = TArray[0];
    }

    @Override
    T load(PropertyName propertyName, Map<String, String> map) {
        String string = map.get(propertyName.get());
        return string != null ? (T)Enum.valueOf(this.enumType, string) : null;
    }

    @Override
    void verifyValue(ChartPropertyManagerImpl chartPropertyManagerImpl, T t) {
        if (!t.getClass().equals(this.enumType)) {
            throw new ClassCastException();
        }
    }

    @Override
    T getDefault(ChartPropertyManagerImpl chartPropertyManagerImpl) {
        return this.defaultValue;
    }

    @Override
    void save(PropertyName propertyName, Map<String, String> map, T t) {
        map.put(propertyName.get(), ((Enum)t).toString());
    }

    @Override
    Class primitiveClass() {
        return this.enumType;
    }
}

