/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.display;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.display.CancellableQuery;
import oracle.dbtools.raptor.controls.display.DisplayAdapter;
import oracle.dbtools.raptor.controls.display.GraphContextMenuListener;
import oracle.dbtools.raptor.controls.display.ISelectionChangeListener;
import oracle.dbtools.raptor.controls.display.chart.ChartPropertyManager;
import oracle.dbtools.raptor.controls.display.chart.ChartPropertyManagerFactory;
import oracle.dbtools.raptor.controls.display.chart.PropertyType;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.LocalXMLDataSource;
import oracle.dss.dataView.ViewMouseEvent;
import oracle.dss.dataView.ViewMouseListener;
import oracle.dss.graph.CustomToolTipCallback;
import oracle.dss.graph.Graph;
import oracle.dss.graph.MarkerText;
import oracle.i18n.util.OraLocaleInfo;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.javatools.dialogs.MessageDialog;

public class DisplaySimpleChart
extends DisplayAdapter
implements ISelectionChangeListener {
    private ChartPropertyManager propMgr;
    private Graph _graph;
    private static ContextMenu _graphCM = new ContextMenu();
    private JScrollPane _spSql;
    private DisplaySimpleChart _instance;
    private boolean customMap = false;
    private String[] colNames = new String[3];
    private boolean refreshInTask = true;
    private static GraphContextMenuListener _menu = GraphContextMenuListener.getInstance();

    public void init() {
        if (this._graph == null) {
            Object object;
            if (this._instance == null) {
                this._instance = this;
            }
            if ((object = this.getDisplayModel().getCustomValue()) != null && object instanceof ChartPropertyManager) {
                this.propMgr = (ChartPropertyManager)object;
                this._graph = this.propMgr.createGraph();
                this.propMgr.bindGraph(this._graph);
            } else {
                this.propMgr = ChartPropertyManagerFactory.createNew();
                this.propMgr.load(this.getExtValues());
                this._graph = this.propMgr.createGraph();
            }
            this._graph.addViewMouseListener(new ViewMouseListener(){

                public void mouseClicked(ViewMouseEvent viewMouseEvent) {
                }

                public void mouseEntered(ViewMouseEvent viewMouseEvent) {
                }

                public void mouseExited(ViewMouseEvent viewMouseEvent) {
                }

                public void mousePressed(ViewMouseEvent viewMouseEvent) {
                }

                public void mouseReleased(ViewMouseEvent viewMouseEvent) {
                    ComponentHandle componentHandle = DisplaySimpleChart.this._graph.getSelectedObject();
                    if (componentHandle instanceof DataComponentHandle) {
                        DisplaySimpleChart.this.setDirty(false);
                        DisplaySimpleChart.this.fireSelectionChanged();
                    }
                }
            });
            this._graph.addMouseListener((MouseListener)new MouseAdapter(){
                private Context _context = new Context();

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    int n = mouseEvent.getModifiers();
                    if (((n & 8) != 0 || (n & 4) != 0) && mouseEvent.getSource() == DisplaySimpleChart.this._graph.getThickPFJ()) {
                        this._context.setEvent((EventObject)mouseEvent);
                        _graphCM.show(this._context);
                    }
                }
            });
            this._graph.setVisible(false);
            OraLocaleInfo oraLocaleInfo = OraLocaleInfo.getInstance((String)DBConfig.getInstance().getString("NLS_LANG"), (String)DBConfig.getInstance().getString("NLS_TERR"));
            Locale locale = oraLocaleInfo.getLocale();
            try {
                this._graph.setLocale(locale);
            }
            catch (Throwable throwable) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, throwable.getStackTrace()[0].toString(), throwable);
            }
            this._graph.setCustomToolTipCallback((CustomToolTipCallback)new MyCustomToolTipCallback());
            this._spSql = new JScrollPane((Component)this._graph, 22, 32);
            this._spSql.setPreferredSize(new Dimension(400, 400));
        }
    }

    @Override
    public JComponent getUI() {
        this.init();
        return this._spSql;
    }

    public Graph getGraph() {
        return this._graph;
    }

    public String[] bindColNames() {
        return this.colNames;
    }

    public void disableRefreshInTask() {
        this.refreshInTask = false;
    }

    @Override
    public void refresh(boolean bl) {
        this.refresh(this.getConnection());
    }

    public void refresh(Connection connection) {
        CancellableQuery cancellableQuery = new CancellableQuery(this.refreshInTask){

            @Override
            protected void initialize(Connection connection) throws SQLException {
                DisplaySimpleChart.this.initializeRefresh(connection);
            }

            @Override
            protected PreparedStatement prepareStatement(Connection connection) throws SQLException {
                return DisplaySimpleChart.this.prepareRefreshStatement(connection);
            }

            @Override
            protected void loadData(ResultSet resultSet) throws SQLException {
                ArrayList arrayList = new ArrayList();
                DisplaySimpleChart.this.populateTabularData(resultSet, arrayList, this);
                DisplaySimpleChart.this.displayData(arrayList);
            }

            @Override
            protected void clearData() {
                ArrayList arrayList = new ArrayList();
                DisplaySimpleChart.this.displayData(arrayList);
            }

            @Override
            protected void handleException(Exception exception) {
                DisplaySimpleChart.this.handleException(exception);
            }
        };
        cancellableQuery.process(connection);
    }

    private void initializeRefresh(Connection connection) throws SQLException {
        this.init();
        MarkerText markerText = this._graph.getMarkerText();
        markerText.getViewFormat(0).setDecimalDigit(2);
        markerText.getViewFormat(1).setDecimalDigit(2);
        markerText.getViewFormat(2).setDecimalDigit(2);
        markerText.getViewFormat(3).setDecimalDigit(2);
        markerText.getViewFormat(4).setDecimalDigit(2);
    }

    private PreparedStatement prepareRefreshStatement(Connection connection) throws SQLException {
        String string = this.getQuery().getSql();
        if (string != null && !string.contains("--")) {
            string = string.replaceAll("\n", " ");
        }
        return DBUtil.getInstance((Connection)connection).prepareExecute(string, this.getBindMap());
    }

    private void displayData(final List<Object[]> list) {
        if (this.refreshInTask) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DisplaySimpleChart.this.doDisplayData(list);
                }
            });
        } else {
            this.doDisplayData(list);
        }
    }

    private void doDisplayData(List<Object[]> list) {
        boolean bl;
        this._graph.setVisible(false);
        if (list.size() > 0) {
            this._graph.setDataRowShownAsASeries(true);
        }
        if (bl = this._graph.setTabularData(list)) {
            this._graph.getO1TickLabel().setHorizontalAlignment(0);
        }
        this._graph.setVisible(true);
    }

    @Override
    public Map<String, Object> getBinds(Point point) {
        return this.getBindMap();
    }

    public Map<String, Object> getBinds() {
        return this.getBindMap();
    }

    @Override
    public Map<String, Object> getBindMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Map<Object, Object> map = new HashMap();
        try {
            map = super.getBindMap();
            hashMap.putAll(map);
            if (this._graph.getSelectedObject() != null) {
                int n = ((DataComponentHandle)this._graph.getSelectedObject()).getColumn();
                int n2 = ((DataComponentHandle)this._graph.getSelectedObject()).getRow();
                int n3 = ((DataComponentHandle)this._graph.getSelectedObject()).getSeries();
                int n4 = ((DataComponentHandle)this._graph.getSelectedObject()).getGroup();
                LocalXMLDataSource localXMLDataSource = (LocalXMLDataSource)this._graph.getDataSource();
                Object object = localXMLDataSource.getSliceLabel(0, n4, "label");
                Object object2 = localXMLDataSource.getSliceLabel(1, n3, "label");
                Object object3 = localXMLDataSource.getValue(n2, n, "dataValue");
                hashMap.put(this.colNames[0], object);
                hashMap.put(this.colNames[1], object2);
                hashMap.put(this.colNames[2], object3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashMap;
    }

    @Override
    public void addActions(List<ObjectAction> list) {
        _menu.setDisplay(this);
        _menu.setActions(list);
        _graphCM.addContextMenuListener((ContextMenuListener)_menu);
    }

    @Override
    public void clear() {
        this._graph.setVisible(false);
    }

    @Override
    public void parentSelectionChanged() {
        this.refresh(true);
    }

    @Override
    public void close() {
        _graphCM.removeContextMenuListener((ContextMenuListener)_menu);
        JScrollPane jScrollPane = this._spSql;
        this._spSql = null;
        if (jScrollPane != null && jScrollPane.getParent() != null) {
            jScrollPane.getParent().remove(jScrollPane);
        }
        super.close();
    }

    private String unquoteColumnName(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    private void populateTabularData(ResultSet resultSet, List<Object[]> list, CancellableQuery cancellableQuery) throws SQLException {
        int n = this.propMgr.get(PropertyType.DATA_MAP_COUNT, Integer.class);
        List list2 = this.propMgr.get(PropertyType.DATA_MAP_COLUMNS, List.class);
        List list3 = this.propMgr.get(PropertyType.DATA_MAP_SERIES, List.class);
        List list4 = this.propMgr.get(PropertyType.DATA_MAP_VALUES, List.class);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (int i = 1; i <= n2; ++i) {
            hashMap.put("\"" + resultSetMetaData.getColumnName(i) + "\"", i);
        }
        List<DataMap> list5 = this.createDataMaps(n, list2, list3, list4, hashMap);
        if (this.customMap || n2 < 3) {
            if (n > 0) {
                this.colNames[0] = this.unquoteColumnName((String)list2.get(0));
                this.colNames[1] = this.unquoteColumnName((String)list3.get(0));
                this.colNames[2] = this.unquoteColumnName((String)list4.get(0));
            } else {
                this.colNames[0] = "GROUP";
                this.colNames[1] = "SERIES";
                this.colNames[2] = "VALUE";
            }
        } else {
            this.colNames[0] = resultSet.getMetaData().getColumnName(1);
            this.colNames[1] = resultSet.getMetaData().getColumnName(2);
            this.colNames[2] = resultSet.getMetaData().getColumnName(3);
        }
        if (list5 != null) {
            final int n3 = DBConfig.getInstance().getInt("REPORTMAXCHARTROWS");
            int n4 = 0;
            while (cancellableQuery.continueLoading() && n4++ < n3 && resultSet.next()) {
                for (int i = 0; i < list5.size(); ++i) {
                    DataMap dataMap = list5.get(i);
                    Object[] objectArray = new Object[]{this.getTabularDataValue(resultSet, dataMap.columnMap), this.getTabularDataValue(resultSet, dataMap.seriesMap), this.getTabularDataValue(resultSet, dataMap.valueMap)};
                    list.add(objectArray);
                }
            }
            if (n4 >= n3) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)ControlsArb.format("REPORT_TOO_MANY_ROWS", n3), (String)ControlsArb.getString("REPORT_TOO_MANY_ROWS_TITLE"), null);
                    }
                });
            }
        }
    }

    private List<DataMap> createDataMaps(int n, List<String> list, List<String> list2, List<String> list3, Map<String, Integer> map) {
        ArrayList<DataMap> arrayList = null;
        if (n > 0) {
            ArrayList<DataMap> arrayList2 = new ArrayList<DataMap>();
            TreeSet<String> treeSet = new TreeSet<String>();
            for (int i = 0; i < n; ++i) {
                String string = list.get(i);
                String string2 = list2.get(i);
                String string3 = list3.get(i);
                if (!(string != null && !string.equals("") || string2 != null && !string2.equals("")) && (string3 == null || string3.equals(""))) continue;
                ItemMap itemMap = this.createItemMap(string, false, map, treeSet);
                ItemMap itemMap2 = this.createItemMap(string2, false, map, treeSet);
                ItemMap itemMap3 = this.createItemMap(string3, true, map, treeSet);
                DataMap dataMap = new DataMap(itemMap, itemMap2, itemMap3);
                arrayList2.add(dataMap);
            }
            if (treeSet.size() == 0) {
                arrayList = arrayList2;
            } else {
                this.handleInvalidColumnNames(treeSet);
            }
        }
        if (n <= 0 || arrayList != null && arrayList.size() == 0) {
            this.customMap = false;
            arrayList = new ArrayList<DataMap>();
            arrayList.add(new DataMap(new ItemMap(1, null, false), new ItemMap(2, null, false), new ItemMap(3, null, true)));
        } else {
            this.customMap = true;
        }
        return arrayList;
    }

    private void handleInvalidColumnNames(Set<String> set) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : set) {
            stringBuilder.append("\n        ");
            stringBuilder.append(string);
        }
        this.handleException(new SQLException(ControlsArb.format("CHART_MISSING_COLUMN_NAMES_MESSAGE", stringBuilder.toString())));
    }

    private ItemMap createItemMap(String string, boolean bl, Map<String, Integer> map, Set<String> set) {
        ItemMap itemMap = null;
        if (string != null && !string.equals("")) {
            if (string.startsWith("\"") && string.endsWith("\"")) {
                Integer n = map.get(string);
                if (n != null) {
                    itemMap = new ItemMap(n, null, bl);
                }
            } else {
                itemMap = new ItemMap(null, string, bl);
            }
        }
        if (itemMap == null) {
            if (string != null) {
                set.add(string);
            } else {
                set.add("<null>");
            }
        }
        return itemMap;
    }

    private Object getTabularDataValue(ResultSet resultSet, ItemMap itemMap) throws SQLException {
        Object object;
        block14: {
            object = null;
            try {
                if (itemMap.columnNumber != null) {
                    if (itemMap.expectNumber) {
                        try {
                            object = resultSet.getDouble(itemMap.columnNumber);
                        }
                        catch (SQLException sQLException) {
                            try {
                                object = resultSet.getBigDecimal(itemMap.columnNumber);
                                break block14;
                            }
                            catch (SQLException sQLException2) {
                                String string = resultSet.getString(itemMap.columnNumber);
                                try {
                                    object = Double.parseDouble(string);
                                    break block14;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    object = string;
                                }
                            }
                        }
                        break block14;
                    }
                    object = resultSet.getString(itemMap.columnNumber);
                    break block14;
                }
                if (itemMap.expectNumber) {
                    try {
                        object = Double.parseDouble(itemMap.literalValue);
                    }
                    catch (NumberFormatException numberFormatException) {
                        object = itemMap.literalValue;
                    }
                } else {
                    object = itemMap.literalValue;
                }
            }
            catch (SQLException sQLException) {
                object = "";
            }
        }
        return object;
    }

    private class ItemMap {
        Integer columnNumber;
        String literalValue;
        boolean expectNumber;

        ItemMap(Integer n, String string, boolean bl) {
            this.columnNumber = n;
            this.literalValue = string;
            this.expectNumber = bl;
        }
    }

    private class DataMap {
        ItemMap columnMap;
        ItemMap seriesMap;
        ItemMap valueMap;

        DataMap(ItemMap itemMap, ItemMap itemMap2, ItemMap itemMap3) {
            this.columnMap = itemMap;
            this.seriesMap = itemMap2;
            this.valueMap = itemMap3;
        }
    }

    private class MyCustomToolTipCallback
    implements CustomToolTipCallback {
        private MyCustomToolTipCallback() {
        }

        public String getToolTipText(String string, ComponentHandle componentHandle) {
            String string2 = string;
            if (string2 != null && !DisplaySimpleChart.this.customMap) {
                string2 = string2.replace("Group:", "Group (" + DisplaySimpleChart.this.colNames[0] + "):");
                string2 = string2.replace("Series:", "Series (" + DisplaySimpleChart.this.colNames[1] + "):");
                string2 = string2.replace("Value:", "Value (" + DisplaySimpleChart.this.colNames[2] + "):");
            }
            return string2;
        }
    }
}

