/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.celleditor;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractSpinnerModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.celleditor.ICellEditor;

public abstract class AbstractCustomCellEditor
implements ICellEditor {
    protected Component editorComp;
    protected static final Object NULLVALUE = DBConfig.getInstance().getString("NULLDISPLAY");

    protected JComboBox getBooleanJComboBox(JTable jTable, Object object, boolean bl, boolean bl2) {
        JComboBox jComboBox = this.getJComboBox(jTable, new Object[]{Boolean.TRUE, Boolean.FALSE}, bl, bl2);
        if (object != null) {
            if (object instanceof Boolean) {
                jComboBox.setSelectedItem(object);
            } else {
                jComboBox.setSelectedItem(Boolean.valueOf(object.toString().toUpperCase()));
            }
        }
        this.editorComp = jComboBox;
        return jComboBox;
    }

    protected JComboBox getJComboBox(final JTable jTable, Object[] objectArray, boolean bl, boolean bl2) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(objectArray);
        if (bl2) {
            jComboBox.insertItemAt(NULLVALUE, 0);
        }
        jComboBox.setEditable(bl);
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    jTable.editingStopped(null);
                }
            }
        });
        this.editorComp = jComboBox;
        return jComboBox;
    }

    protected JSpinner getJSpinner(JTable jTable, AbstractSpinnerModel abstractSpinnerModel) {
        JSpinner jSpinner = new JSpinner(abstractSpinnerModel);
        this.editorComp = jSpinner;
        return jSpinner;
    }

    @Override
    public Object getValue() {
        if (this.editorComp == null) {
            return null;
        }
        if (this.editorComp instanceof JTextField) {
            return ((JTextField)this.editorComp).getText();
        }
        if (this.editorComp instanceof JComboBox) {
            Object object = ((JComboBox)this.editorComp).getSelectedItem();
            if (object != null && object.toString().equalsIgnoreCase("null")) {
                object = null;
            }
            return object;
        }
        if (this.editorComp instanceof JSpinner) {
            try {
                ((JSpinner)this.editorComp).commitEdit();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return ((JSpinner)this.editorComp).getValue();
        }
        if (this.editorComp instanceof JLabel) {
            return ((JLabel)this.editorComp).getText();
        }
        return null;
    }
}

