/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractSpinnerModel;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.datatypes.objects.OraIntervalDatum;
import oracle.dbtools.raptor.ui.LayoutControl;

public class IntervalController
implements PropertyChangeListener {
    protected static final String PLUS = "+";
    protected static final String MINUS = "-";
    protected static final String COLON = ":";
    protected static final String HACHE = "#";
    protected static final String ZERO = "0";
    protected OraIntervalDatum _intervalModel;
    protected boolean _enabled = true;
    protected boolean _hasChanged = false;
    protected Locale locale = Locale.getDefault();
    protected String _name;
    private JComponent[] _components;
    private OraIntervalDatum.MetaData metadata;
    private EditorPanel _editorPanel;
    private char decimalSeparator = new DecimalFormatSymbols(this.locale).getDecimalSeparator();

    protected static boolean areEqual(Object object, Object object2) {
        return object == object2 || object != null && object2 != null && object.equals(object2);
    }

    public IntervalController(OraIntervalDatum oraIntervalDatum, boolean bl) {
        this._enabled = bl;
        this._intervalModel = oraIntervalDatum;
        this.metadata = oraIntervalDatum.getMetaData();
        this._name = null;
        OraIntervalDatum.Field[] fieldArray = this.metadata.getFields();
        this._components = new JComponent[fieldArray.length];
        for (int i = 0; i < fieldArray.length; ++i) {
            JSpinner.NumberEditor numberEditor;
            int n;
            Serializable serializable;
            Serializable serializable2;
            final OraIntervalDatum.Field field = fieldArray[i];
            int n2 = this._intervalModel.get(this.metadata.getFieldOrdinal(field));
            if (field == OraIntervalDatum.Field.SIGN) {
                serializable2 = new JButton(n2 == -1 ? MINUS : PLUS);
                ((AbstractButton)serializable2).setEnabled(this._enabled);
                serializable = new AbstractAction(PLUS){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        IntervalController.this.change_field(field, ((JButton)actionEvent.getSource()).getText().equals(IntervalController.MINUS) ? 1 : -1);
                    }
                };
                ((AbstractButton)serializable2).setAction((Action)((Object)serializable));
                this._components[i] = serializable2;
                continue;
            }
            int n3 = field.getMinValue();
            int n4 = field.getMaxValue();
            if (field == OraIntervalDatum.Field.NANOS) {
                int n5 = (int)Math.pow(10.0, this._intervalModel.getFractionalPrecision());
                n = n5 - 1;
                if (n4 == -1 || n < n4) {
                    n4 = n;
                }
                String string = IntervalController.getNumberPattern(field.getMinDisplayPrecision(), field.getMaxDisplayPrecision(), this._intervalModel.getFractionalPrecision());
                serializable2 = new SpinnerNumberModel(n3, n3, n4, 1);
                serializable = new NanoSpinner((SpinnerModel)((Object)serializable2));
                numberEditor = ((NanoSpinner)serializable).getNanoEditor((NanoSpinner)serializable, string);
            } else {
                String string;
                if (this.metadata.getFieldOrdinal(field) == 1) {
                    n = (int)Math.pow(10.0, this._intervalModel.getLeadingPrecision());
                    int n6 = n - 1;
                    if (n4 == -1 || n6 < n4) {
                        n4 = n6;
                    }
                    string = IntervalController.getNumberPattern(field.getMinDisplayPrecision(), field.getMaxDisplayPrecision(), this._intervalModel.getLeadingPrecision());
                } else {
                    string = IntervalController.getNumberPattern(field.getMinDisplayPrecision(), field.getMaxDisplayPrecision(), -1);
                }
                serializable2 = new SpinnerNumberModel(n3, n3, n4, 1);
                serializable = new NamedSpinner((SpinnerModel)((Object)serializable2));
                numberEditor = new JSpinner.NumberEditor((JSpinner)serializable, string);
            }
            ((JSpinner)serializable).setEditor(numberEditor);
            ((SpinnerNumberModel)serializable2).setValue(n2);
            ((JComponent)serializable).setEnabled(this._enabled);
            ((AbstractSpinnerModel)serializable2).addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    IntervalController.this.change_field(field, ((SpinnerNumberModel)changeEvent.getSource()).getNumber().intValue());
                }
            });
            this._components[i] = serializable;
        }
        this.setName("intervalController");
        this._intervalModel.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void setName(String string) {
        this._name = string;
        if (this._name != null) {
            OraIntervalDatum.Field[] fieldArray = this.metadata.getFields();
            for (int i = 0; i < this._components.length; ++i) {
                String string2 = this._name + "." + fieldArray[i].name();
                this._components[i].setName(string2);
            }
        }
    }

    private static String getNumberPattern(int n, int n2, int n3) {
        int n4;
        int n5 = n;
        int n6 = n2;
        if (n5 == -1) {
            n5 = n3;
        }
        if (n6 == -1 || n3 >= 0 && n3 < n6) {
            n6 = n3;
        }
        if (n5 == -1) {
            n5 = 1;
        }
        if (n6 == -1 || n6 < n5) {
            n6 = n5;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n4 = n6; n4 > n5; --n4) {
            stringBuffer.append(HACHE);
        }
        for (n4 = n5; n4 > 0; --n4) {
            stringBuffer.append(ZERO);
        }
        return stringBuffer.toString();
    }

    public OraIntervalDatum getModel() {
        return (OraIntervalDatum)this._intervalModel.clone();
    }

    public void setChanged(boolean bl) {
        this._hasChanged = bl;
    }

    public boolean hasChanged() {
        return this._hasChanged;
    }

    public void setEnabled(boolean bl) {
        this._enabled = bl;
        for (JComponent jComponent : this._components) {
            jComponent.setEnabled(this._enabled);
        }
    }

    public boolean isEnabled() {
        for (JComponent jComponent : this._components) {
            if (!jComponent.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public void setEditable(boolean bl) {
        this.setEnabled(bl);
    }

    public boolean isEditable() {
        return this.isEnabled();
    }

    public JComponent getFieldComponent(int n) {
        return this._components[n];
    }

    public EditorPanel getEditorPanel() {
        return this.getEditorPanel(false);
    }

    public EditorPanel getEditorPanel(boolean bl) {
        return this.getEditorPanel(bl, true);
    }

    public EditorPanel getEditorPanel(boolean bl, boolean bl2) {
        return this.getEditorPanel(bl, bl2, true);
    }

    public EditorPanel getEditorPanel(boolean bl, boolean bl2, boolean bl3) {
        if (this._editorPanel == null) {
            this._editorPanel = new EditorPanel(new GridBagLayout());
            if (this._name != null) {
                this._editorPanel.setName(this._name + ".editorPanel");
            }
            int n = 0;
            OraIntervalDatum.Field[] fieldArray = this.metadata.getFields();
            OraIntervalDatum.Field field = null;
            for (int i = 0; i < fieldArray.length; ++i) {
                Object object;
                OraIntervalDatum.Field field2 = fieldArray[i];
                if (this._components[i] == null) continue;
                if (field != null) {
                    object = null;
                    if (field == OraIntervalDatum.Field.SIGN) {
                        object = " ";
                    } else if (i > 0) {
                        if (field2 == OraIntervalDatum.Field.NANOS) {
                            if (bl3) {
                                object = Character.toString(this.getDecimalSeparator());
                            }
                        } else {
                            object = field2 == OraIntervalDatum.Field.MONTHS ? MINUS : COLON;
                        }
                    }
                    if (object != null) {
                        this._editorPanel.add((Component)new JLabel((String)object), LayoutControl.GBC.gbc(n++, bl ? 1 : 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, LayoutControl.GBC.Fill.NONE, LayoutControl.GBC.Spring.NONE, LayoutControl.GBC.Anchor.CENTER));
                    }
                }
                if (field2 == OraIntervalDatum.Field.SIGN && !bl2 || field2 == OraIntervalDatum.Field.NANOS && !bl3) continue;
                this._editorPanel.add((Component)this._components[i], LayoutControl.GBC.gbc(n, bl ? 1 : 0, 1, 1, bl ? LayoutControl.GBC.Inset.LINE_START_COMP : LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
                if (bl) {
                    switch (field2) {
                        case YEARS: {
                            object = "IntervalEditPanel.5";
                            break;
                        }
                        case MONTHS: {
                            object = "IntervalEditPanel.6";
                            break;
                        }
                        case DAYS: {
                            object = "IntervalEditPanel.1";
                            break;
                        }
                        case HOURS: {
                            object = "IntervalEditPanel.2";
                            break;
                        }
                        case MINUTES: {
                            object = "IntervalEditPanel.3";
                            break;
                        }
                        case SECONDS: {
                            object = "IntervalEditPanel.4";
                            break;
                        }
                        default: {
                            object = null;
                        }
                    }
                    if (object != null) {
                        this._editorPanel.add((Component)new JLabel(Messages.getString((String)object)), LayoutControl.GBC.gbc(n, 0, i == fieldArray.length ? 1 : 2, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
                    }
                }
                if (field2 == OraIntervalDatum.Field.SIGN) {
                    object = this._components[i].getPreferredSize();
                    this._components[i].setPreferredSize((Dimension)object);
                    this._components[i].setMinimumSize((Dimension)object);
                }
                ++n;
                field = field2;
            }
        }
        return this._editorPanel;
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public boolean change_field(OraIntervalDatum.Field field, int n) {
        boolean bl = false;
        int n2 = this.metadata.getFieldOrdinal(field);
        if (this._intervalModel.get(n2) != n) {
            this._intervalModel.set(n2, n);
            bl = true;
        }
        return bl;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!propertyChangeEvent.getPropertyName().equals("FRACTIONALPRECISION") && !propertyChangeEvent.getPropertyName().equals("LEADINGPRECISION")) {
            try {
                OraIntervalDatum.Field field = this.metadata.getField(propertyChangeEvent.getPropertyName());
                int n = this.metadata.getFieldOrdinal(field);
                int n2 = (Integer)propertyChangeEvent.getNewValue();
                if (field == OraIntervalDatum.Field.SIGN) {
                    int n3;
                    JButton jButton = (JButton)this._components[n];
                    int n4 = n3 = jButton.getText().equals(MINUS) ? -1 : 1;
                    if (n3 != n2) {
                        jButton.setText(n2 == -1 ? MINUS : PLUS);
                    }
                } else {
                    JSpinner jSpinner = (JSpinner)this._components[n];
                    SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)jSpinner.getModel();
                    int n5 = spinnerNumberModel.getNumber().intValue();
                    if (n5 != n2) {
                        spinnerNumberModel.setValue(n2);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setChanged(true);
    }

    public class EditorPanel
    extends JPanel {
        public EditorPanel(LayoutManager layoutManager) {
            super(layoutManager);
        }

        public JComponent getDefaultComponent() {
            for (int i = 1; i < IntervalController.this._components.length; ++i) {
                if (IntervalController.this._components[i] == null) continue;
                return IntervalController.this._components[i];
            }
            return IntervalController.this._components[0];
        }
    }

    public class NanoSpinner
    extends NamedSpinner {
        public NanoSpinner(SpinnerModel spinnerModel) {
            super(spinnerModel);
        }

        public NanoEditor getNanoEditor(NanoSpinner nanoSpinner, String string) {
            return new NanoEditor(nanoSpinner, string);
        }

        public int getPrecision() {
            return ((NanoEditor)this.getEditor()).getPrecision();
        }

        @Override
        public void enable() {
            if (IntervalController.this._intervalModel.nanosSupported()) {
                super.enable();
            }
        }

        @Override
        public void enable(boolean bl) {
            if (!bl || IntervalController.this._intervalModel.nanosSupported()) {
                super.enable(bl);
            }
        }

        @Override
        public void disable() {
            super.disable();
        }

        @Override
        public void setEnabled(boolean bl) {
            if (!bl || IntervalController.this._intervalModel.nanosSupported()) {
                super.setEnabled(bl);
            }
        }

        public class NanoEditor
        extends JSpinner.NumberEditor {
            private NanoFormat format;

            public NanoEditor(NanoSpinner nanoSpinner2, String string) {
                this(nanoSpinner2, new NanoFormat(string, string.length()));
            }

            private NanoEditor(NanoSpinner nanoSpinner2, DecimalFormat decimalFormat) {
                super(nanoSpinner2);
                this.format = (NanoFormat)decimalFormat;
                if (!(nanoSpinner2.getModel() instanceof SpinnerNumberModel)) {
                    throw new IllegalArgumentException("model not a SpinnerNumberModel");
                }
                SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)nanoSpinner2.getModel();
                NumberEditorFormatter numberEditorFormatter = new NumberEditorFormatter(spinnerNumberModel, decimalFormat);
                DefaultFormatterFactory defaultFormatterFactory = new DefaultFormatterFactory(numberEditorFormatter);
                JFormattedTextField jFormattedTextField = this.getTextField();
                jFormattedTextField.setEditable(true);
                jFormattedTextField.setFormatterFactory(defaultFormatterFactory);
                jFormattedTextField.setHorizontalAlignment(4);
                try {
                    String string = numberEditorFormatter.valueToString(spinnerNumberModel.getMinimum());
                    String string2 = numberEditorFormatter.valueToString(spinnerNumberModel.getMaximum());
                    jFormattedTextField.setColumns(Math.max(string.length(), string2.length()));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }

            public int getPrecision() {
                return this.format.getPrecision();
            }

            @Override
            public void enable() {
                if (IntervalController.this._intervalModel.nanosSupported()) {
                    super.enable();
                }
            }

            @Override
            public void enable(boolean bl) {
                if (!bl || IntervalController.this._intervalModel.nanosSupported()) {
                    super.enable(bl);
                }
            }

            @Override
            public void disable() {
                super.disable();
            }

            @Override
            public void setEnabled(boolean bl) {
                if (!bl || IntervalController.this._intervalModel.nanosSupported()) {
                    super.setEnabled(bl);
                }
            }
        }
    }

    public class NamedSpinner
    extends JSpinner {
        public NamedSpinner(SpinnerModel spinnerModel) {
            super(spinnerModel);
        }

        @Override
        public void setName(String string) {
            this.setEditorFieldName(this.getEditor(), string, true);
            super.setName(string);
        }

        protected void setEditorFieldName(JComponent jComponent, String string, boolean bl) {
            Component component;
            block3: {
                component = null;
                try {
                    component = jComponent.getComponent(0);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    if (component instanceof JPanel) break block3;
                    component = jComponent;
                }
            }
            if (component != null && (bl || component.getName() == null)) {
                component.setName(string == null ? null : string + "." + "editorField");
            }
        }

        @Override
        public void setEditor(JComponent jComponent) {
            this.setEditorFieldName(jComponent, this.getName(), false);
            super.setEditor(jComponent);
        }
    }

    private static class NanoFormat
    extends DecimalFormat {
        int precision;

        public NanoFormat(String string, int n) {
            super(string);
            this.precision = n;
        }

        @Override
        public Number parse(String string, ParsePosition parsePosition) {
            String string2 = string;
            if (string2 != null && string2.length() < this.precision) {
                StringBuilder stringBuilder = new StringBuilder(string2);
                while (stringBuilder.length() < this.precision) {
                    stringBuilder.append('0');
                }
                string2 = stringBuilder.toString();
            }
            return super.parse(string2, parsePosition);
        }

        public int getPrecision() {
            return this.precision;
        }
    }

    private static class NumberEditorFormatter
    extends NumberFormatter {
        private final SpinnerNumberModel model;

        NumberEditorFormatter(SpinnerNumberModel spinnerNumberModel, NumberFormat numberFormat) {
            super(numberFormat);
            this.model = spinnerNumberModel;
            this.setValueClass(spinnerNumberModel.getValue().getClass());
        }

        public void setMinimum(Comparable comparable) {
            this.model.setMinimum(comparable);
        }

        public Comparable getMinimum() {
            return this.model.getMinimum();
        }

        public void setMaximum(Comparable comparable) {
            this.model.setMaximum(comparable);
        }

        public Comparable getMaximum() {
            return this.model.getMaximum();
        }
    }
}

