/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.util.TreeMap;
import java.util.logging.Logger;
import oracle.dbtools.raptor.config.NavigatorFilterPanel;
import oracle.ide.config.Preferences;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

public class NavigatorFilterConfig
extends HashStructureAdapter
implements Copyable {
    public static final String NAVIGATIONFILTER = "NAVIGATIONFILTER";
    public static final String ENABLE_FEATURE = "ENABLE_FEATURE";
    public static final String ORACLE = "ORACLE";
    public static final String MYSQL = "MYSQL";
    public static final String DB2 = "DB2";
    public static final String ACCESS = "ACCESS";
    public static final String SQLSERVER = "SQLSERVER";
    public static final String SYBASE = "SYBASE";
    public static final String TIMESTEN = "TIMESTEN";
    public static final String TERADATA = "TERADATA";
    public static final String POSTGRESQL = "POSTGRESQL";
    public static final String OLAP_JOBS = "OLAPJOBS";
    public static final String OLAP_OPTION = "OLAP OPTION";
    private static final Logger LOGGER = Logger.getLogger(NavigatorFilterConfig.class.getName());
    private HashStructure hs = HashStructure.newInstance();
    private NavigatorFilterPanel navigatorFilterPanel = null;

    private NavigatorFilterConfig(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static NavigatorFilterConfig getInstance(PropertyStorage propertyStorage) {
        return new NavigatorFilterConfig(NavigatorFilterConfig.findOrCreate((PropertyStorage)propertyStorage, (String)NAVIGATIONFILTER));
    }

    public static NavigatorFilterConfig getInstance(TraversableContext traversableContext) {
        return NavigatorFilterConfig.getInstance(traversableContext.getPropertyStorage());
    }

    public static synchronized NavigatorFilterConfig getInstance() {
        Preferences preferences = Preferences.getPreferences();
        return NavigatorFilterConfig.getInstance((PropertyStorage)preferences);
    }

    public NavigatorFilterConfig() {
        super(HashStructure.newInstance());
    }

    public void setFeatureEnabled(boolean bl) {
        this.storeAllElements(null, ENABLE_FEATURE, bl);
    }

    public void putAllOracleElements(TreeMap<String, Object> treeMap) {
        this.storeAllElements(treeMap, ORACLE, true);
    }

    public void putAllMySQLElements(TreeMap<String, Object> treeMap) {
        this.storeAllElements(treeMap, MYSQL, true);
    }

    public void putAllDB2Elements(TreeMap<String, Object> treeMap) {
        this.storeAllElements(treeMap, DB2, true);
    }

    public void putAllTeradataElements(TreeMap<String, Object> treeMap) {
        this.storeAllElements(treeMap, TERADATA, true);
    }

    public void putAllSybaseElements(TreeMap<String, Object> treeMap) {
        this.storeAllElements(treeMap, SYBASE, true);
    }

    public void putAllTimesTenElements(TreeMap<String, Object> treeMap) {
        this.storeAllElements(treeMap, TIMESTEN, true);
    }

    public void putAllPostGreSQLElements(TreeMap<String, Object> treeMap) {
        this.storeAllElements(treeMap, POSTGRESQL, true);
    }

    public void putAllSQLServerElements(TreeMap<String, Object> treeMap) {
        this.storeAllElements(treeMap, SQLSERVER, true);
    }

    public void putAllAccessElements(TreeMap<String, Object> treeMap) {
        this.storeAllElements(treeMap, ACCESS, true);
    }

    private HashStructure mapToHashStructure(TreeMap<String, Object> treeMap) {
        HashStructure hashStructure = HashStructure.newInstance();
        if (treeMap != null) {
            for (String string : treeMap.keySet()) {
                Object object = treeMap.get(string);
                if (object instanceof Boolean) {
                    boolean bl = (Boolean)object;
                    hashStructure.putBoolean(string, bl);
                }
                if (!(object instanceof TreeMap)) continue;
                HashStructure hashStructure2 = HashStructure.newInstance();
                for (String string2 : ((TreeMap)object).keySet()) {
                    if (string2 == null) continue;
                    Boolean bl = (Boolean)((TreeMap)object).get(string2);
                    hashStructure2.putBoolean(string2, bl.booleanValue());
                }
                hashStructure.putHashStructure(string, hashStructure2);
            }
        }
        return hashStructure;
    }

    private void storeAllElements(TreeMap<String, Object> treeMap, String string, boolean bl) {
        HashStructure hashStructure;
        if (string.equals(ENABLE_FEATURE)) {
            this.hs.putBoolean(ENABLE_FEATURE, bl);
        }
        if (string.equals(ORACLE)) {
            hashStructure = this.mapToHashStructure(treeMap);
            this.hs.putHashStructure(ORACLE, hashStructure);
        }
        if (string.equals(MYSQL)) {
            hashStructure = this.mapToHashStructure(treeMap);
            this.hs.putHashStructure(MYSQL, hashStructure);
        }
        if (string.equals(DB2)) {
            hashStructure = this.mapToHashStructure(treeMap);
            this.hs.putHashStructure(DB2, hashStructure);
        }
        if (string.equals(SYBASE)) {
            hashStructure = this.mapToHashStructure(treeMap);
            this.hs.putHashStructure(SYBASE, hashStructure);
        }
        if (string.equals(TERADATA)) {
            hashStructure = this.mapToHashStructure(treeMap);
            this.hs.putHashStructure(TERADATA, hashStructure);
        }
        if (string.equals(TIMESTEN)) {
            hashStructure = this.mapToHashStructure(treeMap);
            this.hs.putHashStructure(TIMESTEN, hashStructure);
        }
        if (string.equals(SQLSERVER)) {
            hashStructure = this.mapToHashStructure(treeMap);
            this.hs.putHashStructure(SQLSERVER, hashStructure);
        }
        if (string.equals(POSTGRESQL)) {
            hashStructure = this.mapToHashStructure(treeMap);
            this.hs.putHashStructure(POSTGRESQL, hashStructure);
        }
        if (string.equals(ACCESS)) {
            hashStructure = this.mapToHashStructure(treeMap);
            this.hs.putHashStructure(POSTGRESQL, hashStructure);
        }
        this._hash.putHashStructure(NAVIGATIONFILTER, this.hs);
    }

    public TreeMap<String, Object> getAllOracleElements() {
        TreeMap<String, Object> treeMap = this.getAllElements(ORACLE);
        return treeMap;
    }

    public TreeMap<String, Object> getAllMySQLElements() {
        TreeMap<String, Object> treeMap = this.getAllElements(MYSQL);
        return treeMap;
    }

    public TreeMap<String, Object> getAllDB2Elements() {
        TreeMap<String, Object> treeMap = this.getAllElements(DB2);
        return treeMap;
    }

    public TreeMap<String, Object> getAllSybaseElements() {
        TreeMap<String, Object> treeMap = this.getAllElements(SYBASE);
        return treeMap;
    }

    public TreeMap<String, Object> getAllTeradataElements() {
        TreeMap<String, Object> treeMap = this.getAllElements(TERADATA);
        return treeMap;
    }

    public TreeMap<String, Object> getAllTimesTenElements() {
        TreeMap<String, Object> treeMap = this.getAllElements(TIMESTEN);
        return treeMap;
    }

    public TreeMap<String, Object> getAllSQLServerElements() {
        TreeMap<String, Object> treeMap = this.getAllElements(SQLSERVER);
        return treeMap;
    }

    public TreeMap<String, Object> getAllPostGreSQLElements() {
        TreeMap<String, Object> treeMap = this.getAllElements(POSTGRESQL);
        return treeMap;
    }

    public TreeMap<String, Object> getAllAccessElements() {
        TreeMap<String, Object> treeMap = this.getAllElements(ACCESS);
        return treeMap;
    }

    public boolean isFeatureEnabled() {
        HashStructure hashStructure;
        boolean bl = false;
        Object object = this._hash.getObject(NAVIGATIONFILTER);
        if (object != null && object instanceof HashStructure && (hashStructure = (HashStructure)object) != null) {
            bl = hashStructure.getBoolean(ENABLE_FEATURE);
        }
        return bl;
    }

    private TreeMap<String, Object> getAllElements(String string) {
        HashStructure hashStructure;
        TreeMap<String, Object> treeMap = null;
        Object object = this._hash.getObject(NAVIGATIONFILTER);
        if (object != null && object instanceof HashStructure && (hashStructure = (HashStructure)object) != null) {
            HashStructure hashStructure2 = hashStructure.getHashStructure(string);
            if (hashStructure2 != null) {
                // empty if block
            }
            treeMap = this.hashStructureToMap(hashStructure2);
        }
        return treeMap;
    }

    private TreeMap<String, Object> hashStructureToMap(HashStructure hashStructure) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        boolean bl = false;
        if (hashStructure != null) {
            for (String string : hashStructure.keySet()) {
                Object object = hashStructure.getObject(string);
                if (object == null) continue;
                if (object instanceof String) {
                    treeMap.put(string, new Boolean(object.toString()));
                }
                if (!(object instanceof HashStructure)) continue;
                TreeMap<String, Boolean> treeMap2 = new TreeMap<String, Boolean>();
                for (String string2 : ((HashStructure)object).keySet()) {
                    Boolean bl2 = ((HashStructure)object).getBoolean(string2);
                    treeMap2.put(string2, bl2);
                }
                treeMap.put(string, treeMap2);
            }
        }
        return treeMap;
    }

    private void printTreeMap(TreeMap<String, Object> treeMap, String string) {
        if (treeMap != null) {
            for (String string2 : treeMap.keySet()) {
                Object object = treeMap.get(string2);
                if (object == null) continue;
                if (object instanceof Boolean) {
                    System.out.println("          \t[" + string2 + "," + object + "]");
                }
                if (!(object instanceof TreeMap)) continue;
                this.printTreeMap((TreeMap)object, string2);
            }
        }
    }

    public void updateNavigationFilterPreferences(String string) {
        NavigatorFilterPanel navigatorFilterPanel = this.getNavigationPanel();
        if (this.getNavigationPanel() != null) {
            if (string.equals(ORACLE)) {
                navigatorFilterPanel.updateOraclePreferences(this);
            }
            if (string.equals(MYSQL)) {
                navigatorFilterPanel.updateMySQLPreferences(this);
            }
            if (string.equals(DB2)) {
                navigatorFilterPanel.updateDB2Preferences(this);
            }
            if (string.equals(SQLSERVER)) {
                navigatorFilterPanel.updateSQLServerPreferences(this);
            }
            if (string.equals(SYBASE)) {
                navigatorFilterPanel.updateSybasePreferences(this);
            }
            if (string.equals(TERADATA)) {
                navigatorFilterPanel.updateTeradataPreferences(this);
            }
            if (string.equals(TIMESTEN)) {
                navigatorFilterPanel.updateTimesTenPreferences(this);
            }
            if (string.equals(ACCESS)) {
                navigatorFilterPanel.updateAccessPreferences(this);
            }
            if (string.equals(POSTGRESQL)) {
                navigatorFilterPanel.updatePostGreSQLPreferences(this);
            }
        }
    }

    public void setNavigationPanel(NavigatorFilterPanel navigatorFilterPanel) {
        this.navigatorFilterPanel = navigatorFilterPanel;
    }

    public NavigatorFilterPanel getNavigationPanel() {
        return this.navigatorFilterPanel;
    }
}

