/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JLabel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.data.ui.EncodingsPanel;
import oracle.dbtools.raptor.data.ui.LoadLimitPanel;
import oracle.dbtools.raptor.data.ui.MaxLengthPanel;
import oracle.dbtools.raptor.data.ui.PreviewLimitPanel;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class ImportPreferences
extends DefaultTraversablePanel {
    private URLFileChooser.URLFileChooserPanel importFilePanel;
    private PreviewLimitPanel previewLimitPanel;
    private LoadLimitPanel loadLimitPanel;
    private MaxLengthPanel maxLengthPanel;
    private EncodingsPanel encodingsPanel;
    private static final long serialVersionUID = -2739487292165944123L;

    public ImportPreferences() {
        this.setHelpID("f1_dbworksheetImportparam_html");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        int n = 1;
        JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)Messages.getString("ImportPreferences.3")));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("ImportPreferences.3")));
        this.importFilePanel = URLFileChooser.createURLFileChooserPanel(0, StringUtils.stripMnemonic((String)Messages.getString("ImportPreferences.3")), false, false);
        this.importFilePanel.setSelectionScope(1);
        this.importFilePanel.setPathContext("IMPORTDIR");
        jLabel.setLabelFor(this.importFilePanel);
        this.add(jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(18, 0, 0, 8), 0, 0));
        this.add(this.importFilePanel, new GridBagConstraints(1, n, 2, 1, 1.0, 0.0, 18, 2, new Insets(16, 0, 0, 0), 0, 0));
        this.encodingsPanel = new EncodingsPanel();
        JLabel jLabel2 = new JLabel(StringUtils.stripMnemonic((String)PreferencesArb.getString("IMPORT_ENCODING")));
        jLabel2.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("IMPORT_ENCODING")));
        jLabel2.setLabelFor(this.encodingsPanel.getEncodingComboBox());
        this.add(jLabel2, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 0, 0, 8), 0, 0));
        this.add(this.encodingsPanel, new GridBagConstraints(1, n, 2, 1, 1.0, 0.0, 18, 0, new Insets(6, 0, 0, 0), 0, 0));
        this.loadLimitPanel = new LoadLimitPanel(false);
        this.add(this.loadLimitPanel.getUseLoadLimitComponent(), new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 0, 0, 8), 0, 0));
        this.add((Component)this.loadLimitPanel.getLoadLimitComponent(), new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 0, 0, 0), 0, 0));
        this.previewLimitPanel = new PreviewLimitPanel(false);
        this.add(this.previewLimitPanel.getPreviewLimitCheckBox(), new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 0, 0, 8), 0, 0));
        this.add((Component)this.previewLimitPanel.getPreviewLimitSpinBox(), new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 0, 0, 0), 0, 0));
        this.maxLengthPanel = new MaxLengthPanel();
        this.add(this.maxLengthPanel.getMaxLengthCheckBox(), new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 0, 0, 8), 0, 0));
        this.add((Component)this.maxLengthPanel.getMaxLengthSpinBox(), new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 0, 0, 0), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this.importFilePanel.setText(dBConfig.getString("IMPORTDIR"));
        this.encodingsPanel.onEntry(traversableContext);
        this.previewLimitPanel.onEntry(traversableContext);
        this.loadLimitPanel.onEntry(traversableContext);
        this.maxLengthPanel.onEntry(traversableContext);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putString("IMPORTDIR", this.importFilePanel.getText());
        this.encodingsPanel.onExit(traversableContext);
        this.previewLimitPanel.onExit(traversableContext);
        this.loadLimitPanel.onExit(traversableContext);
        this.maxLengthPanel.onExit(traversableContext);
    }
}

