/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.raptor.Messages;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.refactor.CaseConverter;
import oracle.ide.ceditor.options.OptionsArb;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;

public final class CodeCompletionOptionsPanel
extends DefaultTraversablePanel
implements ChangeListener,
ActionListener {
    private JCheckBox checkbox_WScompletionEnablePopup = new JCheckBox();
    private JCheckBox checkbox_PLScompletionEnablePopup = new JCheckBox();
    private JCheckBox checkbox_completionEnablePopup = new JCheckBox();
    private JSlider slider_completionPopupDelay = new JSlider(1, 30, 10);
    private JLabel label_completionSliderMax = new JLabel(Messages.getString("label_PLScompletionSliderMax"));
    private JLabel label_completionSliderMin = new JLabel(Messages.getString("label_PLScompletionSliderMin"));
    private JLabel label_completionPopupDelayText = new JLabel();
    private JLabel label_completionTriggerListSize = new JLabel(Messages.getString("label_completionTriggerListSize"));
    private JLabel label_completionTriggerListSize1 = new JLabel(Messages.getString("label_completionTriggerListSize1"));
    private WholeNumberField maxTriggerCompletionListSize = new WholeNumberField(3);
    private JCheckBox checkbox_includeSynonyms = new JCheckBox();
    private JCheckBox checkbox_autoGenerateAliases = new JCheckBox();
    private JCheckBox checkbox_semanticAnalysis = new JCheckBox();
    private JCheckBox checkbox_autoFormat = new JCheckBox();
    private JComboBox combo_formats = new JComboBox();
    private NumberFormat numberFormatter;

    public CodeCompletionOptionsPanel() {
        this.setHelpID("f1_idedidesetcodeinsight_html");
        this.setLayout(new GridBagLayout());
        this.jbInit();
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        Boolean bl = dBConfig.getBoolean("ENABLECOMPLETIONWORKSHEET");
        this.checkbox_WScompletionEnablePopup.setSelected(bl);
        bl = dBConfig.getBoolean("ENABLECOMPLETIONPLSQLEDITOR");
        this.checkbox_PLScompletionEnablePopup.setSelected(bl);
        int n = dBConfig.getInt("DELAYCOMPLETION");
        this.slider_completionPopupDelay.setValue(n / 100);
        int n2 = dBConfig.getInt("MAXTRIGGERCOMPLETIONLISTSIZE");
        this.maxTriggerCompletionListSize.setValue(n2);
        bl = dBConfig.getBoolean("QUERYSYNONYMS");
        this.checkbox_includeSynonyms.setSelected(bl);
        bl = dBConfig.getBoolean("AUTOGENERATEALIASES");
        this.checkbox_autoGenerateAliases.setSelected(bl);
        bl = dBConfig.getBoolean("SEMANTICANALYSISINFOTIP");
        this.checkbox_semanticAnalysis.setSelected(bl);
        bl = dBConfig.getBoolean("AUTOFORMAT");
        this.checkbox_autoFormat.setSelected(bl);
        this.combo_formats.setModel(new DefaultComboBoxModel<CaseConverter.CASE>(CaseConverter.CASE.values()));
        this.combo_formats.setSelectedItem((Object)CaseConverter.getState());
        this.combo_formats.setEnabled(bl);
    }

    public void onExit(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putBoolean("ENABLECOMPLETIONWORKSHEET", this.checkbox_WScompletionEnablePopup.isSelected());
        dBConfig.putBoolean("ENABLECOMPLETIONPLSQLEDITOR", this.checkbox_PLScompletionEnablePopup.isSelected());
        dBConfig.putInt("DELAYCOMPLETION", this.slider_completionPopupDelay.getValue() * 100);
        dBConfig.putInt("MAXTRIGGERCOMPLETIONLISTSIZE", this.maxTriggerCompletionListSize.getValue());
        dBConfig.putBoolean("QUERYSYNONYMS", this.checkbox_includeSynonyms.isSelected());
        dBConfig.putBoolean("AUTOGENERATEALIASES", this.checkbox_autoGenerateAliases.isSelected());
        dBConfig.putBoolean("SEMANTICANALYSISINFOTIP", this.checkbox_semanticAnalysis.isSelected());
        dBConfig.putBoolean("AUTOFORMAT", this.checkbox_autoFormat.isSelected());
        Object object = this.combo_formats.getSelectedItem();
        DBConfig.getInstance().putString("CASECONVERTER_STATE", object.toString());
    }

    private void jbInit() {
        this.numberFormatter = NumberFormat.getNumberInstance();
        this.numberFormatter.setMinimumFractionDigits(1);
        this.numberFormatter.setMaximumFractionDigits(1);
        this.checkbox_WScompletionEnablePopup.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                CodeCompletionOptionsPanel.this.checkbox_completionEnablePopup.setSelected(CodeCompletionOptionsPanel.this.checkbox_WScompletionEnablePopup.isSelected() || CodeCompletionOptionsPanel.this.checkbox_PLScompletionEnablePopup.isSelected());
            }
        });
        this.checkbox_PLScompletionEnablePopup.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                CodeCompletionOptionsPanel.this.checkbox_completionEnablePopup.setSelected(CodeCompletionOptionsPanel.this.checkbox_WScompletionEnablePopup.isSelected() || CodeCompletionOptionsPanel.this.checkbox_PLScompletionEnablePopup.isSelected());
            }
        });
        ResourceUtils.resButton((AbstractButton)this.checkbox_WScompletionEnablePopup, (String)Messages.getString("CodeCompletionOptionsPanel.1"));
        ResourceUtils.resButton((AbstractButton)this.checkbox_PLScompletionEnablePopup, (String)Messages.getString("CodeCompletionOptionsPanel.2"));
        ResourceUtils.resButton((AbstractButton)this.checkbox_includeSynonyms, (String)Messages.getString("CodeCompletionOptionsPanel.includeSynonyms"));
        ResourceUtils.resButton((AbstractButton)this.checkbox_autoGenerateAliases, (String)Messages.getString("CodeCompletionOptionsPanel.3"));
        ResourceUtils.resButton((AbstractButton)this.checkbox_semanticAnalysis, (String)Messages.getString("SemanticAnalysisInfoTip"));
        ResourceUtils.resButton((AbstractButton)this.checkbox_autoFormat, (String)Messages.getString("AutoFormat"));
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this.slider_completionPopupDelay, (String)Messages.getString("CodeCompletionOptionsPanel.5"));
        this.slider_completionPopupDelay.setPaintLabels(false);
        this.slider_completionPopupDelay.setPaintTicks(true);
        this.slider_completionPopupDelay.setMajorTickSpacing(10);
        this.slider_completionPopupDelay.setMinorTickSpacing(1);
        this.slider_completionPopupDelay.setSnapToTicks(true);
        this.slider_completionPopupDelay.addChangeListener(this);
        Component[] componentArray = new Component[]{this.slider_completionPopupDelay, jLabel, this.label_completionPopupDelayText, this.label_completionSliderMin, this.label_completionSliderMax, this.label_completionTriggerListSize, this.label_completionTriggerListSize1, this.maxTriggerCompletionListSize};
        ItemSelectableTracker itemSelectableTracker = new ItemSelectableTracker((ItemSelectable)this.checkbox_completionEnablePopup, componentArray);
        this.checkbox_completionEnablePopup.addItemListener((ItemListener)itemSelectableTracker);
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = new Insets(0, 0, 5, 5);
        Insets insets3 = new Insets(0, 18, 5, 0);
        Insets insets4 = new Insets(0, 18, 7, 5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel.add((Component)this.checkbox_WScompletionEnablePopup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        jPanel.add((Component)this.checkbox_PLScompletionEnablePopup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 1, insets, 0, 0);
        this.add(jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        int n = 0;
        gridBagConstraints = new GridBagConstraints(0, n, 3, 1, 1.0, 0.0, 17, 0, insets4, 0, 0);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 18, 0, insets3, 0, 0);
        jPanel2.add((Component)this.label_completionSliderMin, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 17, 2, insets, 0, 0);
        jPanel2.add((Component)this.slider_completionPopupDelay, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(2, n, 1, 1, 0.0, 0.0, 18, 0, insets2, 0, 0);
        jPanel2.add((Component)this.label_completionSliderMax, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, ++n, 1, 1, 0.0, 0.0, 10, 0, insets, 0, 0);
        jPanel2.add((Component)this.label_completionPopupDelayText, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, insets4, 0, 0);
        jPanel3.add((Component)this.label_completionTriggerListSize, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, insets2, 0, 0);
        jPanel3.add((Component)this.maxTriggerCompletionListSize, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, insets2, 0, 0);
        jPanel3.add((Component)this.label_completionTriggerListSize1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, n, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(Box.createVerticalStrut(50), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 17, 1, insets, 0, 0);
        this.add(jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(Box.createVerticalStrut(50), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 17, 0, insets, 0, 0);
        this.add(jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.2, 17, 0, insets, 0, 0);
        this.add(Box.createGlue(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        this.add(this.checkbox_includeSynonyms, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        this.add(this.checkbox_autoGenerateAliases, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        this.add(this.checkbox_autoFormat, gridBagConstraints);
        this.checkbox_autoFormat.addActionListener(this);
        gridBagConstraints = new GridBagConstraints(0, ++n, 3, 1, 0.0, 0.0, 17, 0, insets4, 0, 0);
        this.add(this.combo_formats, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 17, 0, insets2, 0, 0);
        this.add(this.checkbox_semanticAnalysis, gridBagConstraints);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        float f = (float)this.slider_completionPopupDelay.getValue() / 10.0f;
        String string = OptionsArb.format((int)116, (Object)this.numberFormatter.format(f));
        this.label_completionPopupDelayText.setText(string);
        this.slider_completionPopupDelay.setToolTipText(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.combo_formats.setEnabled(this.checkbox_autoFormat.isSelected());
    }
}

