/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.NumberFormatter;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.config.TnsnamesDirChooser;
import oracle.dbtools.raptor.config.homesupport.OracleClientPanel;
import oracle.dbtools.raptor.config.homesupport.OracleHomeSettings;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.ide.config.IdeSettings;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLPath;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideri.util.Product;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.PlatformUtils;

public class AdvancedInfo
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    NumberFormat format = NumberFormat.getInstance();
    NumberFormatter formatter = new NumberFormatter(this.format);
    JFormattedTextField m_arraySize = new JFormattedTextField(this.formatter);
    private JTextField m_nullDisplay = new JTextField();
    private JTextField m_kerberosConfig = new JTextField();
    private JTextField m_kerberosCache = new JTextField();
    private TnsnamesDirChooser m_tnsnamesFile = new TnsnamesDirChooser();
    private JCheckBox m_chkAutocommit = new JCheckBox();
    private JComboBox m_nullColor = new JComboBox();
    private static String[] _colors = new String[]{"NONE", "BLUE", "GRAY", "LIGHT_GRAY", "BLACK", "RED", "PINK", "ORANGE", "YELLOW", "GREEN"};
    private JCheckBox m_chkDriverPref = new JCheckBox();
    private JCheckBox m_displayStructValueInGrid = new JCheckBox();
    private JCheckBox m_displayXMLTypeValueInGrid = new JCheckBox();
    private JCheckBox m_chkUseClient = new JCheckBox();
    private OracleClientPanel m_pnlClient = new OracleClientPanel();

    public AdvancedInfo() {
        this.setHelpID("f1_cdbdprefadvanced_html");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this.m_chkAutocommit.setSelected(dBConfig.getBoolean("AUTOCOMMIT"));
        this.m_arraySize.setText(dBConfig.getString("ARRAYFETCHSIZE"));
        this.m_nullDisplay.setText(dBConfig.getString("NULLDISPLAY"));
        this.m_nullColor.setModel(new DefaultComboBoxModel<String>(_colors));
        this.m_nullColor.setSelectedItem(dBConfig.getString("NULLCOLOR"));
        this.m_displayStructValueInGrid.setSelected(dBConfig.getBoolean("DISPLAY_STRUCT_VALUE_IN_GRID"));
        this.m_displayXMLTypeValueInGrid.setSelected(dBConfig.getBoolean("DISPLAY_XMLTYPE_VALUE_IN_GRID"));
        this.m_chkDriverPref.setSelected(dBConfig.getBoolean("USE_THICK_DRIVER"));
        this.m_kerberosConfig.setText(dBConfig.getString("KERBEROS_CONFIG"));
        this.m_kerberosCache.setText(dBConfig.getString("KERBEROS_CACHE"));
        this.m_tnsnamesFile.onEntry(traversableContext);
        OracleHomeSettings oracleHomeSettings = OracleHomeSettings.createSettings(traversableContext);
        this.m_chkUseClient.setSelected(oracleHomeSettings.isUseOracleClient());
        this.m_pnlClient.onEntry(traversableContext);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        OracleHomeSettings.OracleHome oracleHome;
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putString("ARRAYFETCHSIZE", this.m_arraySize.getText());
        dBConfig.putString("NULLDISPLAY", this.m_nullDisplay.getText());
        dBConfig.putString("NULLCOLOR", (String)this.m_nullColor.getSelectedItem());
        dBConfig.putBoolean("DISPLAY_STRUCT_VALUE_IN_GRID", this.m_displayStructValueInGrid.isSelected());
        dBConfig.putBoolean("DISPLAY_XMLTYPE_VALUE_IN_GRID", this.m_displayXMLTypeValueInGrid.isSelected());
        dBConfig.putBoolean("USE_THICK_DRIVER", this.m_chkDriverPref.isSelected());
        dBConfig.putBoolean("AUTOCOMMIT", this.m_chkAutocommit.isSelected());
        dBConfig.putString("KERBEROS_CONFIG", this.m_kerberosConfig.getText());
        dBConfig.putString("KERBEROS_CACHE", this.m_kerberosCache.getText());
        this.m_tnsnamesFile.onExit(traversableContext);
        OracleHomeSettings oracleHomeSettings = OracleHomeSettings.createSettings(traversableContext);
        OracleHomeSettings oracleHomeSettings2 = (OracleHomeSettings)((Object)oracleHomeSettings.copyTo(null));
        oracleHomeSettings.setUseOracleClient(this.m_chkUseClient.isSelected());
        this.m_pnlClient.onExit(traversableContext);
        if (oracleHomeSettings.isUseOracleClient() && (oracleHome = oracleHomeSettings.getHome()) == null) {
            throw new TraversalException(PreferencesArb.getString("MESSAGE_MISSING_CLIENT"));
        }
        boolean bl = false;
        if (oracleHomeSettings2.isUseOracleClient() != oracleHomeSettings.isUseOracleClient()) {
            bl = true;
        } else if (oracleHomeSettings.isUseOracleClient() && ModelUtil.areDifferent((Object)oracleHomeSettings2.getHome(), (Object)oracleHomeSettings.getHome())) {
            bl = true;
        }
        if (bl) {
            IdeSettings ideSettings = (IdeSettings)traversableContext.find("ide-options");
            ideSettings.setAskExit(true);
        }
    }

    private URLPath getLibraryPath() {
        URLPath uRLPath = new URLPath();
        String string = System.getProperty("java.library.path");
        if (string != null) {
            for (String string2 : string.split(File.pathSeparator)) {
                File file = new File(string2).getAbsoluteFile();
                uRLPath.add(URLFactory.newDirURL((File)file));
            }
        }
        return uRLPath;
    }

    private static String getPathVariableName() {
        return PlatformUtils.isLinux() ? "LD_LIBRARY_PATH" : (PlatformUtils.isMac() ? "DYLD_LIBRARY_PATH" : "PATH");
    }

    private void jbInit() throws Exception {
        this.formatter.setValueClass(Integer.class);
        this.formatter.setMinimum(Integer.valueOf(50));
        this.formatter.setMaximum(Integer.valueOf(200));
        this.m_arraySize.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent jComponent) {
                JFormattedTextField jFormattedTextField;
                JFormattedTextField.AbstractFormatter abstractFormatter;
                if (jComponent instanceof JFormattedTextField && (abstractFormatter = (jFormattedTextField = (JFormattedTextField)jComponent).getFormatter()) != null) {
                    String string = jFormattedTextField.getText();
                    try {
                        abstractFormatter.stringToValue(string);
                        return true;
                    }
                    catch (ParseException parseException) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public boolean shouldYieldFocus(JComponent jComponent) {
                return this.verify(jComponent);
            }
        });
        this.setLayout(new GridBagLayout());
        int n = 0;
        JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)PreferencesArb.getString("ARRAYFETCHSIZE")));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("ARRAYFETCHSIZE")));
        jLabel.setLabelFor(this.m_arraySize);
        this.add(jLabel, LayoutControl.GBC.gbc(0, n, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
        this.add(this.m_arraySize, LayoutControl.GBC.gbc(1, n, 2, 1, LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        JLabel jLabel2 = new JLabel(StringUtils.stripMnemonic((String)PreferencesArb.getString("NULLDISPLAY")));
        jLabel2.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("NULLDISPLAY")));
        jLabel2.setLabelFor(this.m_nullDisplay);
        this.add(jLabel2, LayoutControl.GBC.gbc(0, ++n, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        this.add(this.m_nullDisplay, LayoutControl.GBC.gbc(1, n, 2, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        JLabel jLabel3 = new JLabel(StringUtils.stripMnemonic((String)PreferencesArb.getString("NULLCOLOR")));
        jLabel3.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("NULLCOLOR")));
        jLabel3.setLabelFor(this.m_nullColor);
        this.add(jLabel3, LayoutControl.GBC.gbc(0, ++n, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        this.add(this.m_nullColor, LayoutControl.GBC.gbc(1, n, 2, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        JLabel jLabel4 = new JLabel(StringUtils.stripMnemonic((String)PreferencesArb.getString("DISPLAY_STRUCT_VALUE_IN_GRID")));
        jLabel4.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("DISPLAY_STRUCT_VALUE_IN_GRID")));
        this.m_displayStructValueInGrid.setMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("DISPLAY_STRUCT_VALUE_IN_GRID")));
        this.m_displayStructValueInGrid.setName(StringUtils.stripMnemonic((String)PreferencesArb.getString("DISPLAY_STRUCT_VALUE_IN_GRID")));
        this.add(jLabel4, LayoutControl.GBC.gbc(0, ++n, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        this.add(this.m_displayStructValueInGrid, LayoutControl.GBC.gbc(1, n, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        JLabel jLabel5 = new JLabel(StringUtils.stripMnemonic((String)PreferencesArb.getString("DISPLAY_XMLTYPE_VALUE_IN_GRID")));
        jLabel5.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("DISPLAY_XMLTYPE_VALUE_IN_GRID")));
        this.m_displayXMLTypeValueInGrid.setMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("DISPLAY_XMLTYPE_VALUE_IN_GRID")));
        this.m_displayXMLTypeValueInGrid.setName(StringUtils.stripMnemonic((String)PreferencesArb.getString("DISPLAY_XMLTYPE_VALUE_IN_GRID")));
        this.add(jLabel5, LayoutControl.GBC.gbc(0, ++n, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        this.add(this.m_displayXMLTypeValueInGrid, LayoutControl.GBC.gbc(1, n, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        JLabel jLabel6 = new JLabel(StringUtils.stripMnemonic((String)PreferencesArb.getString("AUTOCOMMIT")));
        jLabel6.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("AUTOCOMMIT")));
        this.m_chkAutocommit.setMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("AUTOCOMMIT")));
        this.m_chkAutocommit.setName(StringUtils.stripMnemonic((String)PreferencesArb.getString("AUTOCOMMIT")));
        this.add(jLabel6, LayoutControl.GBC.gbc(0, ++n, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
        this.add(this.m_chkAutocommit, LayoutControl.GBC.gbc(1, n, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        if (Product.isRaptor()) {
            JPanel jPanel = LayoutControl.GBC.createPanel();
            JLabel jLabel7 = new JLabel(StringUtils.stripMnemonic((String)PreferencesArb.getString("KERBEROS_CONFIG")));
            jLabel7.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("KERBEROS_CONFIG")));
            jLabel7.setLabelFor(this.m_kerberosConfig);
            jPanel.add((Component)jLabel7, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, LayoutControl.GBC.Fill.NONE, LayoutControl.GBC.Spring.X));
            jPanel.add((Component)this.m_kerberosConfig, LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.XY, LayoutControl.GBC.Spring.X, LayoutControl.GBC.Anchor.LAST_LINE_END));
            JLabel jLabel8 = new JLabel(StringUtils.stripMnemonic((String)PreferencesArb.getString("KERBEROS_CACHE")));
            jLabel8.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("KERBEROS_CACHE")));
            jLabel8.setLabelFor(this.m_kerberosCache);
            jPanel.add((Component)jLabel8, LayoutControl.GBC.gbc(0, 1, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP, LayoutControl.GBC.Fill.NONE, LayoutControl.GBC.Spring.X));
            jPanel.add((Component)this.m_kerberosCache, LayoutControl.GBC.gbc(1, 1, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, LayoutControl.GBC.Fill.XY, LayoutControl.GBC.Spring.X, LayoutControl.GBC.Anchor.LAST_LINE_END));
            JPanel jPanel2 = LayoutControl.GBC.createTitledSubPanel(PreferencesArb.getString("KERBEROS_THIN_CONFIG"), jPanel);
            this.add(jPanel2, LayoutControl.GBC.gbc(0, ++n, 3, 1, LayoutControl.GBC.Inset.LINE_START_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
            JLabel jLabel9 = new JLabel(StringUtils.stripMnemonic((String)PreferencesArb.getString("OPTION_USE_CLIENT")));
            jLabel9.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("OPTION_USE_CLIENT")));
            this.m_chkUseClient.setMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("OPTION_USE_CLIENT")));
            this.m_chkUseClient.setName(StringUtils.stripMnemonic((String)PreferencesArb.getString("OPTION_USE_CLIENT")));
            this.m_chkUseClient.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    AdvancedInfo.this.m_chkDriverPref.setEnabled(AdvancedInfo.this.m_chkUseClient.isSelected());
                }
            });
            this.add(jLabel9, LayoutControl.GBC.gbc(0, ++n, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
            this.add(this.m_chkUseClient, LayoutControl.GBC.gbc(1, n, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
            this.add((Component)((Object)this.m_pnlClient), LayoutControl.GBC.gbc(0, ++n, 3, 1, LayoutControl.GBC.Inset.LINE_START_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
            JLabel jLabel10 = new JLabel(StringUtils.stripMnemonic((String)PreferencesArb.getString("USE_THICK_DRIVER")));
            jLabel10.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("USE_THICK_DRIVER")));
            this.m_chkDriverPref.setMnemonic(StringUtils.getMnemonicKeyCode((String)PreferencesArb.getString("USE_THICK_DRIVER")));
            this.m_chkDriverPref.setName(StringUtils.stripMnemonic((String)PreferencesArb.getString("USE_THICK_DRIVER")));
            this.m_chkDriverPref.setEnabled(false);
            this.add(jLabel10, LayoutControl.GBC.gbc(0, ++n, 1, 1, LayoutControl.GBC.Inset.LINE_START_COMP));
            this.add(this.m_chkDriverPref, LayoutControl.GBC.gbc(1, n, 1, 1, LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
        }
        this.add((Component)((Object)this.m_tnsnamesFile), LayoutControl.GBC.gbc(0, ++n, 3, 1, LayoutControl.GBC.Inset.LINE_START_COMP, LayoutControl.GBC.Fill.X, LayoutControl.GBC.Spring.X));
        this.add(Box.createVerticalGlue(), LayoutControl.GBC.gbc(0, ++n, 2, 1, LayoutControl.GBC.Inset.LINE_START_COMP, LayoutControl.GBC.Fill.XY, LayoutControl.GBC.Spring.XY, LayoutControl.GBC.Anchor.CENTER));
    }
}

