/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.connection.ui;

import java.awt.Component;
import javax.swing.JPanel;
import oracle.dbtools.raptor.cloud.CloudBrowserResources;
import oracle.dbtools.raptor.cloud.connection.CConnection;
import oracle.dbtools.raptor.cloud.connection.CConnectionException;
import oracle.dbtools.raptor.cloud.connection.CConnectionInfo;
import oracle.dbtools.raptor.cloud.connection.CConnectionType;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.cloud.connection.ui.BaseConnectionPanel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

public final class ConnectionEditor {
    private static ConnectionEditor INSTANCE;

    public static synchronized ConnectionEditor getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ConnectionEditor();
        }
        return INSTANCE;
    }

    public String createConnection(CConnectionType cConnectionType) {
        String string = null;
        BaseConnectionPanel baseConnectionPanel = this.createPanel(cConnectionType);
        if (baseConnectionPanel != null) {
            CConnections cConnections = CConnections.getInstance(cConnectionType);
            Namespace namespace = baseConnectionPanel.createNamespace(null, cConnections.listConnections());
            CConnectionInfo cConnectionInfo = this.runDialog(baseConnectionPanel.getCreateTitle(), namespace, baseConnectionPanel);
            if (cConnectionInfo != null) {
                try {
                    cConnections.addConnection(cConnectionInfo.getName(), cConnectionInfo);
                    string = cConnectionInfo.getName();
                }
                catch (CConnectionException cConnectionException) {
                    ExceptionHandler.handleException((Throwable)cConnectionException);
                }
            }
        }
        return string;
    }

    public String editConnection(String string, CConnectionType cConnectionType) {
        String string2 = null;
        BaseConnectionPanel baseConnectionPanel = this.createPanel(cConnectionType);
        if (baseConnectionPanel != null) {
            CConnections cConnections = CConnections.getInstance(cConnectionType);
            if (this.isConnectionOpen(cConnections, string)) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)CloudBrowserResources.format("EDIT_CONN_OPEN_CONN", string), (String)CloudBrowserResources.getString("EDIT_CONN_TITLE"), null);
                return null;
            }
            CConnectionInfo cConnectionInfo = cConnections.getConnectionInfo(string);
            Namespace namespace = baseConnectionPanel.createNamespace(cConnectionInfo, cConnections.listConnections());
            CConnectionInfo cConnectionInfo2 = this.runDialog(baseConnectionPanel.getEditTitle(), namespace, baseConnectionPanel);
            if (cConnectionInfo2 != null && ModelUtil.areDifferent((Object)cConnectionInfo, (Object)cConnectionInfo2)) {
                try {
                    string2 = cConnectionInfo2.getName();
                    if (ModelUtil.areDifferent((Object)string, (Object)string2)) {
                        cConnections.removeConnection(string);
                        cConnections.addConnection(string2, cConnectionInfo2);
                    } else {
                        cConnections.modifyConnection(string, cConnectionInfo2);
                    }
                }
                catch (CConnectionException cConnectionException) {
                    ExceptionHandler.handleException((Throwable)cConnectionException);
                    string2 = null;
                }
            }
        }
        return string2;
    }

    private boolean isConnectionOpen(CConnections cConnections, String string) {
        try {
            CConnection cConnection = cConnections.getConnection(string, false);
            return cConnection != null && cConnection.isOpen();
        }
        catch (CConnectionException cConnectionException) {
            Logger.warn(ConnectionEditor.class, (Throwable)cConnectionException);
            return false;
        }
    }

    private BaseConnectionPanel createPanel(CConnectionType cConnectionType) {
        try {
            return cConnectionType.getConnectionEditorClass().newInstance();
        }
        catch (InstantiationException instantiationException) {
            Logger.severe(ConnectionEditor.class, (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.severe(ConnectionEditor.class, (Throwable)illegalAccessException);
        }
        return null;
    }

    private CConnectionInfo runDialog(String string, Namespace namespace, BaseConnectionPanel baseConnectionPanel) {
        TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)Ide.getMainWindow(), string, (Traversable)new TP(baseConnectionPanel), namespace);
        tDialogLauncher.setPackDialog(true);
        tDialogLauncher.initDialog().setInitialFocus(baseConnectionPanel.getInitialFocusComponent());
        tDialogLauncher.initDialog().getAccessibleContext().setAccessibleName(string);
        CConnectionInfo cConnectionInfo = null;
        if (tDialogLauncher.showDialog()) {
            cConnectionInfo = baseConnectionPanel.createConnectionInfo(namespace);
        }
        return cConnectionInfo;
    }

    private static final class TP
    implements Traversable {
        private JPanel m_panel;
        private Traversable m_wrapped;

        TP(Traversable traversable) {
            this.m_wrapped = traversable;
        }

        public void onEntry(TraversableContext traversableContext) {
            this.m_wrapped.onEntry(traversableContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Component getComponent() {
            TP tP = this;
            synchronized (tP) {
                if (this.m_panel == null) {
                    this.m_panel = LayoutControl.GBC.createDialogMainPanel(this.m_wrapped.getComponent());
                }
            }
            return this.m_panel;
        }

        public void onExit(TraversableContext traversableContext) throws TraversalException {
            this.m_wrapped.onExit(traversableContext);
        }

        public Object getExitTransition() {
            return this.m_wrapped.getExitTransition();
        }

        public String getHelpID() {
            return this.m_wrapped.getHelpID();
        }
    }
}

