/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.connection;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.cloud.connection.CConnection;
import oracle.dbtools.raptor.cloud.connection.CConnectionEvent;
import oracle.dbtools.raptor.cloud.connection.CConnectionException;
import oracle.dbtools.raptor.cloud.connection.CConnectionInfo;
import oracle.dbtools.raptor.cloud.connection.CConnectionType;
import oracle.dbtools.raptor.cloud.connection.CConnectionsListener;
import oracle.dbtools.raptor.cloud.connection.CloudConnectionType;
import oracle.dbtools.raptor.cloud.connection.ConnectionCreator;
import oracle.dbtools.raptor.cloud.connection.Storage;

public class CConnections {
    private static Map<CConnectionType, CConnections> s_connTypes = new HashMap<CConnectionType, CConnections>();
    private CConnectionType m_type;
    private Map<String, C> m_conns = new HashMap<String, C>();
    private List<CConnectionsListener> m_listeners = new CopyOnWriteArrayList<CConnectionsListener>();

    public static synchronized CConnections getInstance() {
        return CConnections.getInstance(CloudConnectionType.getInstance());
    }

    public static synchronized CConnections getInstance(CConnectionType cConnectionType) {
        CConnections cConnections = s_connTypes.get(cConnectionType);
        if (cConnections == null) {
            cConnections = new CConnections(cConnectionType);
            s_connTypes.put(cConnectionType, cConnections);
        }
        return cConnections;
    }

    private CConnections(CConnectionType cConnectionType) {
        this.m_type = cConnectionType;
        Storage storage = Storage.getInstance();
        for (String string : storage.listConnections(cConnectionType.getType())) {
            CConnectionInfo cConnectionInfo = storage.getCloudConnection(cConnectionType, string);
            if (cConnectionInfo == null) continue;
            this.m_conns.put(string, new C(this.m_type, cConnectionInfo));
        }
    }

    public String[] listConnections() {
        return this.m_conns.keySet().toArray(new String[0]);
    }

    public CConnectionInfo getConnectionInfo(String string) {
        C c = this.m_conns.get(string);
        return c != null ? c.getInfo() : null;
    }

    public void addConnection(String string, CConnectionInfo cConnectionInfo) throws CConnectionException {
        if (this.m_conns.containsKey(string)) {
            throw new CConnectionException(new IllegalArgumentException("Duplicate name: " + string));
        }
        this.m_conns.put(string, new C(this.m_type, cConnectionInfo));
        Storage.getInstance().putCloudConnection(this.m_type, cConnectionInfo);
        this.fireConnectionsEvent(new CConnectionEvent(2, string), true);
    }

    public void modifyConnection(String string, CConnectionInfo cConnectionInfo) throws CConnectionException {
        C c = this.m_conns.get(string);
        if (c != null) {
            this.closeConnection(c);
        }
        this.m_conns.put(string, new C(this.m_type, cConnectionInfo));
        Storage.getInstance().putCloudConnection(this.m_type, cConnectionInfo);
        this.fireConnectionsEvent(new CConnectionEvent(4, string), true);
    }

    public void removeConnection(String string) {
        C c = this.m_conns.get(string);
        if (c != null) {
            this.closeConnection(c);
            this.m_conns.remove(string);
            Storage.getInstance().removeCloudConnection(this.m_type.getType(), string);
            this.fireConnectionsEvent(new CConnectionEvent(3, string), true);
        }
    }

    private boolean closeConnection(C c) {
        if (c.close()) {
            this.fireConnectionsEvent(new CConnectionEvent(1, c.getName()), false);
            return true;
        }
        return false;
    }

    public CConnection getConnection(String string, boolean bl) throws CConnectionException {
        C c = this.m_conns.get(string);
        if (c != null) {
            boolean bl2;
            boolean bl3 = c.m_conn == null;
            CConnection cConnection = c.getConnection(bl);
            boolean bl4 = bl2 = c.m_conn != null;
            if (bl3 && bl2) {
                this.fireConnectionsEvent(new CConnectionEvent(0, c.getName()), false);
            }
            return cConnection;
        }
        return null;
    }

    public boolean closeConnection(String string) {
        C c = this.m_conns.get(string);
        if (c != null) {
            return this.closeConnection(c);
        }
        return false;
    }

    public void addListener(CConnectionsListener cConnectionsListener) {
        this.m_listeners.add(cConnectionsListener);
    }

    public void removeListener(CConnectionsListener cConnectionsListener) {
        this.m_listeners.remove(cConnectionsListener);
    }

    private void fireConnectionsEvent(final CConnectionEvent cConnectionEvent, boolean bl) {
        final Iterator<CConnectionsListener> iterator = this.m_listeners.iterator();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                switch (cConnectionEvent.getID()) {
                    case 2: {
                        while (iterator.hasNext()) {
                            ((CConnectionsListener)iterator.next()).connectionAdded(cConnectionEvent);
                        }
                        break;
                    }
                    case 3: {
                        while (iterator.hasNext()) {
                            ((CConnectionsListener)iterator.next()).connectionRemoved(cConnectionEvent);
                        }
                        break;
                    }
                    case 4: {
                        while (iterator.hasNext()) {
                            ((CConnectionsListener)iterator.next()).connectionModified(cConnectionEvent);
                        }
                        break;
                    }
                    case 1: {
                        while (iterator.hasNext()) {
                            ((CConnectionsListener)iterator.next()).connectionClosed(cConnectionEvent);
                        }
                        break;
                    }
                    case 0: {
                        while (iterator.hasNext()) {
                            ((CConnectionsListener)iterator.next()).connectionOpened(cConnectionEvent);
                        }
                        break;
                    }
                }
            }
        };
        if (bl) {
            SwingUtilities.invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    private static class C {
        private CConnectionType m_type;
        private CConnectionInfo m_info;
        private CConnection m_conn;

        C(CConnectionType cConnectionType, CConnectionInfo cConnectionInfo) {
            this.m_type = cConnectionType;
            this.m_info = cConnectionInfo;
        }

        String getName() {
            return this.m_info.getName();
        }

        CConnectionInfo getInfo() {
            return this.m_info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CConnection getConnection(boolean bl) throws CConnectionException {
            C c = this;
            synchronized (c) {
                if (this.m_conn == null && bl) {
                    ConnectionCreator connectionCreator = new ConnectionCreator(this.m_type);
                    this.m_conn = connectionCreator.createConnection(this.m_info);
                }
            }
            return this.m_conn;
        }

        boolean close() {
            if (this.m_conn != null) {
                this.m_conn.close();
                this.m_conn = null;
            }
            return true;
        }
    }
}

