/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.auth.basic;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import oracle.dbtools.raptor.cloud.CloudBrowserResources;
import oracle.dbtools.raptor.cloud.auth.Authentication;
import oracle.dbtools.raptor.cloud.auth.AuthenticationEngine;
import oracle.dbtools.raptor.cloud.auth.AuthenticationFailedException;
import oracle.dbtools.raptor.cloud.auth.basic.BasicAuthenticationHandler;
import oracle.dbtools.raptor.cloud.connection.CConnectionInfo;
import oracle.dbtools.raptor.cloud.connection.CConnectionType;
import oracle.dbtools.raptor.cloud.connection.Client;
import oracle.dbtools.util.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;

abstract class BasicAuthenticationEngine
implements AuthenticationEngine {
    private static final String GRANT_TYPE = "grant_type";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String ENCODING_UTF8 = "UTF-8";
    private Client m_client;

    @Override
    public final void init(Client client) {
        this.m_client = client;
    }

    @Override
    public Authentication authenticate(CConnectionInfo cConnectionInfo) throws AuthenticationFailedException {
        HttpPost httpPost = this.createPost(cConnectionInfo);
        HttpEntity httpEntity = this.promptForAuthentication(cConnectionInfo);
        httpPost.setEntity(httpEntity);
        return this.doPost(httpPost);
    }

    private HttpPost createPost(CConnectionInfo cConnectionInfo) throws AuthenticationFailedException {
        CConnectionType cConnectionType = this.m_client.getConnectionType();
        URI uRI = cConnectionType.getAuthenticationURI(cConnectionInfo);
        HttpPost httpPost = new HttpPost(uRI);
        this.signRequest((HttpRequest)httpPost);
        return httpPost;
    }

    @Override
    public Authentication reauthenticate(Authentication authentication, CConnectionInfo cConnectionInfo) throws AuthenticationFailedException {
        HttpPost httpPost = this.createPost(cConnectionInfo);
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
        arrayList.add(new BasicNameValuePair(GRANT_TYPE, "refresh_token"));
        arrayList.add(new BasicNameValuePair("refresh_token", authentication.getRefreshToken()));
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(arrayList, ENCODING_UTF8));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AuthenticationFailedException(unsupportedEncodingException);
        }
        return this.doPost(httpPost);
    }

    protected abstract HttpEntity promptForAuthentication(CConnectionInfo var1) throws AuthenticationFailedException;

    private void signRequest(HttpRequest httpRequest) throws AuthenticationFailedException {
        CConnectionType cConnectionType = this.m_client.getConnectionType();
        cConnectionType.signRequest(httpRequest);
    }

    private Authentication doPost(HttpPost httpPost) throws AuthenticationFailedException {
        StringBuilder stringBuilder = new StringBuilder(httpPost.getRequestLine().toString());
        stringBuilder.append('\n').append(httpPost.getURI().toString());
        this.log(stringBuilder.toString());
        try {
            return this.m_client.executeRequest((HttpUriRequest)httpPost, new BasicAuthenticationHandler());
        }
        catch (AuthenticationFailedException authenticationFailedException) {
            throw authenticationFailedException;
        }
        catch (ClientProtocolException clientProtocolException) {
            throw new AuthenticationFailedException(clientProtocolException);
        }
        catch (UnknownHostException unknownHostException) {
            throw new AuthenticationFailedException(CloudBrowserResources.format("MESSAGE_UNKNOWN_HOST", unknownHostException.getMessage()));
        }
        catch (IOException iOException) {
            throw new AuthenticationFailedException(iOException);
        }
    }

    private void log(String string) {
        Logger.fine(AuthenticationEngine.class, (String)string);
    }

    protected final HttpEntity createEntity(String string, String string2) throws AuthenticationFailedException {
        ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
        arrayList.add(new BasicNameValuePair(GRANT_TYPE, PASSWORD));
        arrayList.add(new BasicNameValuePair(USERNAME, string));
        arrayList.add(new BasicNameValuePair(PASSWORD, string2));
        try {
            return new UrlEncodedFormEntity(arrayList, ENCODING_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AuthenticationFailedException(unsupportedEncodingException);
        }
    }

    protected final Client getClient() {
        return this.m_client;
    }

    protected HttpEntity authenticateHeadless(CConnectionInfo cConnectionInfo) throws AuthenticationFailedException {
        String string = cConnectionInfo.getName();
        String string2 = cConnectionInfo.getUsername();
        if (string2 == null) {
            throw new AuthenticationFailedException(CloudBrowserResources.format("ERROR_NO_USERNAME", string));
        }
        char[] cArray = cConnectionInfo.getPassword();
        if (cArray == null || cArray.length == 0) {
            throw new AuthenticationFailedException(CloudBrowserResources.format("ERROR_NO_PWD", string));
        }
        return this.createEntity(string2, new String(cArray));
    }
}

