/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.qbql;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.qbql.Query;
import oracle.dbtools.util.Service;

public class Database {
    private static Connection connection = null;
    Map<String, Set<String>> tabColumns = new HashMap<String, Set<String>>();

    private static void connect() {
        String string = "jdbc:mysql://swifty:3306/test";
        try {
            connection = DriverManager.getConnection(string, "guest", "welcome");
            Statement statement = connection.createStatement();
            statement.execute("use INFORMATION_SCHEMA");
        }
        catch (SQLException sQLException) {
            System.err.println("Failed to connect: " + sQLException.getMessage());
        }
    }

    void refreshCache(Set<String> set) {
        if (connection == null) {
            Database.connect();
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String object : set) {
            if (!bl) {
                stringBuilder.append(',');
            }
            if (!this.tabColumns.containsKey(object)) {
                stringBuilder.append('\'');
                stringBuilder.append(object);
                stringBuilder.append('\'');
            }
            bl = false;
        }
        if (!bl) {
            try {
                String string = "select table_name,column_name from columns \nwhere table_name in (" + stringBuilder + ")";
                PreparedStatement preparedStatement = connection.prepareStatement(string);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String string2 = resultSet.getString("table_name");
                    String string3 = resultSet.getString("column_name");
                    Set<String> set2 = this.tabColumns.get(string2);
                    if (set2 == null) {
                        set2 = new HashSet<String>();
                        this.tabColumns.put(string2, set2);
                    }
                    set2.add(string3);
                }
            }
            catch (SQLException sQLException) {
                System.err.println(sQLException.getMessage());
            }
        }
    }

    public static void main(String[] stringArray) throws IOException {
        String string = Service.readFile(Database.class, (String)"test.qbql");
        Query query = new Query(string, new Database());
        System.out.println(query.translate());
    }
}

