/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.proformatter.treePreferences.style.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.bali.ewt.button.ButtonBar;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.proformatter.SQLFormatter;
import oracle.dbtools.proformatter.SQLFormatterArb;
import oracle.dbtools.proformatter.treePreferences.CodingStyleSQLProfile;
import oracle.dbtools.proformatter.treePreferences.NameAndDatabase;
import oracle.dbtools.proformatter.treePreferences.style.preferences.CodingStyleSQLPreferences;
import oracle.dbtools.proformatter.treePreferences.style.preferences.CodingStyleTreeDisplayPanel;
import oracle.dbtools.proformatter.treePreferences.style.profile.CodingStyleSQLProfiles;
import oracle.dbtools.proformatter.treePreferences.style.profile.ProfileModel;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.proformatter.FormatHelper;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.config.Preferences;
import oracle.ide.dialogs.DialogRunnerCallback;
import oracle.ide.dialogs.SizeKeeperCallback;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Assert;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.UnexpectedExceptionError;

public abstract class CodingStylePreferencesPanel
extends DefaultTraversablePanel
implements ActionListener,
ItemListener,
ApplyListener {
    private static final String EDIT_PROFILE_HELP_TOPIC = "f1_idedidesetsqlformat_html";
    public static final int UNKNOWNINT = -1;
    public static final String ORACLE = "Oracle";
    public static final int ORACLEINT = 1;
    public static final String DB2 = "DB2";
    public static final int DB2INT = 2;
    public static final String SYBASE = "Sybase";
    public static final int SYBASEINT = 3;
    public static final String ACCESS = "Microsoft Access";
    public static final int ACCESSINT = 4;
    public static final String SQLSERVER = "Microsoft SQL Server";
    public static final int SQLSERVERINT = 5;
    public static final String MYSQL = "MySQL";
    public static final int MYSQLINT = 6;
    private ProfileModel m_model;
    private JComboBox m_cmbProfiles;
    private JButton m_btnEdit = null;
    private JButton m_btnSaveAs = null;
    private JButton m_btnDelete = null;
    private JButton m_btnDefaults = null;
    private BasicEditorPane m_editor = null;
    private CodingStyleSQLPreferences m_prefs;

    public abstract String getPlatformString();

    public abstract int getPlatformInt();

    public static final String dbToFormatter(int n) {
        return FormatHelper.dbToFormatter((int)n);
    }

    public abstract CodingStyleTreeDisplayPanel getCodingStyleTreeDisplayPanel();

    public CodingStylePreferencesPanel() {
        this.setHelpID(EDIT_PROFILE_HELP_TOPIC);
    }

    public void reinit() {
        this.removeAll();
        this.m_model = new ProfileModel(this.getPlatformInt());
        this.m_cmbProfiles = new JComboBox(this.m_model);
        this.m_cmbProfiles.setRenderer(new ProfileRenderer());
        this.m_cmbProfiles.setEditable(false);
        this.m_cmbProfiles.addItemListener(this);
        this.m_btnEdit = new JButton();
        ResourceUtils.resButton((AbstractButton)this.m_btnEdit, (String)SQLFormatterArb.getString("CodingStylePreferencesPanel_EDIT"));
        this.m_btnEdit.addActionListener(this);
        this.m_btnSaveAs = new JButton();
        ResourceUtils.resButton((AbstractButton)this.m_btnSaveAs, (String)SQLFormatterArb.getString("CodingStylePreferencesPanel_SAVEAS"));
        this.m_btnSaveAs.addActionListener(this);
        this.m_btnDelete = new JButton();
        ResourceUtils.resButton((AbstractButton)this.m_btnDelete, (String)SQLFormatterArb.getString("CodingStylePreferencesPanel_DELETE"));
        this.m_btnDelete.addActionListener(this);
        JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)SQLFormatterArb.getString("CodingStylePreferencesPanel_PROFILE")));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)SQLFormatterArb.getString("CodingStylePreferencesPanel_PROFILE")));
        jLabel.setLabelFor(this.m_cmbProfiles);
        JLabel jLabel2 = new JLabel(SQLFormatterArb.getString("CodingStylePreferencesPanel_PREVIEW"));
        this.m_btnDefaults = new JButton();
        ResourceUtils.resButton((AbstractButton)this.m_btnDefaults, (String)SQLFormatterArb.getString("CodingStylePreferencesPanel_RESTORE_DEFAULTS"));
        this.m_editor = EditorFactory.createIdeEditorPane();
        this.m_editor.setDocument((Document)new BasicDocument("template.plsql"));
        this.m_editor.setText(this.getCodingStyleTreeDisplayPanel().getSample());
        this.m_editor.installPlugin((EditorPlugin)new LineHighlightPlugin());
        LineGutterPlugin lineGutterPlugin = new LineGutterPlugin();
        this.m_editor.installPlugin((EditorPlugin)lineGutterPlugin);
        this.m_editor.setEditable(false);
        this.m_btnDefaults.addActionListener(this);
        this.m_editor.setCaretPosition(0);
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.add((Component)this.m_btnEdit);
        buttonBar.add((Component)this.m_btnSaveAs);
        buttonBar.add((Component)this.m_btnDelete);
        ButtonBar buttonBar2 = new ButtonBar();
        buttonBar2.add((Component)this.m_btnDefaults);
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = this.getGBC();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = this.getGBC();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.m_cmbProfiles, gridBagConstraints);
        gridBagConstraints = this.getGBC();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)buttonBar, gridBagConstraints);
        this.setLayout(new BorderLayout());
        this.add(jPanel, "North");
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = this.getGBC();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = this.getGBC();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)new JScrollPane((Component)this.m_editor), gridBagConstraints);
        this.add(jPanel2, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)buttonBar2, "East");
        this.add(jPanel3, "South");
    }

    public GridBagConstraints getGBC() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        return gridBagConstraints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editProfile() {
        CodingStyleTreeDisplayPanel codingStyleTreeDisplayPanel = this.getCodingStyleTreeDisplayPanel();
        CodingStyleSQLProfile codingStyleSQLProfile = this.getSelectedProfile();
        CodingStyleSQLProfile codingStyleSQLProfile2 = new CodingStyleSQLProfile();
        codingStyleSQLProfile.copyTo(codingStyleSQLProfile2);
        Namespace namespace = new Namespace();
        namespace.put("ProProfile", (Object)codingStyleSQLProfile2);
        TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)((Object)this), this.getPlatformString(), (Traversable)codingStyleTreeDisplayPanel, namespace, (DialogRunnerCallback)new SizeKeeperCallback("oracle.dbtools.proformatter.treePreferences.style.preferences"));
        tDialogLauncher.setInitialSize(800, 600);
        try {
            if (tDialogLauncher.showDialog() && ModelUtil.areDifferent((Object)codingStyleSQLProfile, (Object)codingStyleSQLProfile2)) {
                codingStyleSQLProfile2.copyTo(codingStyleSQLProfile);
                this.m_model.setModified(codingStyleSQLProfile);
                this.updatePreview();
                this.updateButtons();
            }
        }
        finally {
            tDialogLauncher.dispose();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_btnEdit) {
            this.editProfile();
        } else if (object == this.m_btnSaveAs) {
            this.saveProfile();
        } else if (object == this.m_btnDelete) {
            this.deleteProfile();
        } else if (object == this.m_btnDefaults) {
            this.restoreProfile();
        }
    }

    private boolean confirmDelete(CodingStyleSQLProfile codingStyleSQLProfile) {
        String string;
        String string2 = SQLFormatterArb.format("DELETE_PROFILE_MESSAGE", codingStyleSQLProfile.getName());
        int n = JOptionPane.showConfirmDialog((Component)((Object)this), string2, string = SQLFormatterArb.getString("DELETE_PROFILE_TITLE"), 2);
        return n == 0;
    }

    private void restoreProfile() {
        this.m_model.restore(this.getSelectedProfile());
        this.updatePreview();
        this.updateButtons();
    }

    private void saveProfile() {
        CodingStyleSQLProfile codingStyleSQLProfile = this.getSelectedProfile();
        String string = codingStyleSQLProfile.getName();
        String string2 = this.getProfileName(string);
        if (string2 != null && (string2.equalsIgnoreCase(string) || !this.m_model.contains(new NameAndDatabase(string2, codingStyleSQLProfile.getSourceSql())) || this.confirmSaveAsOverwrite(string2))) {
            CodingStyleSQLProfile codingStyleSQLProfile2 = this.m_model.copy(codingStyleSQLProfile, string2);
            this.m_model.setSelectedItem(codingStyleSQLProfile2);
            this.m_model.revert(codingStyleSQLProfile);
            this.m_model.save();
        }
    }

    private boolean confirmSaveAsOverwrite(String string) {
        String string2;
        String string3 = SQLFormatterArb.format("SAVE_AS_OVERWRITE_WARNING_MESSAGE", string);
        int n = JOptionPane.showConfirmDialog((Component)((Object)this), string3, string2 = SQLFormatterArb.getString("SAVE_AS_OVERWRITE_WARNING_TITLE"), 2);
        return n == 0;
    }

    private String getProfileName(String string) {
        JTextField jTextField = new JTextField(string, 32);
        jTextField.selectAll();
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)jTextField, (String)SQLFormatterArb.getString("PROFILE_NAME_LABEL"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        HelpUtils.setHelpID((JComponent)jPanel, (String)EDIT_PROFILE_HELP_TOPIC);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.right = 0;
        jPanel.add((Component)jTextField, gridBagConstraints);
        JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)((Object)this), (String)SQLFormatterArb.getString("SAVE_PROFILE_TITLE"), (int)7);
        jTextField.getDocument().addDocumentListener(new SaveAsListener(jEWTDialog));
        jEWTDialog.setContent((Component)jPanel);
        jEWTDialog.setOKButtonText(SQLFormatterArb.getString("SAVE_PROFILE_LABEL"));
        return jEWTDialog.runDialog() ? jTextField.getText().trim() : null;
    }

    private void deleteProfile() {
        CodingStyleSQLProfile codingStyleSQLProfile = this.getSelectedProfile();
        if (this.confirmDelete(codingStyleSQLProfile)) {
            this.m_model.remove(codingStyleSQLProfile);
            this.m_model.save();
        }
    }

    private CodingStyleSQLProfile getSelectedProfile() {
        return (CodingStyleSQLProfile)this.m_model.getSelectedItem();
    }

    private CodingStyleSQLPreferences getCodingStylePreferences(TraversableContext traversableContext) {
        return CodingStyleSQLPreferences.getInstance(traversableContext.getPropertyStorage());
    }

    public void onEntry(TraversableContext traversableContext) {
        this.reinit();
        SQLFormatter.getInstance();
        this.m_prefs = this.getCodingStylePreferences(traversableContext);
        CodingStyleSQLProfile codingStyleSQLProfile = null;
        String string = null;
        if (this.m_prefs != null && this.m_prefs.getActiveProfile() != null) {
            string = new NameAndDatabase(this.m_prefs.getActiveProfile()).getName();
        }
        boolean bl = string != null && !this.m_model.contains(new NameAndDatabase(string, this.getPlatformInt()));
        Assert.println((boolean)bl, (String)(SQLFormatterArb.getString("CodingStylePreferencesPanel_CODING_STYLE_PROFILE") + string + SQLFormatterArb.getString("CodingStylePreferencesPanel_NOT_FOUND")));
        codingStyleSQLProfile = string == null || bl ? this.m_model.getDefaultProfile(this.getPlatformInt()) : this.m_model.getProfile(new NameAndDatabase(string, this.getPlatformInt()));
        this.m_model.setSelectedItem(codingStyleSQLProfile);
        this.updatePreview();
        this.updateButtons();
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        HashStructureAdapter hashStructureAdapter;
        EditorProperties editorProperties;
        CodingStyleSQLPreferences codingStyleSQLPreferences = this.getCodingStylePreferences(traversableContext);
        CodingStyleSQLProfile codingStyleSQLProfile = this.getSelectedProfile();
        if (codingStyleSQLProfile != null) {
            codingStyleSQLPreferences.setActiveProfile(new NameAndDatabase(this.getSelectedProfile().getName(), this.getSelectedProfile().getSourceSql()).toString());
            if (RaptorExtensionConstants.isStandAlone()) {
                DBConfig.getInstance(traversableContext).putBoolean("INDENT_CACHE_USE_TAB", codingStyleSQLProfile.getUseTab());
                DBConfig.getInstance(traversableContext).putInt("INDENT_CACHE_NUMBER", codingStyleSQLProfile.getNumSpaces());
                editorProperties = EditorProperties.getProperties();
                editorProperties.putIntegerProperty("indent-size", codingStyleSQLProfile.getNumSpaces());
                editorProperties.putBooleanProperty("use-tabs", codingStyleSQLProfile.getUseTab());
                editorProperties.putIntegerProperty("tab-size", codingStyleSQLProfile.getNumSpaces());
            }
        } else {
            codingStyleSQLPreferences.setActiveProfile(null);
            if (RaptorExtensionConstants.isStandAlone()) {
                DBConfig.getInstance(traversableContext).putBoolean("INDENT_CACHE_USE_TAB", false);
                DBConfig.getInstance(traversableContext).putInt("INDENT_CACHE_NUMBER", -1);
            }
        }
        editorProperties = new HashMap();
        int n = this.m_model.getSize();
        for (int i = 0; i < n; ++i) {
            hashStructureAdapter = (CodingStyleSQLProfile)this.m_model.getElementAt(i);
            String string = hashStructureAdapter.getSourceSql() + ":" + hashStructureAdapter.getName();
            editorProperties.put(string, hashStructureAdapter);
        }
        PropertyStorage propertyStorage = traversableContext.getPropertyStorage();
        hashStructureAdapter = CodingStyleSQLProfiles.getInstance(propertyStorage);
        for (CodingStyleSQLProfile codingStyleSQLProfile2 : hashStructureAdapter.getProfileMap().values()) {
            if (codingStyleSQLProfile2.getSourceSql() == this.getPlatformInt()) continue;
            String string = new NameAndDatabase(codingStyleSQLProfile2.getName(), codingStyleSQLProfile2.getSourceSql()).toString();
            editorProperties.put(string, codingStyleSQLProfile2);
        }
        hashStructureAdapter.setProfileMap((Map<String, CodingStyleSQLProfile>)editorProperties);
        CodingStyleSQLProfiles.getInstance((PropertyStorage)Preferences.getPreferences()).setProfileMap((Map<String, CodingStyleSQLProfile>)editorProperties);
    }

    private void jtaUpdate(CodingStyleSQLProfile codingStyleSQLProfile) {
        this.m_editor.setEditable(true);
        this.m_editor.setText(codingStyleSQLProfile.format(this.getCodingStyleTreeDisplayPanel().getSample()));
        this.m_editor.setCaretPosition(0);
        this.m_editor.setEditable(false);
    }

    private void updatePreview() {
        CodingStyleSQLProfile codingStyleSQLProfile = this.getSelectedProfile();
        this.jtaUpdate(codingStyleSQLProfile);
    }

    private void updateButtons() {
        CodingStyleSQLProfile codingStyleSQLProfile = this.getSelectedProfile();
        boolean bl = codingStyleSQLProfile != null;
        this.m_btnDelete.setEnabled(bl && !this.m_model.isDefaultProfile(codingStyleSQLProfile));
        this.m_btnDefaults.setEnabled(bl && this.m_model.canRestore(codingStyleSQLProfile));
        this.m_btnEdit.setEnabled(bl);
        this.m_btnSaveAs.setEnabled(bl);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.updatePreview();
            this.updateButtons();
        }
    }

    public void apply(ApplyEvent applyEvent) {
    }

    public void cancel(ApplyEvent applyEvent) {
        this.m_model.revert();
    }

    private static class SaveAsListener
    implements DocumentListener {
        private JEWTDialog dialog;

        public SaveAsListener(JEWTDialog jEWTDialog) {
            this.dialog = jEWTDialog;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent.getDocument());
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent.getDocument());
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.update(documentEvent.getDocument());
        }

        private void update(Document document) {
            String string;
            try {
                string = document.getText(0, document.getLength()).trim();
            }
            catch (BadLocationException badLocationException) {
                throw new UnexpectedExceptionError((Throwable)badLocationException);
            }
            this.dialog.setOKButtonEnabled(string.length() > 0);
        }
    }

    private static class ProfileRenderer
    extends BasicComboBoxRenderer {
        public static final long serialVersionUID = 1991L;

        private ProfileRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof CodingStyleSQLProfile) {
                CodingStyleSQLProfile codingStyleSQLProfile = (CodingStyleSQLProfile)object;
                object = codingStyleSQLProfile.isModified() ? SQLFormatterArb.format("MODIFIED_PROFILE", codingStyleSQLProfile.getName()) : codingStyleSQLProfile.getName();
            }
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }
    }
}

