/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.proformatter;

import oracle.dbtools.proformatter.SQLFormatToClipboardCommand;
import oracle.dbtools.proformatter.treePreferences.CodingStyleSQLProfile;
import oracle.dbtools.proformatter.treePreferences.style.CodingStyleSQLOptions;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.ide.Context;

public class SQLFormatToPropertiesCommand
extends SQLFormatToClipboardCommand {
    private boolean m_editor = true;
    private int m_targetSql = 0;
    private int m_enclosed = -1;
    private int m_escape = -1;

    public SQLFormatToPropertiesCommand(Context context) {
        super(-1, 0, "Format SQL To Clipboard For Java Command");
        this.setContext(context);
    }

    public SQLFormatToPropertiesCommand() {
        super(-1, 0, "Format SQL To Clipboard For Java Command");
    }

    public SQLFormatToPropertiesCommand(Context context, boolean bl, int n) {
        super(-1, 0, "Format SQL To Clipboard For Java Command");
        this.m_editor = bl;
        this.m_targetSql = n;
        this.setContext(context);
    }

    public SQLFormatToPropertiesCommand(Context context, boolean bl, int n, int n2, int n3) {
        super(-1, 0, "Format SQL To Clipboard For Java Command");
        this.m_editor = bl;
        this.m_targetSql = n;
        this.m_enclosed = n2;
        this.m_escape = n3;
        this.setContext(context);
    }

    @Override
    public boolean outputStringToClipboard(String string) {
        if (!this.m_editor) {
            UIUtils.setClipboard((String)string);
            return true;
        }
        return false;
    }

    @Override
    public CodingStyleSQLOptions alterOptions(CodingStyleSQLOptions codingStyleSQLOptions) {
        CodingStyleSQLProfile codingStyleSQLProfile = new CodingStyleSQLProfile();
        ((CodingStyleSQLProfile)codingStyleSQLOptions).copyTo(codingStyleSQLProfile);
        codingStyleSQLProfile.setTargetSql(this.m_targetSql);
        switch (this.m_enclosed) {
            case -1: {
                break;
            }
            case 0: {
                codingStyleSQLProfile.setSqlsourceCopied(false);
                break;
            }
            case 1: {
                codingStyleSQLProfile.setSqlsourceCopied(true);
                codingStyleSQLProfile.setSqlSourceEnclosed(0);
                break;
            }
            case 2: {
                codingStyleSQLProfile.setSqlsourceCopied(true);
                codingStyleSQLProfile.setSqlSourceEnclosed(1);
            }
        }
        if (this.m_enclosed != 0 && this.m_enclosed != -1 && this.m_escape != -1) {
            codingStyleSQLProfile.setSqlSourceEscape(this.m_escape);
        }
        return codingStyleSQLProfile;
    }
}

