/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.svg;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Map;
import oracle.dss.presutil.GradientObj;
import oracle.dss.util.shapes.DrawableObject;

public class CustomShapeUtils {
    public static final String SFX_FILL_TYPE = "SFX_FILL_TYPE";
    public static final String SFX_GRADIENT_DIRECTION = "SFX_GRADIENT_DIRECTION";
    public static final String SFX_GRADIENT_REVERSED = "SFX_GRADIENT_REVERSED";
    public static final String SFX_NUM_STOPS = "SFX_NUM_STOPS";
    public static final String SFX_STOP_COLORS = "SFX_STOP_COLORS";
    public static final String SFX_STOP_POSITIONS = "SFX_STOP_POSITIONS";
    public static final String SFX_GRADIENT_CENTER = "SFX_GRADIENT_CENTER";
    public static final String SFX_START_POINT = "SFX_START_POINT";
    public static final String SFX_END_POINT = "SFX_END_POINT";
    public static int FT_GRADIENT = 0;
    private static final String _BOUNDING_SHAPE = "_BOUNDING_SHAPE";

    public static Color hexStringToColor(String str) {
        String noPound = str.substring(1);
        try {
            if (noPound.length() == 8) {
                int a = Integer.parseInt(noPound.substring(0, 2), 16);
                int r = Integer.parseInt(noPound.substring(2, 4), 16);
                int g = Integer.parseInt(noPound.substring(4, 6), 16);
                int b = Integer.parseInt(noPound.substring(6, 8), 16);
                return new Color(r, g, b, a);
            }
            return new Color(Integer.parseInt(noPound, 16), false);
        }
        catch (NumberFormatException e) {
            System.out.println("NumberFormatException for " + noPound + " in hexStringToColor");
            return null;
        }
    }

    public static GradientObj convertSFXMapToGradientObj(Map sfxMap, Shape shape) {
        if (sfxMap == null) {
            return null;
        }
        Integer fillTypeObj = (Integer)sfxMap.get(SFX_FILL_TYPE);
        if (fillTypeObj == null || fillTypeObj != FT_GRADIENT) {
            return null;
        }
        GradientObj gradient = new GradientObj();
        int direction = (Integer)sfxMap.get(SFX_GRADIENT_DIRECTION);
        gradient.setDirectionConstant(direction);
        int stopCount = (Integer)sfxMap.get(SFX_NUM_STOPS);
        ArrayList stops = (ArrayList)sfxMap.get(SFX_STOP_POSITIONS);
        ArrayList colors = (ArrayList)sfxMap.get(SFX_STOP_COLORS);
        for (int stop = 0; stop < stopCount && stop < stops.size() && stop < colors.size(); ++stop) {
            double offset = ((Double)stops.get(stop)).floatValue();
            Color color = (Color)colors.get(stop);
            gradient.insertPin(offset, color);
        }
        Boolean bReverse = (Boolean)sfxMap.get(SFX_GRADIENT_REVERSED);
        if (bReverse != null && bReverse.booleanValue()) {
            gradient.reverseDirection();
        }
        Point2D radialCenter = (Point2D)sfxMap.get(SFX_GRADIENT_CENTER);
        Rectangle bounds = shape.getBounds2D().getBounds();
        if (radialCenter != null && bounds != null) {
            int cy;
            int cx;
            if (direction == 21) {
                cx = (int)(bounds.getX() + bounds.getWidth() * radialCenter.getX() / 100.0);
                cy = (int)(bounds.getY() + bounds.getHeight() * radialCenter.getY() / 100.0);
            } else {
                cx = (int)radialCenter.getX();
                cy = (int)radialCenter.getY();
            }
            gradient.setCenter(new Point(cx, cy));
        } else if (direction == 9 && bounds != null) {
            int cx = bounds.x + bounds.width / 2;
            int cy = bounds.y + bounds.height / 2;
            gradient.setCenter(new Point(cx, cy));
            gradient.setRadius(Math.max(bounds.width, bounds.height) / 2);
        } else if (direction == 20) {
            Point2D start = (Point2D)sfxMap.get(SFX_START_POINT);
            Point2D end = (Point2D)sfxMap.get(SFX_END_POINT);
            int x1 = (int)(bounds.getX() + bounds.getWidth() * start.getX() / 100.0);
            int y1 = (int)(bounds.getY() + bounds.getHeight() * start.getY() / 100.0);
            int x2 = (int)(bounds.getX() + bounds.getWidth() * end.getX() / 100.0);
            int y2 = (int)(bounds.getY() + bounds.getHeight() * end.getY() / 100.0);
            gradient.setStartPoint(new Point(x1, y1));
            gradient.setEndPoint(new Point(x2, y2));
        }
        return gradient;
    }

    public static boolean isBoundingShape(DrawableObject cs) {
        return Boolean.TRUE.equals(cs.getProperty(_BOUNDING_SHAPE));
    }

    public static void setBoundingShape(DrawableObject cs) {
        cs.setProperty(_BOUNDING_SHAPE, Boolean.TRUE);
    }
}

