/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.math;

import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.math.CurveFitIF;

public class FitLogQuadratic
implements CurveFitIF {
    private static int NUM_COEFFS = 3;

    @Override
    public double compute(double x, double[] a) throws AssertionException {
        PfjAssert.pfjAssert(a.length >= NUM_COEFFS + 1);
        double y = Math.exp(a[1] + a[2] * x + a[3] * x * x);
        return y;
    }

    @Override
    public void eval(double x, double[] a) throws AssertionException {
        PfjAssert.pfjAssert(a.length >= NUM_COEFFS + 1);
        a[1] = 1.0;
        a[2] = x;
        a[3] = x * x;
    }

    @Override
    public int numCoeffs() {
        return NUM_COEFFS;
    }

    @Override
    public double transformY(double y) throws AssertionException {
        PfjAssert.pfjAssert(y > 0.0);
        return Math.log(y);
    }

    @Override
    public double invTransformCoeff(int ia, double a) {
        return a;
    }

    @Override
    public String createEquation(String[] strCoeffs, boolean bHighOrderFirst) throws AssertionException {
        PfjAssert.pfjAssert(strCoeffs.length >= NUM_COEFFS + 1);
        String strTerm1 = strCoeffs[1];
        String strTerm2 = strCoeffs[2] + " * x";
        String strTerm3 = strCoeffs[3] + " * x^2";
        if (bHighOrderFirst) {
            return "y = exp(" + strTerm3 + " + " + strTerm2 + " + " + strTerm1 + ")";
        }
        return "y = exp(" + strTerm1 + " + " + strTerm2 + " + " + strTerm3 + ")";
    }
}

