/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import oracle.dss.dataView.ImageViewExportXMLWriter;
import oracle.dss.graph.pfj.FontCache;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.ImageLoader;
import oracle.dss.presutil.FontMetricsResolver;
import oracle.dss.presutil.PresUtils;
import oracle.dss.util.LocaleUtils;

public class TextStyleObj
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int NEWLINE = 10;
    private static final int BLANK = 32;
    private static final int FORCE_LINEBREAK = 10;
    private static final int POSSIBLE_LINEBREAK = 32;
    private static final int FORCE_BREAK = 1;
    private static final int POSSIBLE_BREAK = 2;
    private static final int NO_SUCH_CHAR = -1;
    private static final int AUTOFIT_MIN = 200;
    private static final int AUTOFIT_MAX = 2200;
    private static final int MIN_SIZE_PTS = 0;
    private static final int MAX_SIZE_PTS = Integer.MAX_VALUE;
    private static final int MIN_SIZE_VC = 0;
    private static final int MAX_SIZE_VC = 6000;
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_ITALIC = 1;
    public static final int STYLE_BOLD = 2;
    public static final int STYLE_UNDERLINE = 4;
    public static final int ROTATE_NONE = 0;
    public static final int ROTATE_90 = 90;
    public static final int ROTATE_180 = 180;
    public static final int ROTATE_270 = 270;
    public static final int HEIGHT_AND_WIDTH_OK = 0;
    public static final int HEIGHT_LARGER = 1;
    public static final int WIDTH_LARGER = 2;
    public static final int WIDTH_AND_HEIGHT_LARGER = 3;
    public static final int LARGE_DRILL_UP_FONT_SIZE = 18;
    public static Image SMALL_DRILL_IMAGE = null;
    public static Image LARGE_DRILL_IMAGE = null;
    public Locale m_locale = null;
    public boolean m_textTrunc = false;
    public int m_minChars = 0;
    public boolean m_textTruncated = false;
    public int m_stopAtLine = -1;
    private String m_strFontName;
    private boolean m_bUseDC;
    private int m_nFontSizeDC;
    private int m_nFontSizeVC;
    private int m_nFontStyle;
    private int m_nAngleSetting;
    private int m_nJustH;
    private int m_nJustV;
    private boolean m_bAutofit;
    private boolean m_bAdjustBox;
    private boolean m_bWordwrap;
    private boolean m_displayDrillIcon;
    private int m_imageSize;
    private Image m_image;
    private Dimension m_dimLargestTextDC;
    private int m_nTruncateCount;
    private FontCache m_fontCache;

    public TextStyleObj(FontCache fontCache, String strFontName, int nFontStyle, boolean bUseDC, int nFontSizeDC, int nFontSizeVC, int nAngleSetting, int nJustH, int nJustV, boolean bAutofit, boolean bAdjustBox, boolean bWordwrap, Locale locale) {
        this.m_fontCache = fontCache;
        this.m_strFontName = strFontName;
        this.m_nFontStyle = nFontStyle;
        this.m_bUseDC = bUseDC;
        this.m_nFontSizeDC = nFontSizeDC;
        this.m_nFontSizeVC = nFontSizeVC;
        if (this.m_bUseDC) {
            this.m_nFontSizeDC = this.rangeChkFontPtSize(this.m_nFontSizeDC);
        } else {
            this.m_nFontSizeVC = this.rangeChkFontVCSize(this.m_nFontSizeVC);
        }
        this.m_nAngleSetting = nAngleSetting;
        this.m_nJustH = nJustH;
        this.m_nJustV = nJustV;
        this.m_bAutofit = bAutofit && !bUseDC;
        this.m_bAdjustBox = bAdjustBox;
        this.m_bWordwrap = bWordwrap;
        this.m_locale = locale;
        this.m_nTruncateCount = 0;
        this.m_displayDrillIcon = false;
    }

    public TextStyleObj(FontCache fontCache, String strFontName, int nFontStyle, boolean bUseDC, int nFontSizeDC, int nFontSizeVC, int nAngleSetting, int nJustH, int nJustV, boolean bAutofit, boolean bAdjustBox, boolean bWordwrap) {
        this(fontCache, strFontName, nFontStyle, bUseDC, nFontSizeDC, nFontSizeVC, nAngleSetting, nJustH, nJustV, bAutofit, bAdjustBox, bWordwrap, Locale.getDefault());
    }

    public TextStyleObj(TextStyleObj ts) {
        this.copy(ts);
    }

    private int autofit(Graphics gx, String strText, Dimension dim, VC vc, FontMetricsResolver resolver) {
        int nIncrement;
        int nTooBigDC = nIncrement = 10;
        int nTooSmallDC = 0;
        if (strText != null) {
            Dimension textDimDC;
            while (true) {
                textDimDC = this.getTextSizeDC(gx, strText, nTooBigDC, vc, dim, null, resolver);
                if (textDimDC.width > dim.width || textDimDC.height > dim.height) break;
                nTooBigDC += nIncrement;
                nTooSmallDC += nIncrement;
            }
            do {
                int nTrySizeDC = nTooSmallDC + (nTooBigDC - nTooSmallDC) / 2;
                textDimDC = this.getTextSizeDC(gx, strText, nTrySizeDC, vc, dim, null, resolver);
                if (textDimDC.width <= dim.width && textDimDC.height <= dim.height) {
                    nTooSmallDC = nTrySizeDC;
                    continue;
                }
                nTooBigDC = nTrySizeDC;
            } while (nTooSmallDC != nTooBigDC - 1);
            this.m_nFontSizeDC = nTooSmallDC;
            this.m_nFontSizeVC = vc.destToVirtHeight(nTooSmallDC);
        }
        return nTooSmallDC;
    }

    private int autofit(Graphics gx, List textTable, Dimension dim, VC vc, FontMetricsResolver resolver) {
        int nFontSize = 0;
        nFontSize = vc.getVirtDimension().height;
        int listCount = textTable.size();
        for (int index = 0; index < listCount; ++index) {
            Object o = textTable.get(index);
            if (o == null || !o.getClass().getName().equals("java.lang.String") || ((String)o).length() <= 0) continue;
            String strText = (String)o;
            int nSize = this.autofit(gx, strText, dim, vc, resolver);
            nFontSize = Math.min(nFontSize, nSize);
        }
        return nFontSize;
    }

    public void copy(TextStyleObj ts) {
        this.m_fontCache = ts.m_fontCache;
        this.m_strFontName = ts.m_strFontName;
        this.m_nFontStyle = ts.m_nFontStyle;
        this.m_bUseDC = ts.m_bUseDC;
        this.m_nFontSizeDC = ts.m_nFontSizeDC;
        this.m_nFontSizeVC = ts.m_nFontSizeVC;
        this.m_nAngleSetting = ts.m_nAngleSetting;
        this.m_nJustH = ts.m_nJustH;
        this.m_nJustV = ts.m_nJustV;
        this.m_bAutofit = ts.m_bAutofit;
        this.m_bAdjustBox = ts.m_bAdjustBox;
        this.m_bWordwrap = ts.m_bWordwrap;
        this.m_nTruncateCount = ts.m_nTruncateCount;
        this.m_textTrunc = ts.m_textTrunc;
        this.m_minChars = ts.m_minChars;
        this.m_textTruncated = ts.m_textTruncated;
        this.m_stopAtLine = ts.m_stopAtLine;
        this.m_displayDrillIcon = ts.m_displayDrillIcon;
        this.m_locale = ts.m_locale;
    }

    public void draw(Graphics gx, Perspective perspect, String strText, Rectangle rBoundsDC, Color dropShadowColor, Dimension dropShadowOffset, VC vc) {
        int nFontSizeDC = this.getFontSizeDC(vc);
        int nStyle = TextStyleObj.getStyleBI(this.m_nFontStyle);
        Font font = this.getFont(this.m_strFontName, nStyle, nFontSizeDC);
        FontMetrics fm = ImageViewExportXMLWriter.getFontMetrics(gx, font);
        gx.setFont(font);
        ArrayList<String> strLines = new ArrayList<String>();
        int nNumLines = 1;
        if (this.m_bWordwrap) {
            nNumLines = this.extractLinesWordWrap(strText, strLines, rBoundsDC.width, fm, perspect.getFontMetricsResolver());
        } else {
            strLines.add(strText);
        }
        Dimension dimThisLineDC = new Dimension(0, 0);
        Rectangle rTextBoundsDC = new Rectangle(rBoundsDC.x, rBoundsDC.y, rBoundsDC.width, rBoundsDC.height);
        Dimension dimMaxDC = new Dimension(rTextBoundsDC.width, rTextBoundsDC.height);
        for (int nLine = 0; nLine < nNumLines; ++nLine) {
            String strThisLine = (String)strLines.get(nLine);
            dimThisLineDC = this.getTextSizeDC(gx, strThisLine, nFontSizeDC, vc, dimMaxDC, dropShadowOffset, false, perspect.getFontMetricsResolver());
            Point ptTextDC = this.alignTextInBox(nLine, nNumLines, fm, rTextBoundsDC, dimThisLineDC, perspect);
            if (dropShadowOffset != null) {
                Point ptDropShadow = new Point(ptTextDC.x + dropShadowOffset.width, ptTextDC.y + dropShadowOffset.height);
                Color color = gx.getColor();
                gx.setColor(dropShadowColor);
                gx.drawString(strThisLine, ptDropShadow.x, ptDropShadow.y);
                if ((this.m_nFontStyle & 4) != 0) {
                    for (int i = 0; i < dimThisLineDC.height / 10; ++i) {
                        gx.drawLine(ptDropShadow.x, ptDropShadow.y + i + dimThisLineDC.height / 10, ptDropShadow.x + dimThisLineDC.width, ptDropShadow.y + i + dimThisLineDC.height / 10);
                    }
                }
                gx.setColor(color);
            }
            if (this.m_displayDrillIcon) {
                Image image = null;
                image = nFontSizeDC < 18 ? SMALL_DRILL_IMAGE : LARGE_DRILL_IMAGE;
                int imageSize = image.getWidth(null);
                gx.drawImage(image, rTextBoundsDC.x, rTextBoundsDC.y + (rTextBoundsDC.height - imageSize) / 2, null);
                ptTextDC.x += imageSize + 2;
                dimThisLineDC.width -= imageSize + 2;
            }
            gx.drawString(strThisLine, ptTextDC.x, ptTextDC.y);
            if ((this.m_nFontStyle & 4) == 0) continue;
            for (int i = 0; i < dimThisLineDC.height / 10; ++i) {
                gx.drawLine(ptTextDC.x, ptTextDC.y + i + dimThisLineDC.height / 10, ptTextDC.x + dimThisLineDC.width, ptTextDC.y + i + dimThisLineDC.height / 10);
            }
        }
    }

    public Point alignTextInBox(int nLine, int nNumLines, FontMetrics fm, Rectangle rTextDC, Dimension dimThisLineDC, Perspective perspect) {
        Point ptTextDC = new Point(0, 0);
        int horzAlign = this.m_nJustH;
        if (this.m_nJustH == 10) {
            horzAlign = LocaleUtils.getReadingDirectionForLocale((Locale)perspect.getLocale());
            if (horzAlign == 1) {
                horzAlign = 2;
            } else if (horzAlign == 2) {
                horzAlign = 4;
            }
        }
        switch (horzAlign) {
            case 2: {
                ptTextDC.x = rTextDC.x;
                break;
            }
            default: {
                ptTextDC.x = rTextDC.x + (rTextDC.width - dimThisLineDC.width) / 2;
                break;
            }
            case 4: {
                ptTextDC.x = rTextDC.x + rTextDC.width - dimThisLineDC.width;
            }
        }
        int descent = (int)Math.ceil((double)perspect.getFontMetricsResolver().getDescent(fm) / 2.0);
        switch (this.m_nJustV) {
            case 1: {
                int nLineAdjustment = (nLine + 1) * dimThisLineDC.height;
                ptTextDC.y = rTextDC.y + nLineAdjustment - descent;
                break;
            }
            default: {
                int nLineAdjustment = (nLine + 1) * dimThisLineDC.height;
                int nMiddleY = (rTextDC.height - nNumLines * dimThisLineDC.height) / 2;
                ptTextDC.y = rTextDC.y + nMiddleY + nLineAdjustment - descent;
                break;
            }
            case 3: {
                int nLineAdjustment = (nNumLines - nLine - 1) * dimThisLineDC.height;
                ptTextDC.y = rTextDC.y + rTextDC.height - nLineAdjustment - descent;
            }
        }
        return ptTextDC;
    }

    public int formatAndAutofit(Graphics gx, Perspective perspective, boolean bGroupAutofit, int nMinAutofit, int nMaxAutofit, int nFontSizeVC, List strLabels, Dimension labelDimVC, VC vc) {
        boolean bRotate = this.getRotationAngle() != 0;
        Dimension dimLabelDC = bRotate ? new Dimension(vc.virtToDestHeight(labelDimVC.height), vc.virtToDestWidth(labelDimVC.width)) : vc.virtToDest(labelDimVC);
        if (bGroupAutofit && !this.m_bUseDC) {
            int nFontSize = this.autofit(gx, strLabels, dimLabelDC, vc, perspective.getFontMetricsResolver());
            nFontSizeVC = vc.destToVirtHeight(nFontSize);
            if (nFontSizeVC < nMinAutofit) {
                nFontSizeVC = nMinAutofit;
            }
            if (nFontSizeVC > nMaxAutofit) {
                nFontSizeVC = nMaxAutofit;
            }
            this.m_nFontSizeVC = nFontSizeVC;
            this.m_bAutofit = false;
        }
        this.m_dimLargestTextDC = new Dimension(0, 0);
        int nStyle = TextStyleObj.getStyleBI(this.m_nFontStyle);
        int nFontSizeDC = vc.virtToDestHeight(nFontSizeVC);
        Font font = this.getFont(this.m_strFontName, nStyle, nFontSizeDC);
        FontMetrics fm = ImageViewExportXMLWriter.getFontMetrics(gx, font);
        for (int i = 0; i < strLabels.size(); ++i) {
            String strText = (String)strLabels.get(i);
            if (strText == null || strText.length() <= 0) continue;
            Dimension dimTextDC = new Dimension(0, 0);
            ArrayList<String> strLines = new ArrayList<String>();
            if (this.m_bWordwrap) {
                this.extractLinesWordWrap(strText, strLines, dimLabelDC.width, fm, perspective.getFontMetricsResolver());
            } else {
                strLines.add(strText);
            }
            dimTextDC = this.getSizeBoxDC(strLines, fm, perspective.getFontMetricsResolver());
            if (this.m_displayDrillIcon) {
                Image image = null;
                image = nFontSizeDC < 18 ? SMALL_DRILL_IMAGE : LARGE_DRILL_IMAGE;
                dimTextDC.width += image.getWidth(null) + 2;
            }
            this.m_dimLargestTextDC.width = Math.max(this.m_dimLargestTextDC.width, dimTextDC.width);
            this.m_dimLargestTextDC.height = Math.max(this.m_dimLargestTextDC.height, dimTextDC.height);
        }
        int nShrinkBox = 0;
        if (this.m_dimLargestTextDC.height > dimLabelDC.height) {
            ++nShrinkBox;
        }
        if (this.m_dimLargestTextDC.width > dimLabelDC.width) {
            nShrinkBox += 2;
        }
        dimLabelDC.width = Math.min(dimLabelDC.width, this.m_dimLargestTextDC.width);
        dimLabelDC.height = Math.min(dimLabelDC.height, this.m_dimLargestTextDC.height);
        if (bRotate) {
            labelDimVC.width = vc.destToVirtWidth(dimLabelDC.height);
            labelDimVC.height = vc.destToVirtHeight(dimLabelDC.width);
        } else {
            labelDimVC.width = vc.destToVirtWidth(dimLabelDC.width);
            labelDimVC.height = vc.destToVirtHeight(dimLabelDC.height);
        }
        return nShrinkBox;
    }

    public Dimension getDimLargeTextVC(VC vc) {
        Dimension dimLargeVC = null;
        if (this.m_dimLargestTextDC != null) {
            dimLargeVC = new Dimension(this.m_dimLargestTextDC);
            dimLargeVC.width = vc.destToVirtWidth(this.m_dimLargestTextDC.width);
            dimLargeVC.height = vc.destToVirtHeight(this.m_dimLargestTextDC.height);
        }
        return dimLargeVC;
    }

    public Font getFont(VC vc) {
        int nFontSize = this.getFontSizeDC(vc);
        int nStyle = TextStyleObj.getStyleBI(this.m_nFontStyle);
        return this.getFont(this.m_strFontName, nStyle, nFontSize);
    }

    public Font getFont(String strFontName, int nStyle, int nFontSize) {
        Font font = this.m_fontCache != null ? this.m_fontCache.getFont(strFontName, nStyle, nFontSize) : new Font(strFontName, nStyle, nFontSize);
        return font;
    }

    public String getFontName() {
        return this.m_strFontName;
    }

    public int getFontSizeDC(VC vc) {
        int nFontSize = this.m_bUseDC ? this.m_nFontSizeDC : vc.virtToDestHeight(this.m_nFontSizeVC);
        nFontSize = this.rangeChkFontPtSize(nFontSize);
        return nFontSize;
    }

    public int getFontSizeVC(VC vc) {
        int nFontSizeVC = this.m_bUseDC ? vc.destToVirtHeight(this.m_nFontSizeDC) : this.m_nFontSizeVC;
        nFontSizeVC = this.rangeChkFontVCSize(nFontSizeVC);
        return nFontSizeVC;
    }

    public int getHorizAlign() {
        return this.m_nJustH;
    }

    public int getVertAlign() {
        return this.m_nJustV;
    }

    public int getRotationAngle() {
        return this.m_nAngleSetting;
    }

    public void setRotationAngle(int nAngle) {
        this.m_nAngleSetting = nAngle;
    }

    public void setFontStyle(int style) {
        this.m_nFontStyle = style;
    }

    public int getFontStyle() {
        return this.m_nFontStyle;
    }

    public int getNumLines(Graphics gx, String strText, int nWidthDC, Dimension dropShadowOffset, VC vc, FontMetricsResolver resolver) {
        FontMetrics fm = this.getFontMetrics(gx, vc);
        ArrayList strLines = new ArrayList();
        int nNumLines = 1;
        if (this.m_bWordwrap) {
            nNumLines = this.extractLinesWordWrap(strText, strLines, nWidthDC, fm, resolver);
        }
        return nNumLines;
    }

    public FontMetrics getFontMetrics(Graphics gx, VC vc) {
        int nFontSizeDC = this.getFontSizeDC(vc);
        int nStyle = TextStyleObj.getStyleBI(this.m_nFontStyle);
        Font font = this.getFont(this.m_strFontName, nStyle, nFontSizeDC);
        FontMetrics fm = ImageViewExportXMLWriter.getFontMetrics(gx, font);
        return fm;
    }

    public Rectangle getTextBox(Graphics gx, String strText, Rectangle rBoundsDC, Dimension dropShadowOffset, VC vc, FontMetricsResolver resolver) {
        int nFontSizeDC = this.getFontSizeDC(vc);
        FontMetrics fm = this.getFontMetrics(gx, vc);
        ArrayList<String> strLines = new ArrayList<String>();
        if (this.m_bWordwrap) {
            this.extractLinesWordWrap(strText, strLines, rBoundsDC.width, fm, resolver);
        } else {
            strLines.add(strText);
        }
        Rectangle rTextDC = new Rectangle(rBoundsDC.x, rBoundsDC.y, rBoundsDC.width, rBoundsDC.height);
        Dimension dimTextDC = new Dimension(0, 0);
        Dimension dimMaxDC = new Dimension(rTextDC.width, rTextDC.height);
        int nMaxWidth = 0;
        int nLines = strLines.size();
        for (int iLine = 0; iLine < nLines; ++iLine) {
            dimTextDC = this.getTextSizeDC(gx, (String)strLines.get(iLine), nFontSizeDC, vc, dimMaxDC, dropShadowOffset, false, resolver);
            nMaxWidth = Math.max(dimTextDC.width, nMaxWidth);
        }
        return rTextDC;
    }

    public Dimension getTextSizeDC(Graphics gx, String strText, int nFontSizeDC, VC vc, Dimension dimMaxDC, Dimension dropShadowOffset, FontMetricsResolver resolver) {
        return this.getTextSizeDC(gx, strText, nFontSizeDC, vc, dimMaxDC, dropShadowOffset, this.m_bWordwrap, resolver);
    }

    public Dimension getTextSizeDC(Graphics gx, String strText, int nFontSizeDC, VC vc, Dimension dimMaxDC, Dimension dropShadowOffset, boolean bWordwrap, FontMetricsResolver resolver) {
        int nStyle = TextStyleObj.getStyleBI(this.m_nFontStyle);
        Font font = this.getFont(this.m_strFontName, nStyle, nFontSizeDC);
        FontMetrics fm = ImageViewExportXMLWriter.getFontMetrics(gx, font);
        ArrayList<String> strLines = new ArrayList<String>();
        if (bWordwrap) {
            this.extractLinesWordWrap(strText, strLines, dimMaxDC.width, fm, resolver);
        } else {
            strLines.add(strText);
        }
        Dimension dimTextDC = this.getSizeBoxDC(strLines, fm, resolver);
        if (this.m_displayDrillIcon) {
            Image image = null;
            image = nFontSizeDC < 18 ? SMALL_DRILL_IMAGE : LARGE_DRILL_IMAGE;
            dimTextDC.width += image.getWidth(null) + 2;
        }
        if (dropShadowOffset != null) {
            dimTextDC.width = dimTextDC.width + dropShadowOffset.width + 1;
        }
        return dimTextDC;
    }

    private Dimension getSizeBoxDC(List strLines, FontMetrics fm, FontMetricsResolver resolver) {
        int nNumLines = strLines.size();
        Dimension dimTextDC = new Dimension(0, 0);
        int nWidth = 0;
        for (int i = 0; i < nNumLines; ++i) {
            nWidth = resolver.stringWidth((String)strLines.get(i), fm);
            dimTextDC.width = Math.max(dimTextDC.width, nWidth);
        }
        dimTextDC.height = nNumLines * TextStyleObj.getFontHeight(fm, resolver);
        return dimTextDC;
    }

    public static int getFontHeight(FontMetrics fm, FontMetricsResolver resolver) {
        int height = 0;
        height = resolver != null ? resolver.getHeight(fm) : fm.getHeight();
        int percent = 85;
        height = (int)((double)(percent * height) / 100.0);
        return height;
    }

    public Dimension preDraw(Graphics gx, String strText, Rectangle rBoundsDC, VC vc, Dimension dropShadowOffset, FontMetricsResolver resolver) {
        int nFontSizeDC = this.m_bAutofit ? this.autofit(gx, strText, new Dimension(rBoundsDC.width, rBoundsDC.height), vc, resolver) : (this.m_bUseDC ? this.m_nFontSizeDC : vc.virtToDestHeight(this.m_nFontSizeVC));
        nFontSizeDC = this.rangeChkFontPtSize(nFontSizeDC);
        Dimension dimMaxDC = new Dimension(rBoundsDC.width, rBoundsDC.height);
        Dimension dimLabelDC = this.getTextSizeDC(gx, strText, nFontSizeDC, vc, dimMaxDC, dropShadowOffset, resolver);
        return dimLabelDC;
    }

    public void setHorizAlign(int nJustH) {
        this.m_nJustH = nJustH;
    }

    public void setVertAlign(int nJustV) {
        this.m_nJustV = nJustV;
    }

    private int rangeChkFontPtSize(int nFontPtSize) {
        if (nFontPtSize > Integer.MAX_VALUE) {
            nFontPtSize = Integer.MAX_VALUE;
        }
        if (nFontPtSize <= 0) {
            nFontPtSize = 1;
        }
        return nFontPtSize;
    }

    private int rangeChkFontVCSize(int nFontVCSize) {
        if (nFontVCSize > 6000) {
            nFontVCSize = 6000;
        }
        if (nFontVCSize <= 0) {
            nFontVCSize = 1;
        }
        return nFontVCSize;
    }

    public static int getStyleBI(int nStyle) {
        int nStyleBI = 0;
        nStyleBI += (nStyle & 1) != 0 ? 2 : 0;
        return nStyleBI += (nStyle & 2) != 0 ? 1 : 0;
    }

    public int extractLinesWordWrap(String strText, List strLines, int nMaxWidth, FontMetrics fm, FontMetricsResolver resolver) {
        int nNumLines = 0;
        strLines.clear();
        int spaceWidth = resolver.charWidth(' ', fm);
        if (strText != null) {
            int colPos = 0;
            String separators = " \t\n\r\f";
            String line = "";
            StringTokenizer tokenizer = new StringTokenizer(strText, separators, true);
            while (tokenizer.hasMoreTokens()) {
                boolean firstWord;
                String word = tokenizer.nextToken();
                if (separators.indexOf(word) != -1) {
                    if (!word.equals("\n")) continue;
                    if (this.m_textTrunc) {
                        if (!this.truncateText(strLines, line, nMaxWidth, fm, true, resolver)) continue;
                        return strLines.size();
                    }
                    colPos = 0;
                    strLines.add(line);
                    line = "";
                    continue;
                }
                int width = resolver.stringWidth(word, fm);
                boolean bl = firstWord = line.length() == 0;
                if (!firstWord) {
                    colPos += spaceWidth;
                }
                if ((colPos += width) > nMaxWidth) {
                    if (!firstWord) {
                        if (this.m_textTrunc) {
                            if (this.truncateText(strLines, line, nMaxWidth, fm, true, resolver)) {
                                return strLines.size();
                            }
                        } else {
                            strLines.add(line);
                        }
                    }
                    line = word;
                    colPos = width;
                    continue;
                }
                if (!firstWord) {
                    line = line + ' ';
                }
                line = line + word;
            }
            if (this.m_textTrunc) {
                if (this.truncateText(strLines, line, nMaxWidth, fm, false, resolver)) {
                    return strLines.size();
                }
            } else {
                strLines.add(line);
            }
        }
        nNumLines = strLines.size();
        return nNumLines;
    }

    public boolean getWordWrap() {
        return this.m_bWordwrap;
    }

    public void setWordWrap(boolean wrap) {
        this.m_bWordwrap = wrap;
    }

    public void setTextTruncate(boolean trunc, int stopAtLine, int minChars) {
        this.m_textTrunc = trunc;
        this.m_stopAtLine = stopAtLine;
        this.m_minChars = minChars;
    }

    public void setTextTruncated(boolean textTruncated) {
        this.m_textTruncated = textTruncated;
    }

    public boolean isTextTruncated() {
        return this.m_textTruncated;
    }

    public static int getJavaFontStyle(int pfjStyle) {
        int fontStyle = 0;
        fontStyle |= (pfjStyle & 1) != 0 ? 2 : 0;
        return fontStyle |= (pfjStyle & 2) != 0 ? 1 : 0;
    }

    private boolean truncateText(List strLines, String line, int nMaxWidth, FontMetrics fm, boolean moreWords, FontMetricsResolver resolver) {
        if (strLines.size() == this.m_stopAtLine - 1 && moreWords) {
            line = PresUtils.isBIDILocale(this.m_locale) ? "...".concat(line) : line.concat("...");
            this.m_textTruncated = true;
        }
        if (resolver.stringWidth(line, fm) <= nMaxWidth) {
            strLines.add(line);
            return strLines.size() == this.m_stopAtLine;
        }
        if (!this.m_textTruncated || !PresUtils.isBIDILocale(this.m_locale)) {
            this.m_textTruncated = true;
            line = PresUtils.truncateText(line, fm, this.m_minChars, nMaxWidth, resolver, this.m_locale);
        }
        strLines.add(line);
        return strLines.size() == this.m_stopAtLine;
    }

    public String truncateString(String strText, int nTruncCount) {
        String strTrunc = strText;
        if (strText.length() > nTruncCount && nTruncCount > 3) {
            strTrunc = strText.substring(0, nTruncCount - 3);
            strTrunc = PresUtils.isBIDILocale(this.m_locale) ? "...".concat(strTrunc) : strTrunc.concat("...");
        }
        return strTrunc;
    }

    public static int calcAxisLabelGap(int fontSize) {
        int incrInFont = (fontSize - 10) * 100 / 10;
        int gap = 10 + incrInFont * 50 * 10 / 26000;
        return gap;
    }

    public void setDisplayDrillIcon(boolean flag) {
        this.m_displayDrillIcon = flag;
    }

    public boolean isDisplayDrillIcon() {
        return this.m_displayDrillIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImageResource(Class cl, String name) {
        Image outImage = null;
        byte[] imageBuffer = null;
        InputStream inStream = cl.getResourceAsStream(name);
        if (inStream != null) {
            try {
                int n;
                BufferedInputStream inBuffer = new BufferedInputStream(inStream);
                ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                imageBuffer = new byte[1024];
                while ((n = inBuffer.read(imageBuffer)) > 0) {
                    out.write(imageBuffer, 0, n);
                }
                out.flush();
                imageBuffer = out.toByteArray();
            }
            catch (IOException inBuffer) {
            }
            finally {
                try {
                    inStream.close();
                }
                catch (IOException inBuffer) {}
            }
        }
        if (imageBuffer != null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            outImage = tk.createImage(imageBuffer);
            int status = tk.checkImage(outImage, -1, -1, null);
            boolean imageLoaded = false;
            if ((status & 0x30) == 0) {
                ImageLoader load = new ImageLoader(outImage);
                load.start();
                imageLoaded = load.waitFor();
            } else {
                imageLoaded = true;
            }
            if (!imageLoaded) {
                outImage = null;
            }
        }
        return outImage;
    }
}

