/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import oracle.dss.gauge.DrawableObject;
import oracle.dss.gauge.GaugeDefaultValues;
import oracle.dss.gauge.GaugeEngine;
import oracle.dss.gauge.GaugeType;
import oracle.dss.presutil.PresUtils;

public class LabelGauge
extends GaugeType {
    protected static final int GAP_GAUGESET_LABEL = 2;
    private static final int DEFAULT_TEXT_ROTATION_ANGLE = 270;

    public LabelGauge(GaugeEngine engine) {
        super(engine);
    }

    @Override
    public int getGaugeType() {
        return 5;
    }

    @Override
    protected Dimension autoLayout(Graphics2D g, Rectangle rect, Map map) {
        Color topFontColor;
        if (g == null) {
            g = this._engine.getGraphics();
        }
        int reqAboveSpace = this.getSpaceAboveGauge(map, g);
        int reqBelowSpace = this.getSpaceBelowGauge(map, g);
        int reqLeftSpace = this.getSpaceLeftOfGauge(map, g);
        int reqRightSpace = this.getSpaceRightOfGauge(map, g);
        this._gaugeFrameBounds = null;
        this._innerBounds = null;
        this._topLabelBounds = null;
        this._bottomLabelBounds = null;
        this._upperLabelFrameBounds = null;
        this._lowerLabelFrameBounds = null;
        this._calcLabelDimensions(map, g);
        this._gaugeFrameBounds = new Rectangle(rect.x + reqLeftSpace, rect.y + reqAboveSpace, rect.width - reqLeftSpace - reqRightSpace, rect.height - reqAboveSpace - reqBelowSpace);
        this._innerBounds = this._getPlotAreaBounds(this._gaugeFrameBounds, map, g);
        String topLabel = this._engine.getTopLabel();
        Font topFont = (Font)map.get("TopLabelFont");
        if (topFont == null) {
            topFont = GaugeDefaultValues.getTopLabelFont();
        }
        if ((topFontColor = (Color)map.get("TopLabelColor")) == null) {
            topFontColor = GaugeDefaultValues.getTopLabelFontColor();
        }
        Dimension topLblDim = DrawableObject.getLabelDimensions(g, topFont, topLabel);
        Dimension reqSize = new Dimension();
        reqSize.width = topLblDim.height + reqLeftSpace + reqRightSpace;
        reqSize.height = Math.min(this._gaugeFrameBounds.height, topLblDim.width) + reqAboveSpace + reqBelowSpace;
        if (reqSize.width < 0) {
            reqSize.width = 10;
        }
        if (reqSize.height < 0) {
            reqSize.height = 10;
        }
        return reqSize;
    }

    @Override
    protected Collection getLabelObjects(Map map, Rectangle outerBounds) {
        Color topFontColor;
        ArrayList<DrawableObject.Label> lblObjects = new ArrayList<DrawableObject.Label>();
        Graphics2D g = this._engine.getGraphics();
        String topLabel = this._engine.getTopLabel();
        Font topFont = (Font)map.get("TopLabelFont");
        if (topFont == null) {
            topFont = GaugeDefaultValues.getTopLabelFont();
        }
        if ((topFontColor = (Color)map.get("TopLabelColor")) == null) {
            topFontColor = GaugeDefaultValues.getTopLabelFontColor();
        }
        Dimension topLblDim = DrawableObject.getLabelDimensions(g, topFont, topLabel);
        if (this._innerBounds != null) {
            String fullTopLabel = topLabel;
            if (topLblDim != null && topLblDim.width > this._innerBounds.height) {
                FontMetrics fm = g.getFontMetrics(topFont);
                topLabel = PresUtils.truncateText(topLabel, fm, 0, this._innerBounds.height);
                topLblDim = DrawableObject.getLabelDimensions(g, topFont, topLabel);
            }
            int angle = 270;
            int x = (int)(this._innerBounds.getCenterX() - topLblDim.getWidth() / 2.0 - topLblDim.getHeight() / 4.0);
            int y = (int)(this._innerBounds.getMaxY() - topLblDim.getHeight() / 2.0 - topLblDim.getWidth() / 2.0);
            Rectangle bounds = new Rectangle(x, y, topLblDim.width, topLblDim.height);
            DrawableObject.Label label = new DrawableObject.Label(16, g, fullTopLabel, topFont, topFontColor, bounds, "TopLabel", null, angle);
            label.setTruncatedText(topLabel);
            lblObjects.add(label);
        }
        return lblObjects;
    }

    @Override
    protected Collection getPlotAreaObject(Map map, int type) {
        ArrayList list = new ArrayList();
        return list;
    }

    @Override
    protected Collection getIndicatorObject(Map map, int metricIndex) {
        return Collections.EMPTY_LIST;
    }

    @Override
    protected Collection getTickLabelObjects(Map map) {
        ArrayList list = new ArrayList();
        return list;
    }

    @Override
    protected Collection getTickMarkObjects(Map map) {
        ArrayList list = new ArrayList();
        return list;
    }

    @Override
    protected DrawableObject getNoDataLabelObject(Map map) {
        String noDataLabel = this._engine.getIntlStringFromUtilBundle("af_dvt_util.NO_DATA");
        Font font = (Font)map.get("TickLabelFont");
        if (font == null) {
            font = GaugeDefaultValues.getNoDataLabelFont();
        }
        Dimension dim = DrawableObject.getLabelDimensions(this._engine.getGraphics(), font, noDataLabel);
        int drawWidth = this._innerBounds.width - 10;
        if (dim.width > drawWidth) {
            return null;
        }
        Rectangle bounds = new Rectangle();
        bounds.x = this._innerBounds.x + this._innerBounds.width / 2 - dim.width / 2;
        bounds.y = this._innerBounds.y + this._innerBounds.height - 3 - dim.height;
        bounds.width = dim.width;
        bounds.height = dim.height;
        return DrawableObject.getLabelObject(this._engine.getGraphics(), noDataLabel, font, GaugeDefaultValues.getNoDataLabelFontColor(), bounds, "NoDataLabel");
    }

    @Override
    protected Collection getGaugeFrameObject(Map map) {
        ArrayList list = new ArrayList();
        return list;
    }

    @Override
    protected Collection getGaugeLinkObject(Map map, Rectangle outerBounds) {
        ArrayList list = new ArrayList();
        return list;
    }

    @Override
    protected int getGaugeRadius(int availWidth, int availHeight) {
        return Math.min(availHeight, availWidth);
    }

    @Override
    protected Rectangle getInnerBounds(Map map, Rectangle rect, int reqAboveSpace, int reqBelowSpace, int reqLeftSpace, int reqRightSpace) {
        int availHeight = rect.height - reqAboveSpace - reqBelowSpace;
        int availWidth = rect.width - reqLeftSpace - reqRightSpace;
        Rectangle bounds = new Rectangle();
        bounds.x = rect.x + reqLeftSpace;
        bounds.y = rect.y + reqAboveSpace;
        bounds.width = availWidth;
        bounds.height = availHeight;
        return bounds;
    }

    @Override
    protected int getMaxNumberOfSteps() {
        return 0;
    }

    @Override
    protected int getGaugeSetGap(Map map, Graphics2D g, int dir) {
        return 2;
    }

    @Override
    protected Rectangle _getPlotAreaBounds(Rectangle gaugeFrameBounds, Map map, Graphics2D g) {
        int reqAboveSpace = 0;
        int reqBelowSpace = 0;
        int reqLeftSpace = 0;
        int reqRightSpace = 0;
        return this.getInnerBounds(map, gaugeFrameBounds, reqAboveSpace, reqBelowSpace, reqLeftSpace, reqRightSpace);
    }
}

