/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dss.gauge.CustomShape;
import oracle.dss.gauge.DrawableObject;
import oracle.dss.gauge.GaugeDefaultValues;
import oracle.dss.gauge.GaugeEngine;
import oracle.dss.gauge.GaugeType;
import oracle.dss.graph.pfj.ReversePathIterator;

public class DialGauge
extends GaugeType {
    private static final double GAP_PLOTAREA_GAUGEFRAME = 0.04;
    private static double WIDTH_INDICATOR_BASE = 0.2;
    private static double LENGTH_INDICATOR_LINE = 0.62;
    private static double LENGTH_INDICATOR_NEEDLE = 0.52;
    private static double WIDTH_INDICATOR_NEEDLE = 0.11;
    private static double LENGTH_INDICATOR_NEEDLE_TIP = 0.055;
    private static double LENGTH_INDICATOR_FILL = 0.94;
    private static double LENGTH_INDICATOR_CUSTOM = 0.9;
    private static double WIDTH_THRESHOLD = 0.065;
    private static double THRESHOLD_SEGMENTS_GAP_DEGREES = 1.5;
    private static int LENGTH_TICKMARK_MIN_MAX = 8;
    private static double LENGTH_INDICATOR_INCREASE = 0.45;
    private static double SMALL_FRAME_ANGLE_START = -20.0;
    private static double SMALL_FRAME_ANGLE_EXTENT = 220.0;
    private static final double INCR_FACTOR = 0.04;
    private static final int TICKLABEL_GAP = 4;
    private static final int TICKLABEL_INTERIOR_GAP = 7;
    private static final int TICKLABEL_INTERIOR_OFFSET = -2;
    private static final double MIN_GAUGE_SPACE_VERT = 0.3;
    private Rectangle _thresholdBounds = null;
    private Rectangle _tickMarkArcBounds;
    private Point2D _anchorPoint;
    private ArrayList<Point2D> _tickMarkPositions;
    private int _tickMarkRadius = 0;
    private int _radius = 0;
    private Rectangle _indicatorBaseBounds;
    private final int _angleStart;
    private final int _angleExtent;
    private AffineTransform m_firstIndicatorScale = null;
    private AffineTransform m_firstIndicatorMove = null;

    public DialGauge(GaugeEngine engine) {
        super(engine);
        Integer extent = (Integer)this._engine.getAttribute("AngleExtent");
        if (extent == null) {
            extent = GaugeDefaultValues.getAngleExtent();
        }
        this._angleStart = 90 - extent / 2;
        this._angleExtent = extent;
    }

    @Override
    public int getGaugeType() {
        return 0;
    }

    @Override
    protected Dimension autoLayout(Graphics2D g, Rectangle rect, Map map) {
        Dimension dim = super.autoLayout(g, rect, map);
        if (this._csParser == null || !this._csParser.defines("plotAreaBounds") && !this._csParser.defines("gaugeFrame")) {
            int metLblPos;
            if (this.isSpaceLimited(dim, rect)) {
                this._layout.setScalingUsed(true);
                dim = super.autoLayout(g, rect, map);
            }
            int labelsRemoved = 0;
            if (this.isSpaceLimited(dim, rect)) {
                int topLblPos = this.getTopLabelPosition(map);
                if (topLblPos == 3 && (this._csParser == null || !this._csParser.defines("topLabelBounds") && !this._csParser.defines("upperLabelFrame"))) {
                    map.put("TopLabelPosition", 0);
                    dim = super.autoLayout(g, rect, map);
                }
                ++labelsRemoved;
            }
            if (this.isSpaceLimited(dim, rect)) {
                int tickLabelPos = GaugeDefaultValues.getTickLabelPosition();
                if (map.get("TickLabelPosition") != null) {
                    tickLabelPos = (Integer)map.get("TickLabelPosition");
                }
                map.put("TickLabelContent", 0);
                dim = super.autoLayout(g, rect, map);
                ++labelsRemoved;
            }
            if (this.isSpaceLimited(dim, rect)) {
                int bottomLblPos = this.getBottomLabelPosition(map);
                if (bottomLblPos == 1 && (this._csParser == null || !this._csParser.defines("bottomLabelBounds") && !this._csParser.defines("lowerLabelFrame"))) {
                    map.put("BottomLabelPosition", 0);
                    dim = super.autoLayout(g, rect, map);
                }
                ++labelsRemoved;
            }
            if (this.isSpaceLimited(dim, rect) && (metLblPos = this.getMetricLabelPosition(map)) == 1 && (this._csParser == null || !this._csParser.defines("metricLabelBounds") && !this._csParser.defines("lowerLabelFrame"))) {
                map.put("MetricLabelPosition", 0);
                dim = super.autoLayout(g, rect, map);
            }
            if (labelsRemoved == 3) {
                this._engine.getErrorHandler().trace(this._engine.getIntlString("af_dvt_gauge.LABEL_REMOVE_TOP_TICK_BOTTOM", this._gaugeBundle), this.getClass().getName(), "autoLayout");
            } else if (labelsRemoved == 2) {
                this._engine.getErrorHandler().trace(this._engine.getIntlString("af_dvt_gauge.LABEL_REMOVE_TOP_TICK", this._gaugeBundle), this.getClass().getName(), "autoLayout");
            } else if (labelsRemoved == 1) {
                this._engine.getErrorHandler().trace(this._engine.getIntlString("af_dvt_gauge.LABEL_REMOVE_TOP", this._gaugeBundle), this.getClass().getName(), "autoLayout");
            }
        }
        return dim;
    }

    boolean isSpaceLimited(Dimension reqSize, Rectangle availBounds) {
        return this._gaugeFrameBounds.height < 40;
    }

    @Override
    protected Collection getPlotAreaObject(Map map, int type) {
        if (this._anchorPoint == null) {
            this._anchorPoint = this._calcIndicatorAnchorPoint();
        }
        ArrayList<Object> objects = new ArrayList<Object>(15);
        if (this._csParser != null && (this._csParser.defines("plotArea") || this._csParser.defines("plotAreaBounds"))) {
            this._radius = this._angleExtent <= 180 ? this._innerBounds.height : this._innerBounds.width / 2;
        }
        if (this._csParser != null && this._csParser.defines("plotArea")) {
            AffineTransform move;
            AffineTransform scale;
            Rectangle2D bounds = this._csParser.getBounds("plotArea");
            if (this._scaleTransform != null && this._moveTransform != null) {
                scale = this._scaleTransform;
                move = this._moveTransform;
            } else {
                scale = DialGauge.getScalingTransform(bounds, this._innerBounds);
                this._moveTransform = move = DialGauge.getTranslateTransform(bounds, this._innerBounds, scale);
                this._scaleTransform = scale;
            }
            Color userBorderColor = (Color)map.get("PlotAreaBorderColor");
            Color userFillColor = (Color)map.get("PlotAreaFillColor");
            if (map.get("PlotAreaUseThresholdFillColor") != null && ((Boolean)map.get("PlotAreaUseThresholdFillColor")).booleanValue()) {
                userFillColor = this._getIndicatorColor(map, true);
            }
            HashMap userSFXMap = (HashMap)map.get("PlotAreaSFX");
            List<CustomShape> shapesList = this._csParser.getShapes("plotArea");
            for (int i = 0; i < shapesList.size(); ++i) {
                CustomShape cs = shapesList.get(i);
                Shape s = cs.getShape();
                s = scale.createTransformedShape(s);
                s = move.createTransformedShape(s);
                Color csBorderColor = userBorderColor != null ? userBorderColor : cs.getBorderColor();
                Color csFillColor = userFillColor != null ? userFillColor : cs.getFillColor();
                HashMap csSFXMap = userSFXMap != null ? userSFXMap : cs.getSFXMap();
                objects.add(new DrawableObject.Shape(11, s, csBorderColor, csFillColor, csSFXMap, null));
            }
            if (map.get("ThresholdValues") != null) {
                objects.add(this._getThresholdObjects(map));
            }
        } else {
            Integer gradientDir;
            Integer fillType;
            HashMap paSFX;
            Arc2D.Double plotArc = new Arc2D.Double();
            ((Arc2D)plotArc).setArc(this._innerBounds.x, this._innerBounds.y, this._innerBounds.width, this._radius * 2, this._angleStart, this._angleExtent, 1);
            if (this._angleExtent == 360) {
                plotArc.setArcType(0);
            }
            if ((paSFX = (HashMap)map.get("PlotAreaSFX")) != null && (fillType = (Integer)paSFX.get("SFX_FILL_TYPE")) != null && fillType == 2 && (gradientDir = (Integer)paSFX.get("SFX_GRADIENT_DIRECTION")) != null) {
                double dist = (double)(this._innerBounds.width / 2) * 0.4 / Math.sqrt(2.0);
                if (gradientDir == 14) {
                    Point2D.Double gradientCtr = new Point2D.Double(this._anchorPoint.getX() - dist, this._anchorPoint.getY() - dist);
                    paSFX.put("SFX_GRADIENT_CENTER", gradientCtr);
                } else if (gradientDir == 9) {
                    paSFX.put("SFX_GRADIENT_CENTER", this._anchorPoint);
                }
            }
            if (map.get("ThresholdValues") == null) {
                if (type != GaugeEngine.BORDER_ONLY) {
                    Color borderColor;
                    Color fillColor = (Color)map.get("PlotAreaFillColor");
                    if (fillColor == null) {
                        fillColor = GaugeDefaultValues.getPlotAreaFillColor(this.getGaugeType());
                    }
                    if ((borderColor = (Color)map.get("PlotAreaBorderColor")) == null) {
                        borderColor = GaugeDefaultValues.getPlotAreaBorderColor(this.getGaugeType());
                    }
                    objects.add(new DrawableObject.Shape(11, plotArc, borderColor, fillColor, paSFX, null));
                }
            } else if (type != GaugeEngine.FILL_ONLY) {
                Color plotAreaColor = null;
                plotAreaColor = map.get("PlotAreaUseThresholdFillColor") != null && (Boolean)map.get("PlotAreaUseThresholdFillColor") != false ? this._getIndicatorColor(map, true) : (Color)map.get("PlotAreaFillColor");
                objects.add(new DrawableObject.Shape(11, plotArc, null, plotAreaColor, paSFX, null));
                objects.add(this._getThresholdObjects(map));
            }
        }
        return objects;
    }

    @Override
    protected Collection getIndicatorObject(Map map, int metricIndex) {
        HashMap<String, Object> sfxMap;
        ArrayList<DrawableObject> objects = new ArrayList<DrawableObject>(15);
        if (this._engine.isNullMetric()) {
            DrawableObject noDataObj = this.getNoDataLabelObject(map);
            if (noDataObj != null) {
                objects.add(noDataObj);
            }
            return objects;
        }
        Double metric = this._engine.getMetric(metricIndex);
        if (metric == null) {
            return Collections.emptyList();
        }
        int indicatorType = GaugeDefaultValues.getIndicatorType();
        if (GaugeEngine.getIndicatorAttr(map, "IndicatorType", metricIndex) != null) {
            indicatorType = (Integer)GaugeEngine.getIndicatorAttr(map, "IndicatorType", metricIndex);
        }
        if ((sfxMap = (HashMap<String, Object>)GaugeEngine.getIndicatorAttr(map, "IndicatorSFX", metricIndex)) == null && indicatorType == 1) {
            sfxMap = GaugeDefaultValues.getFillIndicatorSFX();
        }
        if (sfxMap == null) {
            sfxMap = new HashMap<String, Object>();
        }
        boolean autoColor = GaugeDefaultValues.isIndicatorUseThresholdFillColor();
        if (GaugeEngine.getIndicatorAttr(map, "IndicatorUseThresholdFillColor", metricIndex) != null) {
            autoColor = (Boolean)GaugeEngine.getIndicatorAttr(map, "IndicatorUseThresholdFillColor", metricIndex);
        }
        Color indicatorColor = this._getIndicatorColor(map, autoColor, metricIndex);
        Color borderColor = (Color)GaugeEngine.getIndicatorAttr(map, "IndicatorBorderColor", metricIndex);
        if (borderColor == null) {
            if (indicatorType == 0) {
                borderColor = indicatorColor;
            } else if (indicatorType != 2) {
                borderColor = GaugeDefaultValues.getIndicatorBorderColor();
            }
        }
        int visualEffects = GaugeDefaultValues.getVisualEffects();
        if (map.get("VisualEffects") != null) {
            visualEffects = (Integer)map.get("VisualEffects");
        }
        boolean isVisible = true;
        if (metric > this._engine.getMax() || metric < this._engine.getMin()) {
            metric = metric > this._engine.getMax() ? Double.valueOf(this._engine.getMax()) : Double.valueOf(this._engine.getMin());
            if (this._engine.isEnvironmentAdf()) {
                isVisible = false;
            }
        }
        if (visualEffects != 0) {
            sfxMap.putAll(GaugeDefaultValues.getIndicatorVisualEffects(indicatorType));
        }
        double metricAngle = (double)this._angleExtent * (metric - this._engine.getMin()) / (this._engine.getMax() - this._engine.getMin());
        metricAngle = (double)this._angleExtent - metricAngle + (double)this._angleStart;
        Arc2D.Double arc = new Arc2D.Double();
        ((Arc2D)arc).setArc(this._innerBounds.x, this._innerBounds.y, this._innerBounds.width, this._radius * 2, 0.0, metricAngle, 2);
        this._anchorPoint = this._calcIndicatorAnchorPoint();
        double x1 = this._anchorPoint.getX();
        double y1 = this._anchorPoint.getY();
        this._engine.setAttribute("MetadataPointOfRotation", this._anchorPoint);
        AffineTransform scale = null;
        AffineTransform move = null;
        if (this._csParser != null && this._csParser.defines("indicator")) {
            Rectangle2D bounds = this._csParser.getBounds("indicator");
            if (this._scaleTransform != null && this._moveTransform != null) {
                scale = this._scaleTransform;
                move = this._moveTransform;
            } else {
                double centerY;
                double centerX;
                double scaleFactor = (double)this._radius * LENGTH_INDICATOR_CUSTOM / bounds.getHeight();
                scale = new AffineTransform();
                scale.scale(scaleFactor, scaleFactor);
                Rectangle2D scaledBounds = scale.createTransformedShape(bounds).getBounds2D();
                Rectangle2D center = this._csParser.getBounds("indicatorCenter");
                if (center != null) {
                    Rectangle2D centerBounds = center.getBounds2D();
                    centerX = centerBounds.getCenterX();
                    centerY = centerBounds.getCenterY();
                } else {
                    centerX = bounds.getCenterX();
                    centerY = bounds.getY() + bounds.getHeight();
                }
                double scaledCenterX = scaledBounds.getX() + (centerX - bounds.getX()) / bounds.getWidth() * scaledBounds.getWidth();
                double scaledCenterY = scaledBounds.getY() + (centerY - bounds.getY()) / bounds.getHeight() * scaledBounds.getHeight();
                move = new AffineTransform();
                move.translate(x1 - scaledCenterX, y1 - scaledCenterY);
            }
            AffineTransform rotate = new AffineTransform();
            rotate.rotate(Math.toRadians(450.0 - metricAngle), x1, y1);
            Color userBorderColor = (Color)GaugeEngine.getIndicatorAttr(map, "IndicatorBorderColor", metricIndex);
            Color userFillColor = (Color)GaugeEngine.getIndicatorAttr(map, "IndicatorFillColor", metricIndex);
            if (GaugeEngine.getIndicatorAttr(map, "IndicatorUseThresholdFillColor", metricIndex) != null) {
                if (((Boolean)GaugeEngine.getIndicatorAttr(map, "IndicatorUseThresholdFillColor", metricIndex)).booleanValue()) {
                    userFillColor = this._getIndicatorColor(map, true, metricIndex);
                }
            }
            HashMap<String, Object> userSFXMap = (HashMap<String, Object>)GaugeEngine.getIndicatorAttr(map, "IndicatorSFX", metricIndex);
            List<CustomShape> shapesList = this._csParser.getShapes("indicator");
            for (int i = 0; i < shapesList.size(); ++i) {
                HashMap<String, Object> csSFXMap;
                CustomShape cs = shapesList.get(i);
                Shape s = cs.getShape();
                s = scale.createTransformedShape(s);
                s = move.createTransformedShape(s);
                s = rotate.createTransformedShape(s);
                Color csBorderColor = userBorderColor != null ? userBorderColor : cs.getBorderColor();
                Color csFillColor = userFillColor != null ? userFillColor : cs.getFillColor();
                HashMap<String, Object> hashMap = csSFXMap = userSFXMap != null ? userSFXMap : cs.getSFXMap();
                if (metric > this._engine.getMax() || metric < this._engine.getMin()) {
                    csFillColor = new Color(csFillColor.getRed(), csFillColor.getGreen(), csFillColor.getBlue(), 0);
                    csBorderColor = null;
                    csSFXMap = new HashMap();
                }
                if (visualEffects != 0) {
                    if (csSFXMap == null) {
                        csSFXMap = GaugeDefaultValues.getIndicatorVisualEffects(indicatorType);
                    } else {
                        csSFXMap.putAll(GaugeDefaultValues.getIndicatorVisualEffects(indicatorType));
                    }
                }
                objects.add(new DrawableObject.Shape(14, metricIndex, map, s, csBorderColor, csFillColor, csSFXMap, null));
            }
        } else if (indicatorType == 1) {
            double fillRadius = (double)this._radius * LENGTH_INDICATOR_FILL;
            ((Arc2D)arc).setArc(x1 - fillRadius, y1 - fillRadius, fillRadius * 2.0, fillRadius * 2.0, metricAngle, (double)(this._angleStart + this._angleExtent) - metricAngle, 2);
            objects.add(new DrawableObject.Shape(14, metricIndex, map, arc, borderColor, indicatorColor, sfxMap, null));
        } else {
            int indLength;
            double indRatio = 0.0;
            if (this._radius <= 50) {
                indRatio += LENGTH_INDICATOR_INCREASE * (double)(50 - this._radius) / 50.0;
            }
            Polygon indicator = new Polygon();
            if (indicatorType == 0) {
                indLength = (int)((double)this._radius * (LENGTH_INDICATOR_LINE + indRatio));
                indicator.addPoint((int)x1, (int)y1 + 1);
                indicator.addPoint((int)x1, (int)y1 - 1);
                indicator.addPoint((int)x1 + indLength, (int)y1 - 1);
                indicator.addPoint((int)x1 + indLength, (int)y1 + 1);
            } else {
                indLength = (int)((double)this._radius * (LENGTH_INDICATOR_NEEDLE + indRatio));
                int indWidth = (int)((double)this._radius * WIDTH_INDICATOR_NEEDLE);
                int tipLength = (int)((double)this._radius * LENGTH_INDICATOR_NEEDLE_TIP);
                indicator.addPoint((int)x1, (int)y1 + indWidth / 2);
                indicator.addPoint((int)x1, (int)y1 - indWidth / 2);
                indicator.addPoint((int)x1 + indLength, (int)y1 - indWidth / 2);
                indicator.addPoint((int)x1 + indLength + tipLength, (int)y1);
                indicator.addPoint((int)x1 + indLength, (int)y1 + indWidth / 2);
            }
            AffineTransform rotate = new AffineTransform();
            rotate.rotate(Math.toRadians(360.0 - metricAngle), x1, y1);
            Shape rotatedIndicator = rotate.createTransformedShape(indicator);
            objects.add(new DrawableObject.Shape(14, metricIndex, map, rotatedIndicator, borderColor, indicatorColor, sfxMap, null));
        }
        if (!isVisible) {
            for (DrawableObject obj : objects) {
                obj.setVisible(isVisible);
            }
        }
        if (metricIndex == 0) {
            this.m_firstIndicatorScale = scale;
            this.m_firstIndicatorMove = move;
        }
        return objects;
    }

    protected Collection<DrawableObject> getIndicatorBaseObject(Map map) {
        this._indicatorBaseBounds = null;
        ArrayList<DrawableObject> objects = new ArrayList<DrawableObject>();
        AffineTransform scale = this.m_firstIndicatorScale;
        AffineTransform move = this.m_firstIndicatorMove;
        Boolean isVisible = (Boolean)map.get("IndicatorBaseVisible");
        if (isVisible == null) {
            isVisible = GaugeDefaultValues.isIndicatorBaseVisible();
        }
        if (!isVisible.booleanValue()) {
            return objects;
        }
        int visualEffects = GaugeDefaultValues.getVisualEffects();
        if (map.get("VisualEffects") != null) {
            visualEffects = (Integer)map.get("VisualEffects");
        }
        double baseWidth = (double)(this._radius * 2) * WIDTH_INDICATOR_BASE;
        if (this._csParser != null && this._csParser.defines("indicatorBase")) {
            Rectangle2D bounds = this._csParser.getBounds("indicatorBase");
            if (scale == null || move == null) {
                if (this._scaleTransform != null && this._moveTransform != null) {
                    scale = this._scaleTransform;
                    move = this._moveTransform;
                } else {
                    Rectangle baseBounds = new Rectangle((int)(this._anchorPoint.getX() - baseWidth / 2.0), (int)(this._anchorPoint.getY() - baseWidth / 2.0), (int)baseWidth, (int)baseWidth);
                    scale = DialGauge.getScalingTransform(bounds, baseBounds);
                    move = DialGauge.getTranslateTransform(bounds, baseBounds, scale);
                }
            }
            Color userFillColor = (Color)map.get("IndicatorBaseFillColor");
            Color userBorderColor = (Color)map.get("IndicatorBaseBorderColor");
            HashMap<String, Object> userSFXMap = (HashMap<String, Object>)map.get("IndicatorBaseSFX");
            List<CustomShape> shapesList = this._csParser.getShapes("indicatorBase");
            for (int i = 0; i < shapesList.size(); ++i) {
                HashMap<String, Object> csSFXMap;
                CustomShape cs = shapesList.get(i);
                Shape s = cs.getShape();
                s = scale.createTransformedShape(s);
                s = move.createTransformedShape(s);
                Color csFillColor = userFillColor != null ? userFillColor : cs.getFillColor();
                Color csBorderColor = userBorderColor != null ? userBorderColor : cs.getBorderColor();
                HashMap<String, Object> hashMap = csSFXMap = userSFXMap != null ? userSFXMap : cs.getSFXMap();
                if (visualEffects != 0) {
                    if (csSFXMap == null) {
                        csSFXMap = GaugeDefaultValues.getIndicatorBaseVisualEffects();
                    } else {
                        csSFXMap.putAll(GaugeDefaultValues.getIndicatorBaseVisualEffects());
                    }
                }
                objects.add(new DrawableObject.Shape(30, s, cs.getBorderColor(), csFillColor, csSFXMap, null));
            }
        } else {
            HashMap baseSFXmap;
            Color baseBorderColor;
            Color baseFillColor = (Color)map.get("IndicatorBaseFillColor");
            if (baseFillColor == null) {
                baseFillColor = GaugeDefaultValues.getIndicatorBaseFillColor();
            }
            if ((baseBorderColor = (Color)map.get("IndicatorBaseBorderColor")) == null) {
                baseBorderColor = GaugeDefaultValues.getIndicatorBaseBorderColor();
            }
            if ((baseSFXmap = (HashMap)map.get("IndicatorBaseSFX")) == null) {
                baseSFXmap = GaugeDefaultValues.getIndicatorBaseSFX();
            }
            if (visualEffects != 0) {
                baseSFXmap.putAll(GaugeDefaultValues.getIndicatorBaseVisualEffects());
            }
            Arc2D.Double lineBase = new Arc2D.Double(this._anchorPoint.getX() - baseWidth / 2.0, this._anchorPoint.getY() - baseWidth / 2.0, baseWidth, baseWidth, 0.0, 360.0, 0);
            this._indicatorBaseBounds = lineBase.getBounds();
            if (this._csParser == null || !this._csParser.defines("indicatorBase")) {
                objects.add(new DrawableObject.Shape(30, lineBase, baseBorderColor, baseFillColor, baseSFXmap, null));
            }
        }
        return objects;
    }

    protected Collection _getThresholdObjects(Map map) {
        ArrayList<DrawableObject.Shape> objects = new ArrayList<DrawableObject.Shape>(15);
        double[] tValues = (double[])map.get("ThresholdValues");
        ArrayList tList = (ArrayList)map.get("THRESHOLD_ATTRIBUTES");
        double min = this._engine.getMin();
        double max = this._engine.getMax();
        double end = 0.0;
        boolean bBlended = false;
        double prevAngle = this._angleStart + this._angleExtent;
        Integer styleObj = (Integer)map.get("ThresholdDialStyle");
        int style = styleObj != null ? styleObj : GaugeDefaultValues.getThresholdDialStyle();
        int barWidth = Math.max((int)(WIDTH_THRESHOLD * 2.0 * (double)this._radius), 5);
        this._thresholdBounds = new Rectangle();
        this._thresholdBounds.x = this._innerBounds.x + barWidth;
        this._thresholdBounds.y = this._innerBounds.y + barWidth;
        this._thresholdBounds.width = 2 * (this._radius - barWidth);
        this._thresholdBounds.height = 2 * (this._radius - barWidth);
        Arc2D.Double innerArc = new Arc2D.Double(this._thresholdBounds.x, this._thresholdBounds.y, this._thresholdBounds.width, this._thresholdBounds.height, this._angleStart, this._angleExtent, 1);
        Color tBorderColor = GaugeDefaultValues.getThresholdBorderColor();
        Area csThreshold = null;
        Point2D anchorPoint = null;
        if (this._csParser != null && this._csParser.defines("thresholdFillArea")) {
            AffineTransform move;
            AffineTransform scale;
            Rectangle2D bounds = this._csParser.getBounds("thresholdFillArea");
            if (this._scaleTransform != null && this._moveTransform != null) {
                scale = this._scaleTransform;
                move = this._moveTransform;
            } else {
                scale = DialGauge.getScalingTransform(bounds, this._innerBounds);
                this._moveTransform = move = DialGauge.getTranslateTransform(bounds, this._innerBounds, scale);
                this._scaleTransform = scale;
            }
            csThreshold = new Area();
            List<CustomShape> shapesList = this._csParser.getShapes("thresholdFillArea");
            for (int j = 0; j < shapesList.size(); ++j) {
                CustomShape cs = shapesList.get(j);
                Shape s = cs.getShape();
                s = scale.createTransformedShape(s);
                s = move.createTransformedShape(s);
                csThreshold.add(new Area(s));
            }
            anchorPoint = this._calcIndicatorAnchorPoint();
        }
        Color prevColor = null;
        for (int i = 0; i <= tValues.length; ++i) {
            double y;
            double x;
            HashMap tMap = null;
            Color tColor = null;
            HashMap<String, Point2D.Double> sfxMap = null;
            if (tList != null && i < tList.size()) {
                tMap = (HashMap)tList.get(i);
                tColor = (Color)DialGauge.getThresholdAttribute(tMap, i, "ThresholdFillColor");
                tBorderColor = (Color)DialGauge.getThresholdAttribute(tMap, i, "ThresholdBorderColor");
                sfxMap = (HashMap<String, Point2D.Double>)DialGauge.getThresholdAttribute(tMap, i, "ThresholdSFX");
            } else {
                Color[] defFillColors = GaugeDefaultValues.getThresholdColors();
                tColor = i < defFillColors.length ? defFillColors[i] : Color.white;
                tBorderColor = GaugeDefaultValues.getThresholdBorderColor();
            }
            if (bBlended) {
                Color nextColor;
                if (tList != null && i + 1 < tList.size()) {
                    tMap = (HashMap)tList.get(i + 1);
                    nextColor = (Color)DialGauge.getThresholdAttribute(tMap, i + 1, "ThresholdFillColor");
                } else {
                    Color[] defFillColors = GaugeDefaultValues.getThresholdColors();
                    nextColor = i + 1 < defFillColors.length ? defFillColors[i + 1] : tColor;
                }
                Color endColor = this._blendColors(tColor, nextColor);
                if (prevColor == null) {
                    prevColor = tColor;
                }
                sfxMap = GaugeDefaultValues.getBlendedThresholdSFX(prevColor, tColor, endColor, 20);
                prevColor = endColor;
            }
            end = i == tValues.length || tValues[i] > max ? max : Math.max(tValues[i], min);
            double angle = (double)this._angleExtent * (end - min) / (max - min);
            angle = (double)(this._angleStart + this._angleExtent) - angle;
            double extent = prevAngle - angle;
            if (csThreshold != null) {
                double diag = Math.sqrt(Math.pow(this._innerBounds.width, 2.0) + Math.pow(this._innerBounds.height, 2.0));
                x = anchorPoint.getX();
                y = anchorPoint.getY();
                Rectangle2D.Double outerRect = new Rectangle2D.Double(x - diag, y - diag, 2.0 * diag, 2.0 * diag);
                Arc2D.Double mask = new Arc2D.Double(outerRect, angle, extent, 2);
                Area segment = new Area(mask);
                segment.intersect(csThreshold);
                objects.add(new DrawableObject.Shape(15, i, map, segment, outerRect.getBounds(), tBorderColor, tColor, sfxMap, null));
            } else {
                int dir;
                Arc2D.Double outerArc = new Arc2D.Double(this._innerBounds.x, this._innerBounds.y, this._innerBounds.width, this._radius * 2, angle, extent, 0);
                GeneralPath path = null;
                if (style != 0) {
                    ((Arc2D)innerArc).setArc(this._thresholdBounds.x, this._thresholdBounds.y, this._thresholdBounds.width, this._thresholdBounds.height, angle, extent, 0);
                    path = new GeneralPath();
                    if (style == 2) {
                        double incr = (double)this._angleExtent / (double)this._engine.getNumberOfSteps();
                        for (double currAngle = (double)this._angleStart; currAngle < (double)(this._angleStart + this._angleExtent); currAngle += incr) {
                            if (!(currAngle >= angle - incr) || !(currAngle <= angle + extent)) continue;
                            double currBegin = Math.max(currAngle + THRESHOLD_SEGMENTS_GAP_DEGREES / 2.0, angle);
                            double currEnd = Math.min(currAngle + incr - THRESHOLD_SEGMENTS_GAP_DEGREES / 2.0, angle + extent);
                            double currExtent = currEnd - currBegin;
                            if (!(currExtent > 0.0)) continue;
                            ((Arc2D)outerArc).setAngleStart(currBegin);
                            ((Arc2D)outerArc).setAngleExtent(currExtent);
                            ((Arc2D)innerArc).setAngleStart(currBegin);
                            ((Arc2D)innerArc).setAngleExtent(currExtent);
                            this.convertShapeToPath(path, outerArc, innerArc);
                        }
                        ((Arc2D)outerArc).setAngleStart(angle);
                        ((Arc2D)outerArc).setAngleExtent(extent);
                        ((Arc2D)innerArc).setAngleStart(angle);
                        ((Arc2D)innerArc).setAngleExtent(extent);
                    } else {
                        this.convertShapeToPath(path, outerArc, innerArc);
                    }
                }
                outerArc.setArcType(2);
                innerArc.setArcType(2);
                if (bBlended && sfxMap != null) {
                    x = (outerArc.getEndPoint().getX() + outerArc.getEndPoint().getX()) / 2.0;
                    y = (outerArc.getEndPoint().getY() + outerArc.getEndPoint().getY()) / 2.0;
                    sfxMap.put("SFX_START_POINT", new Point2D.Double(x, y));
                    x = (outerArc.getStartPoint().getX() + outerArc.getStartPoint().getX()) / 2.0;
                    y = (outerArc.getStartPoint().getY() + outerArc.getStartPoint().getY()) / 2.0;
                    sfxMap.put("SFX_END_POINT", new Point2D.Double(x, y));
                }
                if (!(sfxMap == null || bBlended || (dir = ((Integer)sfxMap.get("SFX_GRADIENT_DIRECTION")).intValue()) != 9 && dir != 14)) {
                    HashMap<String, Point2D.Double> mapCopy = new HashMap<String, Point2D.Double>();
                    mapCopy.put("SFX_STOP_COLORS", (Point2D.Double)sfxMap.get("SFX_STOP_COLORS"));
                    mapCopy.put("SFX_GRADIENT_DIRECTION", (Point2D.Double)sfxMap.get("SFX_GRADIENT_DIRECTION"));
                    mapCopy.put("SFX_GRADIENT_CENTER", (Point2D.Double)this._anchorPoint);
                    if (dir == 9 && style == 1) {
                        ArrayList positions = (ArrayList)sfxMap.get("SFX_STOP_POSITIONS");
                        ArrayList<Double> newPositions = new ArrayList<Double>();
                        for (int k = 0; k < positions.size(); ++k) {
                            Double pos = (Double)positions.get(k);
                            pos = pos * 25.0 / 100.0 + 0.75;
                            newPositions.add(pos);
                        }
                        mapCopy.put("SFX_STOP_POSITIONS", (Point2D.Double)((Object)newPositions));
                    } else {
                        mapCopy.put("SFX_STOP_POSITIONS", (Point2D.Double)sfxMap.get("SFX_STOP_POSITIONS"));
                    }
                    mapCopy.put("SFX_FILL_TYPE", (Point2D.Double)sfxMap.get("SFX_FILL_TYPE"));
                    mapCopy.put("SFX_GRADIENT_REVERSED", (Point2D.Double)sfxMap.get("SFX_GRADIENT_REVERSED"));
                    mapCopy.put("SFX_NUM_STOPS", (Point2D.Double)sfxMap.get("SFX_NUM_STOPS"));
                    sfxMap = mapCopy;
                }
                if (style != 0) {
                    objects.add(new DrawableObject.Shape(15, i, map, path, outerArc.getBounds(), null, tColor, sfxMap, null));
                } else {
                    objects.add(new DrawableObject.Shape(15, i, map, outerArc, tBorderColor, tColor, (HashMap)sfxMap, null));
                }
                if (tBorderColor != null && style != 0) {
                    ((Arc2D)outerArc).setArc(this._innerBounds.x, this._innerBounds.y, this._innerBounds.width, this._radius * 2, angle, extent, 0);
                    objects.add(new DrawableObject.Shape(15, i, map, outerArc, tBorderColor, null, null, null));
                    Arc2D.Double innerBorder = new Arc2D.Double(this._thresholdBounds.x, this._thresholdBounds.y, this._thresholdBounds.width, this._thresholdBounds.height, angle, extent, 0);
                    objects.add(new DrawableObject.Shape(15, i, map, innerBorder, tBorderColor, null, null, null));
                    objects.add(new DrawableObject.Shape(15, i, map, new Line2D.Double(outerArc.getEndPoint().getX(), outerArc.getEndPoint().getY(), innerArc.getEndPoint().getX(), innerArc.getEndPoint().getY()), tBorderColor, null, null, null));
                    if (i == tValues.length) {
                        objects.add(new DrawableObject.Shape(15, i, map, new Line2D.Double(outerArc.getStartPoint().getX(), outerArc.getStartPoint().getY(), innerArc.getStartPoint().getX(), innerArc.getStartPoint().getY()), tBorderColor, null, null, null));
                    }
                }
            }
            prevAngle = angle;
        }
        return objects;
    }

    @Override
    protected Collection getTickLabelObjects(Map map) {
        ArrayList<DrawableObject> objects = new ArrayList<DrawableObject>();
        if (this._tickMarkPositions != null) {
            Integer tickLabelPos;
            Color color;
            Font font = (Font)map.get("TickLabelFont");
            if (font == null) {
                font = GaugeDefaultValues.getTickLabelFont();
            }
            if ((color = (Color)map.get("TickLabelColor")) == null) {
                color = GaugeDefaultValues.getTickLabelFontColor();
            }
            if ((tickLabelPos = (Integer)map.get("TickLabelPosition")) == null) {
                tickLabelPos = GaugeDefaultValues.getTickLabelPosition();
            }
            Graphics2D g = this._engine.getGraphics();
            double cy = this._anchorPoint.getY();
            double cx = this._anchorPoint.getX();
            for (int i = 0; i < this._tickMarkPositions.size(); ++i) {
                double angle;
                Point2D pt = this._tickMarkPositions.get(i);
                double distX = pt.getX() - cx;
                double distY = pt.getY() - cy;
                if (distX == 0.0) {
                    angle = distY > 0.0 ? 90.0 : 270.0;
                } else {
                    angle = Math.toDegrees(Math.atan(Math.abs(distY / distX)));
                    if (distX > 0.0 && distY > 0.0) {
                        angle = 360.0 - angle;
                    } else if (distX < 0.0 && distY < 0.0) {
                        angle = 180.0 - angle;
                    } else if (distX < 0.0 && distY >= 0.0) {
                        angle += 180.0;
                    }
                }
                double val = this._engine.getMax() - (angle - (double)this._angleStart) / (double)this._angleExtent * (this._engine.getMax() - this._engine.getMin());
                String value = this._engine.formatValue(val, "TickLabelViewFormat");
                int offset = Math.max(this._tickMarkRadius - 3, 0);
                this.createTickLabel(objects, g, value, font, color, pt, angle, 4, tickLabelPos, offset);
            }
        } else {
            Integer styleObj = (Integer)map.get("ThresholdDialStyle");
            int tdStyle = styleObj != null ? styleObj : GaugeDefaultValues.getThresholdDialStyle();
            int tickContent = -1;
            tickContent = (Integer)map.get("TickLabelContent") == null ? (map.get("ThresholdValues") == null || tdStyle == 2 ? 7 : 11) : (Integer)map.get("TickLabelContent");
            if ((tickContent & 0x10) != 0) {
                this.createTickLabelObjects(objects, map, 16);
            }
            if ((tickContent & 8) != 0) {
                this.createTickLabelObjects(objects, map, 8);
            }
            if ((tickContent & 3) != 0) {
                this.createTickLabelObjects(objects, map, 3);
            }
            if ((tickContent & 4) != 0) {
                this.createTickLabelObjects(objects, map, 4);
            }
        }
        return objects;
    }

    private Collection createTickLabelObjects(List<DrawableObject> objects, Map map, int tickLabelType) {
        String value;
        Color color;
        Arc2D.Double arc = new Arc2D.Double();
        Integer tickLabelPos = (Integer)map.get("TickLabelPosition");
        if (tickLabelPos == null) {
            tickLabelPos = GaugeDefaultValues.getTickLabelPosition();
        }
        int offset = this._tickMarkRadius;
        if (this._tickMarkArcBounds != null) {
            ((Arc2D)arc).setArc(this._tickMarkArcBounds.x + 1, this._tickMarkArcBounds.y, this._tickMarkArcBounds.width, this._tickMarkArcBounds.height, this._angleStart, this._angleExtent, 1);
        } else if (!(tickLabelPos != 0 || this._thresholdBounds == null || this._csParser != null && this._csParser.defines("thresholdFillArea"))) {
            ((Arc2D)arc).setArc(this._thresholdBounds.x + 1, this._thresholdBounds.y, this._thresholdBounds.width, this._thresholdBounds.height, this._angleStart, this._angleExtent, 1);
            if (offset == 0) {
                offset += 2;
            }
        } else {
            ((Arc2D)arc).setArc(this._innerBounds.x + 1, this._innerBounds.y, this._innerBounds.width, this._radius * 2, this._angleStart, this._angleExtent, 1);
        }
        Font font = (Font)map.get("TickLabelFont");
        if (font == null) {
            font = GaugeDefaultValues.getTickLabelFont();
        }
        if ((color = (Color)map.get("TickLabelColor")) == null) {
            color = GaugeDefaultValues.getTickLabelFontColor();
        }
        Graphics2D g = this._engine.getGraphics();
        if ((tickLabelType & 3) != 0) {
            ((Arc2D)arc).setAngleStart(this._angleStart);
            ((Arc2D)arc).setAngleExtent(this._angleExtent);
            double[] tValues = (double[])map.get("ThresholdValues");
            Integer styleObj = (Integer)map.get("ThresholdDialStyle");
            int style = styleObj != null ? styleObj : GaugeDefaultValues.getThresholdDialStyle();
            int addTmLength = 0;
            if (tickLabelPos == 0 && this._tickMarkRadius == 0 && (tValues == null || style == 0)) {
                addTmLength = this._layout.getGapSize(LENGTH_TICKMARK_MIN_MAX);
            }
            value = this._engine.formatValue(this._engine.getMin(), "TickLabelViewFormat");
            this.createTickLabel(objects, g, value, font, color, arc.getEndPoint(), this._angleExtent + this._angleStart, 3, tickLabelPos, offset + addTmLength);
            value = this._engine.formatValue(this._engine.getMax(), "TickLabelViewFormat");
            this.createTickLabel(objects, g, value, font, color, arc.getStartPoint(), this._angleStart, 3, tickLabelPos, offset + addTmLength);
        }
        if ((tickLabelType & 4) != 0) {
            for (int i = 0; i < this._engine.getNumberOfSteps() - 1; ++i) {
                double incrVal = this._engine.getIncrement() * (double)(i + 1);
                double angle = (double)this._angleExtent * incrVal / (this._engine.getMax() - this._engine.getMin());
                angle = (double)this._angleExtent - angle + (double)this._angleStart;
                ((Arc2D)arc).setAngleStart(0.0);
                ((Arc2D)arc).setAngleExtent(angle);
                value = this._engine.formatValue(incrVal + this._engine.getMin(), "TickLabelViewFormat");
                this.createTickLabel(objects, g, value, font, color, arc.getEndPoint(), angle, 4, tickLabelPos, offset);
            }
        }
        if ((tickLabelType & 8) != 0) {
            double[] array = (double[])map.get("ThresholdValues");
            if (array == null) {
                return objects;
            }
            for (int i = 0; i < array.length; ++i) {
                if (array[i] > this._engine.getMax() || array[i] < this._engine.getMin()) continue;
                double angle = (double)this._angleExtent * (array[i] - this._engine.getMin()) / (this._engine.getMax() - this._engine.getMin());
                angle = (double)this._angleExtent - angle + (double)this._angleStart;
                ((Arc2D)arc).setAngleStart(0.0);
                ((Arc2D)arc).setAngleExtent(angle);
                value = this._engine.formatValue(array[i], "TickLabelViewFormat");
                this.createTickLabel(objects, g, value, font, color, arc.getEndPoint(), angle, 8, tickLabelPos, offset);
            }
        }
        if ((tickLabelType & 0x10) != 0) {
            if (this._engine.isNullMetric()) {
                return objects;
            }
            for (int i = 0; i < this._engine.getMetricSize(); ++i) {
                Double metric = this._engine.getMetric(i);
                if (metric == null) continue;
                double metricAngle = (double)this._angleExtent * (metric - this._engine.getMin()) / (this._engine.getMax() - this._engine.getMin());
                metricAngle = (double)this._angleExtent - metricAngle;
                ((Arc2D)arc).setAngleStart(this._angleStart);
                ((Arc2D)arc).setAngleExtent(metricAngle);
                value = this._engine.formatValue(metric, "TickLabelViewFormat");
                this.createTickLabel(objects, g, value, font, color, arc.getEndPoint(), (double)this._angleStart + metricAngle, 16, tickLabelPos, offset);
            }
        }
        return objects;
    }

    private void createTickLabel(List<DrawableObject> objects, Graphics2D g, String value, Font font, Color fontColor, Point2D pt, double angle, int labelType, int position, Integer labelOffset) {
        DrawableObject.TickLabel lbl;
        double y2;
        double x2;
        int offset;
        double x = pt.getX();
        double y = pt.getY();
        Dimension dim = DrawableObject.getLabelDimensions(g, font, value);
        if (position == 0) {
            double yCenter;
            double xCenter;
            double angle2;
            offset = 7;
            if (labelOffset != null) {
                offset += labelOffset.intValue();
            }
            if ((angle2 = (angle = (angle + 360.0) % 360.0) % 180.0) > 90.0) {
                angle2 = 180.0 - angle2;
            }
            double angleRadians = Math.toRadians(angle2);
            if (angle == 0.0) {
                xCenter = x - (double)offset - (double)(dim.width / 2);
                yCenter = y;
            } else if (angle == 180.0) {
                xCenter = x + (double)offset + (double)(dim.width / 2);
                yCenter = y;
            } else {
                double C = offset + dim.height / 2;
                double A = C * Math.cos(angleRadians);
                double B = C * Math.sin(angleRadians);
                if (angle > 270.0) {
                    xCenter = x - A;
                    yCenter = y - B;
                } else if (angle > 180.0) {
                    xCenter = x + A;
                    yCenter = y - B;
                } else if (angle > 90.0) {
                    xCenter = x + A;
                    yCenter = y + B;
                } else {
                    xCenter = x - A;
                    yCenter = y + B;
                }
            }
            x2 = xCenter - (double)(dim.width / 2);
            y2 = yCenter - (double)(dim.height / 2);
        } else {
            offset = 4;
            if (labelOffset != null) {
                offset += labelOffset.intValue();
            }
            angle = (angle + 360.0) % 360.0;
            double angleRadians = Math.toRadians(angle);
            double x1 = (double)offset * Math.cos(angleRadians);
            double y1 = (double)offset * Math.sin(angleRadians);
            if (angle == 0.0) {
                x2 = x + x1;
                y2 = y - y1 - (double)dim.height / 1.75;
            } else if (angle == 180.0) {
                x2 = x + x1 - (double)dim.width;
                y2 = y - y1 - (double)dim.height / 1.75;
            } else if (angle == 90.0) {
                x2 = x + x1 - (double)(dim.width / 2);
                y2 = y - y1 - (double)dim.height;
            } else if (angle == 270.0) {
                x2 = x + x1 - (double)(dim.width / 2);
                y2 = y - y1;
            } else if (angle < 90.0) {
                x2 = x + x1;
                y2 = y - y1 - (double)dim.height;
            } else if (angle < 180.0) {
                x2 = x + x1 - (double)dim.width;
                y2 = y - y1 - (double)dim.height;
            } else if (angle < 270.0) {
                x2 = x + x1 - (double)dim.width;
                y2 = y - y1;
            } else {
                x2 = x + x1;
                y2 = y - y1;
            }
        }
        Rectangle rect = new Rectangle((int)x2, (int)y2, dim.width, dim.height);
        if (!(this._indicatorBaseBounds != null && rect.intersects(this._indicatorBaseBounds) || (lbl = DrawableObject.getTickLabelObject(g, value, font, fontColor, rect, labelType)) == null)) {
            objects.add(lbl);
        }
    }

    @Override
    protected Collection getTickMarkObjects(Map map) {
        Rectangle2D bounds;
        ArrayList<DrawableObject> objects = new ArrayList<DrawableObject>();
        double[] tValues = (double[])map.get("ThresholdValues");
        Integer styleObj = (Integer)map.get("ThresholdDialStyle");
        int style = styleObj != null ? styleObj : GaugeDefaultValues.getThresholdDialStyle();
        this._tickMarkArcBounds = null;
        if (!(tValues == null || this._csParser != null && this._csParser.defines("thresholdFillArea"))) {
            if (style == 2) {
                return objects;
            }
            Integer tickLabelPos = (Integer)map.get("TickLabelPosition");
            if (tickLabelPos == null) {
                tickLabelPos = GaugeDefaultValues.getTickLabelPosition();
            }
            if (style == 1 && tickLabelPos == 0) {
                this._tickMarkArcBounds = new Rectangle(this._thresholdBounds.x, this._thresholdBounds.y, this._thresholdBounds.width, this._thresholdBounds.height);
            }
        }
        if (this._tickMarkArcBounds == null) {
            this._tickMarkArcBounds = new Rectangle(this._innerBounds.x, this._innerBounds.y, this._innerBounds.width, this._radius * 2);
        }
        if (this._csParser != null && this._csParser.defines("tickMarkPath")) {
            bounds = this._csParser.getBounds("tickMarkPath");
            if (this._scaleTransform != null && this._moveTransform != null) {
                Shape s = bounds;
                s = this._scaleTransform.createTransformedShape(s);
                s = this._moveTransform.createTransformedShape(s);
                this._tickMarkArcBounds = s.getBounds();
            }
            this.createTickMarkObjects(objects, map, this._tickMarkArcBounds);
        } else if (this._csParser != null && this._csParser.defines("tickMark")) {
            AffineTransform move;
            AffineTransform scale;
            bounds = this._csParser.getBounds("tickMark");
            if (this._scaleTransform != null && this._moveTransform != null) {
                scale = this._scaleTransform;
                move = this._moveTransform;
            } else {
                scale = DialGauge.getScalingTransform(bounds, this._innerBounds);
                this._moveTransform = move = DialGauge.getTranslateTransform(bounds, this._innerBounds, scale);
                this._scaleTransform = scale;
            }
            Color userColor = (Color)map.get("MajorTickColor");
            List<CustomShape> shapesList = this._csParser.getShapes("tickMark");
            this._tickMarkPositions = new ArrayList();
            this._tickMarkRadius = 0;
            for (int i = 0; i < shapesList.size(); ++i) {
                CustomShape cs = shapesList.get(i);
                Shape s = cs.getShape();
                s = scale.createTransformedShape(s);
                s = move.createTransformedShape(s);
                Rectangle2D sBounds = s.getBounds2D();
                double cx = sBounds.getCenterX();
                double cy = sBounds.getCenterY();
                double w = sBounds.getWidth();
                double h = sBounds.getHeight();
                Point2D.Double center = new Point2D.Double(cx, cy);
                int tmRadius = (int)Math.sqrt(w * w + h * h) / 2;
                if (tmRadius > this._tickMarkRadius) {
                    this._tickMarkRadius = tmRadius;
                }
                this._tickMarkPositions.add(center);
                Color csColor = userColor != null ? userColor : cs.getFillColor();
                objects.add(new DrawableObject.Shape(13, s, cs.getBorderColor(), csColor, cs.getSFXMap(), null));
            }
        } else {
            this.createTickMarkObjects(objects, map, this._tickMarkArcBounds);
        }
        return objects;
    }

    private void createTickMarkObjects(List<DrawableObject> objects, Map map, Rectangle tmArcBounds) {
        double[] array;
        Integer tickLabelPos;
        int tickMarkType = -1;
        tickMarkType = (Integer)map.get("TickMarkContent") == null ? (map.get("ThresholdValues") == null ? 7 : 11) : (Integer)map.get("TickMarkContent");
        int tmLength = GaugeDefaultValues.getMajorTickMarkLength();
        Color tmColor = (Color)map.get("MajorTickColor");
        if (tmColor == null) {
            tmColor = GaugeDefaultValues.getMajorTickMarkColor();
        }
        int minorTickLength = GaugeDefaultValues.getMinorTickMarkLength();
        Color minorTickColor = (Color)map.get("MinorTickColor");
        if (minorTickColor == null) {
            minorTickColor = GaugeDefaultValues.getMinorTickMarkColor();
        }
        if ((tickLabelPos = (Integer)map.get("TickLabelPosition")) == null) {
            tickLabelPos = GaugeDefaultValues.getTickLabelPosition();
        }
        Arc2D.Double arc = new Arc2D.Double();
        arc.setFrame(tmArcBounds.x, tmArcBounds.y, tmArcBounds.width, tmArcBounds.height);
        ((Arc2D)arc).setAngleExtent(10.0);
        if ((tickMarkType & 3) != 0) {
            int addTmLength = 0;
            if (tickLabelPos == 0) {
                addTmLength = this._layout.getGapSize(LENGTH_TICKMARK_MIN_MAX);
            }
            ((Arc2D)arc).setAngleStart(this._angleStart);
            this.createTickMark(objects, map, arc.getStartPoint(), this._angleStart, tmLength + addTmLength, tmColor, tickLabelPos);
            ((Arc2D)arc).setAngleStart(this._angleStart + this._angleExtent);
            this.createTickMark(objects, map, arc.getStartPoint(), this._angleStart + this._angleExtent, tmLength + addTmLength, tmColor, tickLabelPos);
        }
        if ((tickMarkType & 4) != 0) {
            int i;
            for (i = 0; i < this._engine.getNumberOfSteps() - 1; ++i) {
                double angle = (double)this._angleExtent * (this._engine.getIncrement() * (double)(i + 1)) / (this._engine.getMax() - this._engine.getMin());
                angle = (double)(this._angleStart + this._angleExtent) - angle;
                ((Arc2D)arc).setAngleStart(angle);
                this.createTickMark(objects, map, arc.getStartPoint(), angle, tmLength, tmColor, tickLabelPos);
            }
            for (i = 0; i < this._engine.getNumberOfSteps(); ++i) {
                for (int j = 1; j <= this._engine.getMinorNumberOfSteps(); ++j) {
                    double val = (double)i * this._engine.getIncrement() + (double)j * this._engine.getMinorIncrement();
                    if (val > this._engine.getMax() - this._engine.getMin()) continue;
                    double angle = (double)this._angleExtent * val / (this._engine.getMax() - this._engine.getMin());
                    angle = (double)(this._angleStart + this._angleExtent) - angle;
                    ((Arc2D)arc).setAngleStart(angle);
                    this.createMinorTickMark(objects, map, arc.getStartPoint(), angle, minorTickLength, minorTickColor, tickLabelPos);
                }
            }
        }
        if ((tickMarkType & 8) != 0 && (array = (double[])map.get("ThresholdValues")) != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] > this._engine.getMax() || array[i] < this._engine.getMin()) continue;
                double angle = (double)this._angleExtent * (array[i] - this._engine.getMin()) / (this._engine.getMax() - this._engine.getMin());
                angle = (double)(this._angleStart + this._angleExtent) - angle;
                ((Arc2D)arc).setAngleStart(angle);
                this.createTickMark(objects, map, arc.getStartPoint(), angle, tmLength, tmColor, tickLabelPos);
            }
        }
        if ((tickMarkType & 0x10) != 0) {
            for (int i = 0; i < this._engine.getMetricSize(); ++i) {
                Double metric = this._engine.getMetric(i);
                if (metric == null) continue;
                double metricAngle = (double)this._angleExtent * (metric - this._engine.getMin()) / (this._engine.getMax() - this._engine.getMin());
                metricAngle = (double)(this._angleStart + this._angleExtent) - metricAngle;
                ((Arc2D)arc).setAngleStart(metricAngle);
                this.createTickMark(objects, map, arc.getStartPoint(), metricAngle, tmLength, tmColor, tickLabelPos);
            }
        }
    }

    private void createTickMark(List<DrawableObject> objects, Map map, Point2D pt, double angle, int length, Color color, int position) {
        this.createTickMark(objects, map, pt, angle, length, color, position, "tickMark");
    }

    private void createMinorTickMark(List<DrawableObject> objects, Map map, Point2D pt, double angle, int length, Color color, int position) {
        this.createTickMark(objects, map, pt, angle, length, color, position, "minorTickMark");
    }

    private void createTickMark(List<DrawableObject> objects, Map map, Point2D pt, double angle, int length, Color color, int position, String customShapesType) {
        if (this._csParser != null && this._csParser.defines(customShapesType) && this._scaleTransform != null && this._moveTransform != null && this._tickMarkArcBounds != null) {
            Rectangle2D bounds = this._csParser.getBounds(customShapesType);
            bounds = this._scaleTransform.createTransformedShape(bounds).getBounds2D();
            bounds = this._moveTransform.createTransformedShape(bounds).getBounds2D();
            AffineTransform rotate = new AffineTransform();
            rotate.rotate(Math.toRadians(90.0 - angle), bounds.getCenterX(), bounds.getCenterY());
            AffineTransform move = new AffineTransform();
            move.translate(pt.getX() - this._tickMarkArcBounds.getCenterX(), pt.getY() - this._tickMarkArcBounds.getY());
            double w = bounds.getWidth();
            double h = bounds.getHeight();
            this._tickMarkRadius = (int)Math.sqrt(w * w + h * h) / 2;
            Color userColor = customShapesType == "minorTickMark" ? (Color)map.get("MinorTickColor") : (Color)map.get("MajorTickColor");
            List<CustomShape> shapesList = this._csParser.getShapes(customShapesType);
            for (int i = 0; i < shapesList.size(); ++i) {
                CustomShape cs = shapesList.get(i);
                Shape s = cs.getShape();
                s = this._scaleTransform.createTransformedShape(s);
                s = this._moveTransform.createTransformedShape(s);
                s = rotate.createTransformedShape(s);
                s = move.createTransformedShape(s);
                Color csColor = userColor != null ? userColor : cs.getFillColor();
                objects.add(new DrawableObject.Shape(13, s, cs.getBorderColor(), csColor, cs.getSFXMap(), null));
            }
        } else {
            objects.add(GaugeType.createTickMark(pt, angle, length, color, position));
        }
    }

    @Override
    protected DrawableObject getNoDataLabelObject(Map map) {
        String noDataLabel = this._engine.getIntlStringFromUtilBundle("af_dvt_util.NO_DATA");
        Font font = (Font)map.get("TickLabelFont");
        if (font == null) {
            font = GaugeDefaultValues.getNoDataLabelFont();
        }
        Dimension dim = DrawableObject.getLabelDimensions(this._engine.getGraphics(), font, noDataLabel);
        int plotAreaWidth = this._innerBounds.width - this._layout.getGapWidth(5) * 2;
        if (map.get("ThresholdValues") != null) {
            plotAreaWidth -= Math.max((int)(WIDTH_THRESHOLD * (double)this._innerBounds.width) * 2, 10);
        }
        if (dim.width > plotAreaWidth) {
            return null;
        }
        Rectangle bounds = new Rectangle();
        bounds.x = this._innerBounds.x + this._innerBounds.width / 2 - dim.width / 2;
        bounds.y = this._innerBounds.y + this._innerBounds.height - this._layout.getGapHeight(3) - dim.height;
        bounds.width = dim.width;
        bounds.height = dim.height;
        return DrawableObject.getLabelObject(this._engine.getGraphics(), noDataLabel, font, GaugeDefaultValues.getNoDataLabelFontColor(), bounds, "NoDataLabel");
    }

    @Override
    protected int getGaugeRadius(int availWidth, int availHeight) {
        return Math.min(availWidth / 2, availHeight);
    }

    @Override
    protected Rectangle getInnerBounds(Map map, Rectangle rect, int reqAboveSpace, int reqBelowSpace, int reqLeftSpace, int reqRightSpace) {
        int gaugeHeight;
        Arc2D.Double arc;
        int availHeight = rect.height - reqAboveSpace - reqBelowSpace;
        int availWidth = rect.width - reqLeftSpace - reqRightSpace;
        int radius = this.getGaugeRadius(availHeight, availWidth);
        Rectangle bounds = new Rectangle();
        bounds.x = rect.x + reqLeftSpace;
        bounds.y = rect.y + reqAboveSpace;
        bounds.width = availWidth;
        bounds.height = availHeight;
        int gaugeWidth = radius * 2;
        if (this._isFitFrameToDial(this._angleExtent) && DialGauge._hasGaugeFrame(map)) {
            arc = new Arc2D.Double(0.0, 0.0, radius * 2, radius * 2, SMALL_FRAME_ANGLE_START, SMALL_FRAME_ANGLE_EXTENT, 1);
            gaugeHeight = arc.getBounds2D().getBounds().height;
        } else if (!DialGauge._hasGaugeFrame(map)) {
            arc = new Arc2D.Double(0.0, 0.0, radius * 2, radius * 2, this._angleStart, this._angleExtent, 1);
            gaugeHeight = arc.getBounds2D().getBounds().height;
        } else {
            gaugeHeight = radius * 2;
        }
        Shape plotArea = new Rectangle(0, 0, gaugeWidth, gaugeHeight);
        AffineTransform scale = DialGauge.getScalingTransform(plotArea, bounds);
        AffineTransform move = DialGauge.getTranslateTransform(plotArea, bounds, scale);
        plotArea = scale.createTransformedShape(plotArea);
        plotArea = move.createTransformedShape(plotArea);
        bounds = plotArea.getBounds();
        if (bounds.width < 10 || bounds.height < 5) {
            this._engine.getErrorHandler().log("Width allocated for gauge is too small.", this.getClass().getName(), "getInnerBounds");
            bounds.width = 10;
            bounds.x = rect.x + (rect.width - bounds.width) / 2;
            bounds.height = 5;
            bounds.y = rect.y + (rect.height - bounds.height) / 2;
        }
        this._radius = bounds.width / 2;
        return bounds;
    }

    @Override
    protected Rectangle _getPlotAreaBounds(Rectangle gaugeFrameBounds, Map map, Graphics2D g) {
        int reqAboveSpace = 0;
        int reqBelowSpace = 0;
        int reqLeftSpace = 0;
        int reqRightSpace = 0;
        boolean bGaugeFrame = DialGauge._hasGaugeFrame(map);
        if (bGaugeFrame) {
            reqBelowSpace = reqAboveSpace = this.getSpaceAroundGauge(map, g);
            reqLeftSpace = reqAboveSpace;
            reqRightSpace = reqAboveSpace;
        } else {
            reqLeftSpace += this._layout.getGapWidth(5);
            reqRightSpace += this._layout.getGapWidth(5);
            int tickLabelPos = GaugeDefaultValues.getTickLabelPosition();
            if (map.get("TickLabelPosition") != null) {
                tickLabelPos = (Integer)map.get("TickLabelPosition");
            }
            if (map.get("TickLabelContent") == null || (Integer)map.get("TickLabelContent") != 0) {
                Font font = (Font)map.get("TickLabelFont");
                if (font == null) {
                    font = GaugeDefaultValues.getTickLabelFont();
                }
                Dimension dim = DrawableObject.getLabelDimensions(g, font, GaugeType.DEF_TICK_LABEL);
                if (tickLabelPos == 1) {
                    reqAboveSpace += dim.height;
                    reqLeftSpace += this.getTickLabelWidth(map, g, "maxValue");
                    reqRightSpace += this.getTickLabelWidth(map, g, "maxValue");
                    if (this._angleExtent > 180) {
                        reqBelowSpace += dim.height;
                    } else if (this._angleExtent >= 170) {
                        reqBelowSpace += dim.height / 2;
                    }
                } else if (this._angleExtent >= 170 && this._angleExtent <= 190) {
                    reqBelowSpace += dim.height / 2;
                }
            }
            if (this._angleExtent >= 170 && this._angleExtent <= 190) {
                int indHeight = (int)((double)(this._gaugeFrameBounds.width / 2 * 2) * WIDTH_INDICATOR_BASE);
                reqBelowSpace = Math.max(reqBelowSpace, indHeight / 2 + this._layout.getGapHeight(3));
            }
        }
        Rectangle bounds = this.getInnerBounds(map, gaugeFrameBounds, reqAboveSpace, reqBelowSpace, reqLeftSpace, reqRightSpace);
        if (this._csParser == null || !this._csParser.defines("gaugeFrame")) {
            this._gaugeFrameBounds = new Rectangle(bounds.x - reqLeftSpace, bounds.y - reqAboveSpace, bounds.width + reqLeftSpace + reqRightSpace, bounds.height + reqAboveSpace + reqBelowSpace);
        }
        return bounds;
    }

    @Override
    protected int getMaxNumberOfSteps() {
        return (int)Math.round(0.04 * (double)this._innerBounds.width);
    }

    @Override
    protected Collection getGaugeFrameObject(Map map) {
        Integer gradientDir;
        Integer fillType;
        ArrayList<DrawableObject.Shape> objects = new ArrayList<DrawableObject.Shape>();
        Color borderClr = GaugeDefaultValues.getGaugeFrameBorderColor();
        if (map.get("GaugeFrameBorderColor") != null) {
            borderClr = (Color)map.get("GaugeFrameBorderColor");
        }
        HashMap<String, Point2D> sfxMap = GaugeDefaultValues.getGaugeFrameSFX();
        Color fillColor = GaugeDefaultValues.getGaugeFrameFillColor();
        if (map.get("GaugeFrameFillColor") != null) {
            fillColor = (Color)map.get("GaugeFrameFillColor");
            sfxMap = null;
        }
        if (map.get("GaugeFrameSFX") != null) {
            sfxMap = (HashMap)map.get("GaugeFrameSFX");
        }
        if (sfxMap == null) {
            sfxMap = new HashMap<String, Point2D>();
        }
        int visualEffects = GaugeDefaultValues.getVisualEffects();
        if (map.get("VisualEffects") != null) {
            visualEffects = (Integer)map.get("VisualEffects");
        }
        if (visualEffects != 0) {
            sfxMap.putAll(GaugeDefaultValues.getDialGaugeFrameVisualEffects(this._radius));
        }
        if (sfxMap != null && (fillType = (Integer)sfxMap.get("SFX_FILL_TYPE")) != null && fillType == 2 && (gradientDir = (Integer)sfxMap.get("SFX_GRADIENT_DIRECTION")) != null) {
            double dist = (double)(this._innerBounds.width / 2) * 0.4 / Math.sqrt(2.0);
            if (this._anchorPoint == null) {
                this._anchorPoint = this._calcIndicatorAnchorPoint();
            }
            if (gradientDir == 14) {
                Point2D.Double gradientCtr = new Point2D.Double(this._anchorPoint.getX() - dist, this._anchorPoint.getY() - dist);
                sfxMap.put("SFX_GRADIENT_CENTER", gradientCtr);
            } else if (gradientDir == 9) {
                sfxMap.put("SFX_GRADIENT_CENTER", this._anchorPoint);
            }
        }
        Rectangle frameRect = this._gaugeFrameBounds;
        if (this._csParser != null && this._csParser.defines("gaugeFrame")) {
            if (this._scaleTransform == null || this._moveTransform == null) {
                return objects;
            }
            AffineTransform scale = this._scaleTransform;
            AffineTransform move = this._moveTransform;
            Color userBorderColor = (Color)map.get("GaugeFrameBorderColor");
            Color userFillColor = (Color)map.get("GaugeFrameFillColor");
            HashMap userSFXMap = (HashMap)map.get("GaugeFrameSFX");
            List<CustomShape> shapesList = this._csParser.getShapes("gaugeFrame");
            for (int i = 0; i < shapesList.size(); ++i) {
                CustomShape cs = shapesList.get(i);
                Shape s = cs.getShape();
                s = scale.createTransformedShape(s);
                s = move.createTransformedShape(s);
                Color csBorderColor = userBorderColor != null ? userBorderColor : cs.getBorderColor();
                Color csFillColor = userFillColor != null ? userFillColor : cs.getFillColor();
                HashMap csSFXMap = userSFXMap != null ? userSFXMap : cs.getSFXMap();
                objects.add(new DrawableObject.Shape(24, s, csBorderColor, csFillColor, csSFXMap, null));
            }
        } else if (this._isFitFrameToDial(this._angleExtent)) {
            double angleStart = SMALL_FRAME_ANGLE_START;
            double angleExtent = SMALL_FRAME_ANGLE_EXTENT;
            Arc2D.Double plotArc = new Arc2D.Double(this._innerBounds.x, this._innerBounds.y, this._radius * 2, this._radius * 2, angleStart, angleExtent, 1);
            Rectangle2D plotAreaBounds = plotArc.getBounds2D();
            int spaceAround = this.getSpaceAroundGauge(map, this._engine.getGraphics());
            int x = (int)plotAreaBounds.getX() - spaceAround;
            int y = (int)plotAreaBounds.getY() - spaceAround;
            int w = (int)plotAreaBounds.getWidth() + 2 * spaceAround;
            int h = (int)plotAreaBounds.getHeight() + 2 * spaceAround;
            Rectangle frameBounds = new Rectangle(x, y, w, h);
            double frameRadius = 2 * (this._radius + spaceAround);
            Arc2D.Double gaugeFrameArc = new Arc2D.Double(x, y, frameRadius, frameRadius, 0.0, 360.0, 1);
            Area gaugeFrame = new Area(gaugeFrameArc);
            gaugeFrame.intersect(new Area(frameBounds));
            Arc2D.Double smallArc = new Arc2D.Double(x, y, frameRadius, frameRadius, angleStart + angleExtent, 360.0 - angleExtent, 1);
            Rectangle smallArcBounds = smallArc.getBounds2D().getBounds();
            if (this._lowerLabelFrameBounds != null) {
                this._lowerLabelFrameBounds.x = smallArcBounds.x;
                this._lowerLabelFrameBounds.width = smallArcBounds.width;
            }
            objects.add(new DrawableObject.Shape(24, gaugeFrame, borderClr, fillColor, sfxMap, null));
        } else {
            Arc2D.Double frame = new Arc2D.Double(frameRect, 0.0, 360.0, 0);
            objects.add(new DrawableObject.Shape(24, frame, borderClr, fillColor, sfxMap, null));
        }
        return objects;
    }

    @Override
    protected Collection getGaugeLinkObject(Map map, Rectangle outerBounds) {
        ArrayList<DrawableObject.Shape> objects = new ArrayList<DrawableObject.Shape>();
        Rectangle baseRect = this._gaugeFrameBounds;
        int startAngle = 345;
        int endAngle = 195 + (360 - startAngle);
        --baseRect.x;
        --baseRect.y;
        Area tempArea = this._getOutlineArea(baseRect, startAngle, endAngle, map);
        Color color = new Color(1.0f, 1.0f, 1.0f, 0.01f);
        objects.add(new DrawableObject.Shape(11, map, (Shape)tempArea, null, color, null, null));
        return objects;
    }

    private Area _getOutlineArea(Rectangle baseRect, int startAngle, int endAngle, Map map) {
        Arc2D.Double backArc = new Arc2D.Double();
        ((Arc2D)backArc).setArc(baseRect.x, baseRect.y, baseRect.width, baseRect.height * 2, startAngle, endAngle, 1);
        RoundRectangle2D.Double hdnRect = new RoundRectangle2D.Double();
        ((RoundRectangle2D)hdnRect).setRoundRect(baseRect.x, baseRect.y, baseRect.width, baseRect.height, 2 * this._layout.getGapHeight(3), 2 * this._layout.getGapHeight(3));
        Area outlineArea = new Area(backArc);
        Area hdnArea = new Area(hdnRect);
        outlineArea.intersect(hdnArea);
        return outlineArea;
    }

    protected int getSpaceAroundGauge(Map map, Graphics2D g) {
        int tickLabelPos = GaugeDefaultValues.getTickLabelPosition();
        if (map.get("TickLabelPosition") != null) {
            tickLabelPos = (Integer)map.get("TickLabelPosition");
        }
        int tickContent = 7;
        if ((Integer)map.get("TickLabelContent") != null) {
            tickContent = (Integer)map.get("TickLabelContent");
        }
        if (tickContent == 0) {
            return this._layout.getGapWidth(5) + this._layout.getGapHeight(3);
        }
        if (tickLabelPos == 1) {
            return this.getTickLabelWidth(map, g, "maxValue") + this._layout.getGapWidth(5) + this._layout.getGapHeight(3);
        }
        double frameSize = Math.min(this._gaugeFrameBounds.width, this._gaugeFrameBounds.height);
        return Math.max((int)(0.04 * frameSize), this._layout.getGapHeight(5));
    }

    @Override
    protected int _getPlotAreaCenter(Map map) {
        if (this._innerBounds != null) {
            return this._innerBounds.y + this._radius / 2;
        }
        return -1;
    }

    private Point2D _calcIndicatorAnchorPoint() {
        if (this._innerBounds == null) {
            return null;
        }
        double x1 = this._innerBounds.x + this._innerBounds.width / 2;
        double y1 = this._innerBounds.y + this._radius;
        if (this._csParser != null && this._scaleTransform != null && this._moveTransform != null && (this._csParser.defines("indicatorCenter") || this._csParser.defines("indicatorBase"))) {
            Shape center = this._csParser.getBounds("indicatorCenter");
            if (center == null) {
                center = this._csParser.getBounds("indicatorBase");
            }
            center = this._scaleTransform.createTransformedShape(center);
            center = this._moveTransform.createTransformedShape(center);
            Rectangle2D centerBounds = center.getBounds2D();
            x1 = centerBounds.getCenterX();
            y1 = centerBounds.getCenterY();
        }
        return new Point2D.Double(x1, y1);
    }

    protected int getAngleExtent() {
        return this._angleExtent;
    }

    private boolean _isFitFrameToDial(double angle) {
        return angle <= SMALL_FRAME_ANGLE_EXTENT;
    }

    protected GeneralPath convertShapeToPath(GeneralPath path, Arc2D shape, Arc2D shape2) {
        int type;
        double[] coords;
        PathIterator pi;
        double x = 0.0;
        double y = 0.0;
        if (shape != null && (pi = shape.getPathIterator(null)) != null) {
            while (!pi.isDone()) {
                coords = new double[6];
                type = pi.currentSegment(coords);
                switch (type) {
                    case 0: {
                        path.moveTo((float)coords[0], (float)coords[1]);
                        x = coords[0];
                        y = coords[1];
                        break;
                    }
                    case 3: {
                        path.curveTo((float)coords[0], (float)coords[1], (float)coords[2], (float)coords[3], (float)coords[4], (float)coords[5]);
                        break;
                    }
                }
                pi.next();
            }
        }
        if ((pi = ReversePathIterator.getReversePathIterator(shape2)) != null) {
            while (!pi.isDone()) {
                coords = new double[6];
                type = pi.currentSegment(coords);
                switch (type) {
                    case 0: {
                        path.lineTo((float)coords[0], (float)coords[1]);
                        break;
                    }
                    case 3: {
                        path.curveTo((float)coords[0], (float)coords[1], (float)coords[2], (float)coords[3], (float)coords[4], (float)coords[5]);
                        break;
                    }
                }
                pi.next();
            }
        }
        path.lineTo((float)x, (float)y);
        return path;
    }
}

