/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.managers;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.Manager;
import oracle.dss.dataView.UIBundle;
import oracle.dss.rules.ComponentTypeConverter;
import oracle.dss.rules.RuleBundle;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;

public abstract class RuleManager
implements Manager,
UIBundle,
Serializable {
    private static final long serialVersionUID = 1L;
    protected DataviewCommon m_dataview = null;
    protected Vector m_bundles = null;
    protected RuleBundle m_uiBundle = null;
    protected Hashtable m_context = null;
    protected static final String UIBUNDLE_NAME = "UIBundle";

    public void setBundles(DataviewCommon view, Vector bundles) {
        if (bundles != null) {
            bundles = (Vector)bundles.clone();
        }
        this.m_bundles = bundles;
        this.m_dataview = view;
        if (view != null) {
            view.repaint();
        }
    }

    public Vector getBundles() {
        if (this.m_bundles != null) {
            return (Vector)this.m_bundles.clone();
        }
        return null;
    }

    @Override
    public void dataSourceChanged() {
    }

    public void setContext(Hashtable context) {
        this.m_context = context;
        if (this.m_bundles != null) {
            for (int i = 0; i < this.m_bundles.size(); ++i) {
                ((RuleBundle)this.m_bundles.elementAt(i)).setContext(this.m_context);
            }
        }
    }

    public void setXML(ContainerNode node, DataviewCommon dataview, String version, int reset) {
        ContainerNode uiBundleNode;
        Enumeration e = node.getContainerNodes("Bundle");
        while (e.hasMoreElements()) {
            ContainerNode bundleNode = (ContainerNode)e.nextElement();
            if (bundleNode == null) continue;
            RuleBundle bundle = new RuleBundle();
            if (this.m_context != null) {
                bundle.setContext(this.m_context);
            }
            bundle.setXML(bundleNode, (ComponentTypeConverter)dataview, version, reset);
            if (this.m_bundles == null) {
                this.m_bundles = new Vector();
            }
            this.m_bundles.addElement(bundle);
        }
        Enumeration e2 = node.getContainerNodes(UIBUNDLE_NAME);
        if (e2 != null && e2.hasMoreElements() && (uiBundleNode = (ContainerNode)e2.nextElement()) != null) {
            RuleBundle bundle = new RuleBundle();
            if (this.m_context != null) {
                bundle.setContext(this.m_context);
            }
            bundle.setXML(uiBundleNode, (ComponentTypeConverter)dataview, version, reset);
            this.setUIBundle(dataview, bundle);
        }
    }

    public ObjectNode getXML(boolean allProperties, String name, DataviewCommon dataview) {
        ObjectNode uiBundleNode;
        ObjectNode node = new ObjectNode(name);
        boolean nodeExists = false;
        if (this.m_bundles != null) {
            for (int i = 0; i < this.m_bundles.size(); ++i) {
                ObjectNode XML;
                RuleBundle ruleBundle = (RuleBundle)this.m_bundles.elementAt(i);
                if (this.m_context != null) {
                    ruleBundle.setContext(this.m_context);
                }
                if ((XML = ruleBundle.getXML(allProperties, (ComponentTypeConverter)dataview)) == null) continue;
                node.addProperty(XML);
                nodeExists = true;
            }
        }
        if (this.m_uiBundle != null && (uiBundleNode = this.m_uiBundle.getXML(allProperties, (ComponentTypeConverter)dataview, UIBUNDLE_NAME)) != null) {
            node.addProperty(uiBundleNode);
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    @Override
    public RuleBundle getUIBundle() {
        return this.m_uiBundle;
    }

    @Override
    public void setUIBundle(DataviewCommon view, RuleBundle bundle) {
        this.m_uiBundle = bundle;
        this.m_dataview = view;
        if (view != null) {
            view.repaint();
        }
    }
}

