/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.util.BooleanUtils;
import oracle.bali.share.util.IntegerUtils;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.preference.Preference;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.util.ArrayResourceBundle;

public final class TogglePreferenceActionFactory {
    private static final String _PREF_KEY = "PreferenceForAction";
    private static final String _MODEL_CLASS_KEY = "ModelClassForAction";
    private static final Controller _CONTROLLER = new PrefController();
    private static final List _sAllPrefActions = Collections.synchronizedList(new ArrayList());

    public static IdeAction createAction(Preference pref, Class xmlModelClass, String displayNameAndAccessKey, Icon icon) {
        return TogglePreferenceActionFactory.createAction(pref, xmlModelClass, displayNameAndAccessKey, icon, null, -1);
    }

    public static IdeAction createAction(Preference pref, Class xmlModelClass, String displayNameAndAccessKey, Icon icon, ArrayResourceBundle arb, int arbKey) {
        String commandName = xmlModelClass.getName() + "." + pref.getName();
        int cmdId = Ide.findOrCreateCmdID((String)commandName);
        int pak = StringUtils.getMnemonicKeyCode((String)displayNameAndAccessKey);
        Integer accessKey = pak == -1 ? null : IntegerUtils.getInteger((int)pak);
        String displayName = StringUtils.stripMnemonic((String)displayNameAndAccessKey);
        boolean enabled = true;
        String category = null;
        Object data = null;
        IdeAction action = arb == null || arbKey < 0 ? IdeAction.get((int)cmdId, (String)commandName, (String)displayName, category, (Integer)accessKey, (Icon)icon, data, (boolean)true) : IdeAction.get((int)cmdId, (String)commandName, (String)displayName, category, (Integer)accessKey, (ArrayResourceBundle)arb, (int)arbKey, data, (boolean)true);
        action.addController(_CONTROLLER);
        action.putValue(_PREF_KEY, (Object)pref);
        action.putValue(_MODEL_CLASS_KEY, (Object)xmlModelClass);
        action.putValue("Check", (Object)Boolean.TRUE);
        return action;
    }

    private TogglePreferenceActionFactory() {
    }

    private static class PrefController
    implements Controller {
        private PrefController() {
        }

        public boolean handleEvent(IdeAction action, Context context) {
            JDevXmlContext xmlContext;
            Preference pref = (Preference)action.getValue(TogglePreferenceActionFactory._PREF_KEY);
            if (pref != null && (xmlContext = this._getXmlContextIfRelevant(action, context)) != null) {
                boolean oldVal = Boolean.TRUE.equals(xmlContext.getPreferenceValue(pref));
                boolean newVal = !oldVal;
                xmlContext.setPreferenceValue(pref, BooleanUtils.getBoolean((boolean)newVal));
                this._update(action, pref, xmlContext);
                return true;
            }
            return false;
        }

        public boolean update(IdeAction action, Context context) {
            Preference pref = (Preference)action.getValue(TogglePreferenceActionFactory._PREF_KEY);
            if (pref != null) {
                this._update(action, pref, this._getXmlContextIfRelevant(action, context));
                return true;
            }
            return false;
        }

        private void _update(IdeAction action, Preference pref, JDevXmlContext xmlContext) {
            boolean enabled = xmlContext != null;
            action.setEnabled(enabled);
            if (enabled) {
                boolean value = Boolean.TRUE.equals(xmlContext.getPreferenceValue(pref));
                action.setState(value);
            }
        }

        private JDevXmlContext _getXmlContextIfRelevant(IdeAction action, Context ideContext) {
            JDevXmlContext xmlContext = JDevXmlContext.getXmlContext(ideContext);
            if (this._isXmlContextRelevant(action, xmlContext)) {
                return xmlContext;
            }
            return null;
        }

        private boolean _isXmlContextRelevant(IdeAction action, JDevXmlContext xmlContext) {
            if (xmlContext == null) {
                return false;
            }
            Class modelClass = (Class)action.getValue(TogglePreferenceActionFactory._MODEL_CLASS_KEY);
            return modelClass != null && modelClass.isInstance(xmlContext.getModel());
        }
    }
}

