/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.creatable.XmlCreatable;
import oracle.bali.xml.model.creatable.XmlKeyCreatable;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.ide.palette2.PaletteItem;
import oracle.javatools.datatransfer.AbstractTransformingDataTransferPlugin;
import oracle.javatools.datatransfer.AugmentableTransferable;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.TransferDataInfo;
import oracle.javatools.datatransfer.TransferUtils;

public class Palette2ToXmlKeyPlugin
extends AbstractTransformingDataTransferPlugin {
    protected void augmentImpl(AugmentableTransferable trans, Collection sourceDataInfos) {
        for (TransferDataInfo tdi : sourceDataInfos) {
            try {
                PaletteItem item;
                Object creatable;
                Object data = tdi.getData(FetchMode.STANDARD, false);
                if (!(data instanceof PaletteItem) || !((creatable = (item = (PaletteItem)data).getData((Object)XmlTransferUtils.FLAVOR_XMLCREATABLE)) instanceof XmlCreatable)) continue;
                trans.augment((TransferDataInfo)new TDI((XmlCreatable)creatable, item, tdi));
            }
            catch (IOException iOException) {}
        }
    }

    protected DataFlavor getSourceFlavor() {
        return PaletteItem.PALETTE_ITEM_FLAVOR;
    }

    private static class TDI
    extends TransferDataInfo {
        private final TransferDataInfo _paletteItemDataInfo;
        private final XmlCreatable _creatable;
        private final PaletteItem _item;

        public TDI(XmlCreatable creatable, PaletteItem item, TransferDataInfo paletteItemDataInfo) {
            this._creatable = creatable;
            this._item = item;
            this._paletteItemDataInfo = paletteItemDataInfo;
        }

        public Object getData(FetchMode mode, boolean asReference) throws IOException {
            return this._creatable;
        }

        public DataFlavor getDataFlavor() {
            return XmlTransferUtils.FLAVOR_XMLCREATABLE;
        }

        public Object getMetadata(Object key) {
            XmlKeyCreatable xmlKeyCreatable;
            XmlKey xmlKey;
            if (key == XmlTransferUtils.KEY_XMLKEY_LIST && this._creatable instanceof XmlKeyCreatable && (xmlKey = (xmlKeyCreatable = (XmlKeyCreatable)this._creatable).getXmlKey()) != null) {
                return Collections.singletonList(xmlKey);
            }
            if (key == METADATA_LONG_DESCRIPTION) {
                return this._item.getDescription();
            }
            if (key == METADATA_MEDIUM_DESCRIPTION || key == METADATA_SHORT_DESCRIPTION) {
                return this._item.getName();
            }
            return this._paletteItemDataInfo.getMetadata(key);
        }

        public float getSuitabilityRank() {
            return TransferUtils.lowerRank((float)this._paletteItemDataInfo.getSuitabilityRank());
        }
    }
}

