/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.ceditor;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.jdev.ceditor.XmlBrowseClickPlugin;
import oracle.bali.xml.gui.jdev.dependency.JDevDependencyContext;
import oracle.bali.xml.gui.jdev.util.XdfGoToDeclarationAction;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.dependency.Declaration;
import oracle.bali.xml.model.dependency.DependencyContext;
import oracle.bali.xml.model.dependency.XmlReference;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.peek.CodePeek;
import oracle.ide.peek.Peek;
import oracle.ide.peek.PeekHelper;
import oracle.ide.peek.Peekable;
import oracle.ide.peek.PeekableDelegator;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.NumberRange;
import oracle.javatools.editor.plugins.EditorPlugin;

public class XmlEditorPeekPlugin
implements EditorPlugin {
    private BasicEditorPane _editor;

    public void install(BasicEditorPane editor) {
        if (editor instanceof PeekableDelegator && this.installPeekableEditor(editor)) {
            this._editor = editor;
            PeekableImpl peekable = new PeekableImpl();
            ((PeekableDelegator)editor).setPeekable((Peekable)peekable);
        }
    }

    public void deinstall(BasicEditorPane editor) {
        this._editor = null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    protected boolean installPeekableEditor(BasicEditorPane editor) {
        return CodeEditor.getContext((BasicEditorPane)editor).getNode() instanceof XMLSourceNode;
    }

    protected NumberRange getRectangleOffsets(BasicEditorPane editor, int offset) {
        CodeEditor codeEditor = CodeEditor.getCodeEditor((BasicEditorPane)editor);
        if (codeEditor != null) {
            return XmlBrowseClickPlugin.getXmlIdentifierAtOffset(editor, offset);
        }
        return null;
    }

    protected Peek getPeek(BasicEditorPane editor, int offset, Rectangle rect) {
        return this._getPeek(editor, offset, rect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Peek _getPeek(BasicEditorPane editor, int offset, Rectangle rect) {
        Context ideContext;
        JDevXmlContext context;
        final CodePeek peek = PeekHelper.createCodePeek((JComponent)editor, (String)"", (String)"", (String)"Retrieving data...", (Rectangle)rect);
        CodeEditor ce = CodeEditor.getCodeEditor((BasicEditorPane)editor);
        if (ce != null && (context = JDevXmlContext.getXmlContext(ideContext = ce.getContext())) != null) {
            Ide.getWaitCursor().show();
            Runnable r = null;
            XmlModel model = context.getModel();
            model.acquireReadLock();
            try {
                final XmlReference ref = XdfGoToDeclarationAction.getReference(context, offset);
                r = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            JDevDependencyContext dc;
                            Declaration decl;
                            if (ref != null && (decl = ref.findDeclaration((DependencyContext)(dc = new JDevDependencyContext()))) != null) {
                                final String text = (String)decl.getMetadata((DependencyContext)dc, "displayTextMetadata");
                                final String label = (String)decl.getMetadata((DependencyContext)dc, "displayNameMetadata");
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        peek.setText(text);
                                        peek.setLabelText(label);
                                        peek.showPeek();
                                    }
                                });
                            }
                        }
                        catch (Throwable throwable) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Ide.getWaitCursor().hide();
                                }
                            });
                            throw throwable;
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                };
            }
            finally {
                model.releaseReadLock();
            }
            Thread t = new Thread(r, "Get Peek");
            t.start();
        }
        return peek;
    }

    private class PeekableImpl
    implements Peekable {
        private PeekableImpl() {
        }

        public Peek peek(Point p) {
            SwingUtilities.convertPointFromScreen(p, (Component)XmlEditorPeekPlugin.this._editor);
            int offset = XmlEditorPeekPlugin.this._editor.viewToModel(p);
            NumberRange range = XmlEditorPeekPlugin.this.getRectangleOffsets(XmlEditorPeekPlugin.this._editor, offset);
            if (range != null) {
                try {
                    Rectangle sRect = XmlEditorPeekPlugin.this._editor.modelToView(range.start);
                    Rectangle eRect = XmlEditorPeekPlugin.this._editor.modelToView(range.end);
                    sRect.add(eRect);
                    Rectangle r = sRect.intersection(XmlEditorPeekPlugin.this._editor.getVisibleRect());
                    Peek peek = XmlEditorPeekPlugin.this.getPeek(XmlEditorPeekPlugin.this._editor, offset, r);
                    if (peek != null) {
                        return peek;
                    }
                }
                catch (BadLocationException e) {
                    return null;
                }
            }
            return null;
        }
    }
}

