/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.jdev.annotation;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.TransactionOptions;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.annotation.impl.SideFileAnnotationModel;
import oracle.ide.Context;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.javatools.buffer.ReadWriteLock;

public abstract class JDevNodeSideFileAnnotationModel
extends SideFileAnnotationModel {
    private final XMLSourceNode _sideFileNode;
    private final Context _sideFileIdeContext;
    private final ReadWriteLock _sideFileNodeLock;
    private volatile boolean _needToRecreateContext = false;

    public JDevNodeSideFileAnnotationModel(XmlContext instanceContext, Context sideFileIdeContext) {
        super(instanceContext, (XmlContext)JDevXmlContext.getXmlContext(sideFileIdeContext));
        this._sideFileIdeContext = sideFileIdeContext;
        this._sideFileNode = (XMLSourceNode)sideFileIdeContext.getNode();
        try {
            Method nodeLockMethod = Node.class.getDeclaredMethod("nodeLock", new Class[0]);
            nodeLockMethod.setAccessible(true);
            this._sideFileNodeLock = (ReadWriteLock)nodeLockMethod.invoke((Object)this._sideFileNode, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected exception while obtaining side file node lock (see chained exception)", e);
        }
        this._sideFileNode.addNodeListener(new SideFileNodeListener(this));
    }

    public void acquireReadLock() {
        block8: {
            boolean outerLockReleased = false;
            this._sideFileNodeLock.readLock();
            try {
                if (this._needToRecreateContext || this.getSideFileModel().getDomModel().needsReparse()) {
                    this._sideFileNodeLock.readUnlock();
                    outerLockReleased = true;
                    this._sideFileNodeLock.writeLock();
                    try {
                        this._recreateSideFileXmlContextIfNeeded();
                        super.acquireReadLock();
                        break block8;
                    }
                    finally {
                        this._sideFileNodeLock.writeUnlock();
                    }
                }
                super.acquireReadLock();
            }
            finally {
                if (!outerLockReleased) {
                    this._sideFileNodeLock.readUnlock();
                }
            }
        }
    }

    public void acquireWriteLock() {
        this._sideFileNodeLock.writeLock();
        try {
            this._recreateSideFileXmlContextIfNeeded();
            super.acquireWriteLock();
        }
        finally {
            this._sideFileNodeLock.writeUnlock();
        }
    }

    public void startTransaction(TransactionOptions transOptions) {
        this._sideFileNodeLock.writeLock();
        try {
            this._recreateSideFileXmlContextIfNeeded();
            super.startTransaction(transOptions);
        }
        finally {
            this._sideFileNodeLock.writeUnlock();
        }
    }

    private void _recreateSideFileXmlContextIfNeeded() {
        if (this._needToRecreateContext) {
            JDevXmlContext newXmlContext = JDevXmlContext.getXmlContext(this._sideFileIdeContext);
            this.replaceSideFileXmlContext((XmlContext)newXmlContext);
            this._needToRecreateContext = false;
        }
    }

    private static class SideFileNodeListener
    extends NodeListener {
        private final WeakReference<JDevNodeSideFileAnnotationModel> _annoModelRef;

        public SideFileNodeListener(JDevNodeSideFileAnnotationModel annoModel) {
            this._annoModelRef = new WeakReference<JDevNodeSideFileAnnotationModel>(annoModel);
        }

        public void nodeClosed(NodeEvent e) {
            JDevNodeSideFileAnnotationModel annoModel = (JDevNodeSideFileAnnotationModel)((Object)this._annoModelRef.get());
            if (annoModel != null) {
                annoModel._needToRecreateContext = true;
            }
        }
    }
}

