/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.addin;

import java.awt.BorderLayout;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.addin.XMLEditorAddin;
import oracle.bali.xml.addin.XMLEditorOptionsPrefs;
import oracle.ide.Context;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.view.View;
import oracle.javatools.editor.EditorProperties;

public class XMLEditorOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private static final String _KEY_END_TAG = "XMLADDIN.OPTIONS_END_TAG";
    private static final String _KEY_REQUIRED = "XMLADDIN.OPTIONS_REQUIRED";
    private static final String _KEY_INDENT = "XMLADDIN.OPTIONS_SMART_INDENT";
    private static final String _KEY_ERRORS = "XMLADDIN.SHOW_ERRORS";
    private JCheckBox _endTag;
    private JCheckBox _required;
    private JCheckBox _indent;
    private JCheckBox _showErrors;
    private boolean _errorsUpdated;

    public XMLEditorOptionsPanel() {
        this._init();
        this.setHelpID("f1_prefeditorxml_html");
    }

    public void onEntry(TraversableContext tc) {
        XMLEditorOptionsPrefs xmlEditorPrefs = XMLEditorOptionsPanel.getXMLEditorPrefs(tc);
        this._load(xmlEditorPrefs);
    }

    public void onExit(TraversableContext tc) {
        XMLEditorOptionsPrefs xmlEditorPrefs = XMLEditorOptionsPanel.getXMLEditorPrefs(tc);
        this._commit(xmlEditorPrefs);
    }

    public void apply(ApplyEvent e) {
        if (this._errorsUpdated) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    Collection c = ExplorerManager.getExplorerManager().getViews();
                    if (c != null) {
                        for (View v : c) {
                            String ext;
                            Context context = v.getContext();
                            Node n = context.getNode();
                            if (n == null || (ext = XMLEditorAddin.getExtension(n.getClass())) == null || "".equals(ext)) continue;
                            UpdateMessage.fireStructureChanged((Subject)n);
                        }
                    }
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    public void cancel(ApplyEvent e) {
    }

    private void _init() {
        String requiredLabel = XMLEditorAddin.getTranslatedString(_KEY_REQUIRED);
        String endLabel = XMLEditorAddin.getTranslatedString(_KEY_END_TAG);
        String indentLabel = XMLEditorAddin.getTranslatedString(_KEY_INDENT);
        String showErrorsLabel = XMLEditorAddin.getTranslatedString(_KEY_ERRORS);
        this._required = new JCheckBox();
        this._required.setText(StringUtils.stripMnemonic((String)requiredLabel));
        this._required.setMnemonic(StringUtils.getMnemonicKeyCode((String)requiredLabel));
        this._endTag = new JCheckBox();
        this._endTag.setText(StringUtils.stripMnemonic((String)endLabel));
        this._endTag.setMnemonic(StringUtils.getMnemonicKeyCode((String)endLabel));
        this._indent = new JCheckBox();
        this._indent.setText(StringUtils.stripMnemonic((String)indentLabel));
        this._indent.setMnemonic(StringUtils.getMnemonicKeyCode((String)indentLabel));
        this._showErrors = new JCheckBox();
        this._showErrors.setText(StringUtils.stripMnemonic((String)showErrorsLabel));
        this._showErrors.setMnemonic(StringUtils.getMnemonicKeyCode((String)showErrorsLabel));
        Box b = Box.createVerticalBox();
        b.add(this._required);
        b.add(Box.createVerticalStrut(3));
        b.add(this._endTag);
        b.add(Box.createVerticalStrut(3));
        this.setLayout(new BorderLayout());
        this.add("North", b);
    }

    private void _load(XMLEditorOptionsPrefs xmlEditorPrefs) {
        this._endTag.setSelected(xmlEditorPrefs.getEndTagCompletion());
        this._required.setSelected(xmlEditorPrefs.getRequiredAttributeInsertion());
        this._indent.setSelected(xmlEditorPrefs.getSmartIndent());
        this._showErrors.setSelected(xmlEditorPrefs.getShowErrors());
    }

    private void _commit(XMLEditorOptionsPrefs xmlEditorPrefs) {
        this._errorsUpdated = this._showErrors.isSelected() != xmlEditorPrefs.getShowErrors().booleanValue();
        xmlEditorPrefs.setEndTagCompletion(this._endTag.isSelected());
        xmlEditorPrefs.setRequiredAttributeInsertion(this._required.isSelected());
        xmlEditorPrefs.setSmartIndent(this._indent.isSelected());
        xmlEditorPrefs.setShowErrors(this._showErrors.isSelected());
        EditorProperties.getProperties().putBooleanProperty("XMLLanguageModule.END_TAG", xmlEditorPrefs.getEndTagCompletion().booleanValue());
        EditorProperties.getProperties().putBooleanProperty("XMLLanguageModule.REQUIRED_ATTRIBUTE_INSERTION", xmlEditorPrefs.getRequiredAttributeInsertion().booleanValue());
        EditorProperties.getProperties().putBooleanProperty("XMLLanguageModule.SMART_INDENT", xmlEditorPrefs.getSmartIndent().booleanValue());
    }

    private static XMLEditorOptionsPrefs getXMLEditorPrefs(TraversableContext tc) {
        return XMLEditorOptionsPrefs.getInstance(tc.getPropertyStorage());
    }
}

