/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.spinBox;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Caret;
import oracle.bali.ewt.spinBox.NumberRange;
import oracle.bali.ewt.spinBox.NumericSpinBoxModel;
import oracle.bali.ewt.spinBox.NumericSpinBuddy;
import oracle.bali.ewt.spinBox.SpinAccelerator;
import oracle.bali.ewt.spinBox.SpinBox;
import oracle.bali.ewt.spinBox.WrappingNumericSpinBoxModel;
import oracle.bali.share.collection.Range;

public class NumericSpinBox
extends SpinBox {
    private boolean _wrapping = false;
    private boolean _decimal = false;
    private Listener _listener;

    public NumericSpinBox() {
        this(0, 0);
    }

    public NumericSpinBox(int lowerLimit, int upperLimit) {
        super(new NumericSpinBuddy(), new NumericSpinBoxModel(new Range(lowerLimit, upperLimit)));
        NumericSpinBuddy buddy = (NumericSpinBuddy)this.getSpinBuddy();
        buddy.setRange(this.getRange());
        this._listener = new Listener();
        buddy.getDocument().addDocumentListener(this._listener);
        Caret c = buddy.getCaret();
        if (c != null) {
            c.addChangeListener(this._listener);
        }
        buddy.addPropertyChangeListener(this._listener);
        buddy.addFocusListener(this._listener);
        buddy.addActionListener(this._listener);
        this._defaultAccelerator(this.getRange());
    }

    public NumericSpinBox(Number lowerLimit, Number upperLimit) {
        super(new NumericSpinBuddy(), new NumericSpinBoxModel(new NumberRange(lowerLimit, upperLimit)));
        NumericSpinBuddy buddy = (NumericSpinBuddy)this.getSpinBuddy();
        buddy.setRange(this.getRange());
        this._listener = new Listener();
        buddy.getDocument().addDocumentListener(this._listener);
        Caret c = buddy.getCaret();
        if (c != null) {
            c.addChangeListener(this._listener);
        }
        buddy.addPropertyChangeListener(this._listener);
        buddy.addFocusListener(this._listener);
        this._defaultAccelerator(this.getRange());
    }

    public int getIntValue() {
        return ((Number)this.getValue()).intValue();
    }

    public void setIntValue(int value) {
        if (value != this.getIntValue()) {
            NumericSpinBoxModel iter = (NumericSpinBoxModel)this.getModel();
            iter.setValue(value);
            this.setModel(iter);
        }
    }

    public void setValue(Number value) {
        if (value.doubleValue() != ((Number)this.getValue()).doubleValue()) {
            NumericSpinBoxModel iter = (NumericSpinBoxModel)this.getModel();
            iter.setNumber(value);
            this.setModel(iter);
        }
    }

    public boolean isWrapping() {
        return this._wrapping;
    }

    public void setWrapping(boolean wrapping) {
        if (wrapping != this.isWrapping()) {
            this._wrapping = wrapping;
            this.setRange(this.getRange());
        }
    }

    public boolean isDecimal() {
        return this._decimal;
    }

    public void setDecimal(boolean enabled) {
        if (this.isDecimal() != enabled) {
            this._decimal = enabled;
            ((NumericSpinBoxModel)this.getModel()).setDecimal(enabled);
            ((NumericSpinBuddy)this.getSpinBuddy()).__setDecimal(enabled);
        }
    }

    public Range getRange() {
        return ((NumericSpinBoxModel)this.getModel()).getRange();
    }

    public void setRange(NumberRange range) {
        NumericSpinBoxModel iter = this.isWrapping() ? new WrappingNumericSpinBoxModel(range) : new NumericSpinBoxModel(range);
        boolean decimal = this.isDecimal();
        iter.setDecimal(decimal);
        Number value = (Number)this.getValue();
        if (range.inRange(value)) {
            iter.setNumber(value);
        }
        ((NumericSpinBuddy)this.getSpinBuddy()).setRange(range);
        this.setModel(iter);
        this._defaultAccelerator(range);
    }

    public void setRange(Range range) {
        NumericSpinBoxModel iter = this.isWrapping() ? new WrappingNumericSpinBoxModel(range) : new NumericSpinBoxModel(range);
        boolean decimal = this.isDecimal();
        iter.setDecimal(decimal);
        Number value = (Number)this.getValue();
        if (range.inRange(value.intValue())) {
            iter.setNumber(value);
        }
        ((NumericSpinBuddy)this.getSpinBuddy()).setRange(range);
        this.setModel(iter);
        this._defaultAccelerator(range);
    }

    public final int getMinimum() {
        return this.getRange().getLowerLimit();
    }

    public final void setMinimum(int min) {
        Range range = this.getRange();
        int max = range.getUpperLimit();
        if (max < min) {
            max = min;
        }
        this.setRange(new Range(min, max));
    }

    public final int getMaximum() {
        return this.getRange().getUpperLimit();
    }

    public final void setMaximum(int max) {
        Range range = this.getRange();
        int min = range.getLowerLimit();
        if (min > max) {
            min = max;
        }
        this.setRange(new Range(min, max));
    }

    public final Number getMinimumNumber() {
        Range range = this.getRange();
        if (range instanceof NumberRange) {
            return ((NumberRange)range).getLower();
        }
        return range.getLowerLimit();
    }

    public final void setMinimumNumber(Number min) {
        Range range = this.getRange();
        Number max = range instanceof NumberRange ? (Number)((NumberRange)range).getUpper() : (Number)range.getUpperLimit();
        if (max.doubleValue() < min.doubleValue()) {
            max = min;
        }
        this.setRange(new NumberRange(min, max));
    }

    public final Number getMaximumNumber() {
        Range range = this.getRange();
        if (range instanceof NumberRange) {
            return ((NumberRange)range).getUpper();
        }
        return range.getUpperLimit();
    }

    public final void setMaximumNumber(Number max) {
        Range range = this.getRange();
        Number min = range instanceof NumberRange ? (Number)((NumberRange)range).getLower() : (Number)range.getLowerLimit();
        if (min.doubleValue() > max.doubleValue()) {
            min = max;
        }
        this.setRange(new NumberRange(min, max));
    }

    void _regetValue(boolean setValidValue) {
        NumericSpinBuddy buddy = (NumericSpinBuddy)this.getSpinBuddy();
        if (setValidValue) {
            buddy.__setDoValidate(true);
            buddy.__setValue(this._getValidValueAdjustedToRange(buddy));
            buddy.__setDoValidate(false);
        } else {
            try {
                Number n = buddy.getNumber();
                if (n != null) {
                    if (!this.isDecimal()) {
                        this.setIntValue(n.intValue());
                    } else {
                        this.setValue(n);
                    }
                } else {
                    this.fireStateChanged();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private Object _getValidValueAdjustedToRange(NumericSpinBuddy buddy) {
        Number newNumberValue = (Number)this.getValue();
        try {
            Range range = this.getRange();
            Number n = buddy.getNumber();
            if (n != null) {
                if (!this.isDecimal()) {
                    int newValue = n.intValue();
                    if (!range.inRange(newValue)) {
                        if (newValue > range.getUpperLimit()) {
                            newValue = range.getUpperLimit();
                        } else if (newValue < range.getLowerLimit()) {
                            newValue = range.getLowerLimit();
                        }
                    }
                    newNumberValue = newValue;
                } else {
                    Number newNumber = n;
                    if (range instanceof NumberRange) {
                        NumberRange numRange = (NumberRange)range;
                        if (!numRange.inRange(newNumber)) {
                            if (newNumber.doubleValue() > numRange.getUpper().doubleValue()) {
                                newNumber = numRange.getUpper();
                            } else if (newNumber.doubleValue() < numRange.getLower().doubleValue()) {
                                newNumber = numRange.getLower();
                            }
                        }
                        newNumberValue = newNumber;
                    } else {
                        int newValue = n.intValue();
                        if (!range.inRange(newValue)) {
                            if (newValue > range.getUpperLimit()) {
                                newValue = range.getUpperLimit();
                            } else if (newValue < range.getLowerLimit()) {
                                newValue = range.getLowerLimit();
                            }
                            newNumberValue = newValue;
                        } else {
                            newNumberValue = n;
                        }
                    }
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return newNumberValue;
    }

    private void _defaultAccelerator(Range range) {
        this.setAccelerator(SpinAccelerator.createDefaultAccelerator(range.getUpperLimit() - range.getLowerLimit()));
    }

    private class Listener
    extends FocusAdapter
    implements DocumentListener,
    ChangeListener,
    PropertyChangeListener,
    ActionListener {
        private Listener() {
        }

        public void focusLost(FocusEvent e) {
            NumericSpinBox.this._regetValue(true);
        }

        public void insertUpdate(DocumentEvent e) {
            NumericSpinBox.this._regetValue(false);
        }

        public void removeUpdate(DocumentEvent e) {
            NumericSpinBox.this._regetValue(false);
        }

        public void changedUpdate(DocumentEvent e) {
            NumericSpinBox.this._regetValue(false);
        }

        public void actionPerformed(ActionEvent ae) {
            NumericSpinBox.this._regetValue(true);
        }

        public void stateChanged(ChangeEvent e) {
            if (NumericSpinBox.this.isDecimal()) {
                NumericSpinBuddy buddy = (NumericSpinBuddy)NumericSpinBox.this.getSpinBuddy();
                int decimal = -1;
                String text = buddy.getText();
                if (text != null) {
                    decimal = text.indexOf(46);
                }
                int caretPosition = buddy.getCaretPosition();
                if (decimal != -1 && decimal < caretPosition) {
                    ((NumericSpinBoxModel)NumericSpinBox.this.getModel()).__setIteratingDecimal(true);
                } else {
                    ((NumericSpinBoxModel)NumericSpinBox.this.getModel()).__setIteratingDecimal(false);
                }
            } else {
                ((NumericSpinBoxModel)NumericSpinBox.this.getModel()).__setIteratingDecimal(false);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("caret".equals(evt.getPropertyName())) {
                Caret newCaret;
                Caret oldCaret = (Caret)evt.getOldValue();
                if (oldCaret != null) {
                    oldCaret.removeChangeListener(NumericSpinBox.this._listener);
                }
                if ((newCaret = (Caret)evt.getNewValue()) != null) {
                    newCaret.addChangeListener(NumericSpinBox.this._listener);
                }
            }
        }
    }
}

