/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.painter;

import java.awt.Dimension;
import java.awt.Graphics;
import oracle.bali.ewt.graphics.ImageSet;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class ImageSetPainter
extends AbstractPainter {
    private ImageSet _imageSet;
    private String _imageSetKey;

    public ImageSetPainter() {
    }

    public ImageSetPainter(ImageSet imageSet) {
        this._imageSet = imageSet;
    }

    public ImageSetPainter(String imageSetKey) {
        this._imageSetKey = imageSetKey;
    }

    public Dimension getSize(PaintContext context, int availableWidth, int availableHeight) {
        return this.getMinimumSize(context);
    }

    public Dimension getMinimumSize(PaintContext context) {
        ImageSet imageSet = this.getImageSet(context);
        return imageSet != null ? imageSet.getSize() : new Dimension(0, 0);
    }

    public Dimension getMaximumSize(PaintContext context) {
        return this.getMinimumSize(context);
    }

    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        ImageSet imageSet = this.getImageSet(context);
        if (imageSet != null) {
            imageSet.paintImage(this.getPaintState(context) & 0x3F, g, x, y, context.getImageObserver());
        }
    }

    public boolean isTransparent(PaintContext context) {
        ImageSet imageSet = this.getImageSet(context);
        return imageSet != null ? imageSet.isTransparent() : false;
    }

    public int getRepaintFlags(PaintContext context) {
        ImageSet imageSet = this.getImageSet(context);
        return imageSet != null ? imageSet.getAvailableImageFlags() : 0;
    }

    public Painter getPainterAt(PaintContext context, int availableWidth, int availableHeight, int x, int y, Painter proxyPainter) {
        ImageSet imageSet = this.getImageSet(context);
        if (imageSet != null && imageSet.contains(x, y)) {
            return this;
        }
        return null;
    }

    protected ImageSet getImageSet(PaintContext context) {
        return this._imageSet != null ? this._imageSet : (this._imageSetKey != null ? ImageSetPainter._getImageSet(context, this._imageSetKey) : (ImageSet)context.getPaintData(PaintContext.IMAGESET_KEY));
    }

    protected int getPaintState(PaintContext context) {
        return context.getPaintState();
    }

    private static ImageSet _getImageSet(PaintContext context, String key) {
        Object o = context.getPaintUIDefaults().get(key);
        if (o instanceof ImageSet) {
            return (ImageSet)o;
        }
        return null;
    }
}

