/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;
import oracle.bali.ewt.graphics.GraphicsProxy;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.MenuClearAction;
import oracle.bali.ewt.olaf.OracleMenuItemUI;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.util.FocusUtils;

public class OracleMenuUI
extends BasicMenuUI {
    private GProxy _graphicsProxy;

    public static ComponentUI createUI(JComponent component) {
        return new OracleMenuUI();
    }

    protected void paintMenuItem(Graphics g, JComponent comp, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        if (this._graphicsProxy == null) {
            this._graphicsProxy = new GProxy();
        }
        this._graphicsProxy.setGraphics(g);
        super.paintMenuItem(this._graphicsProxy, comp, checkIcon, arrowIcon, background, foreground, defaultTextIconGap);
        this._graphicsProxy.setGraphics(null);
        if (comp.getParent() instanceof JMenuBar) {
            Dimension size = comp.getSize();
            Color oldColor = g.getColor();
            g.setColor(comp.getBackground());
            g.drawLine(0, 0, 2, 0);
            g.drawLine(0, 1, 0, 2);
            g.drawLine(size.width - 3, 0, size.width - 1, 0);
            g.drawLine(size.width - 1, 1, size.width - 1, 2);
            g.setColor(oldColor);
        } else {
            OracleMenuItemUI.drawSelection(g, comp);
        }
    }

    protected JComponent getComponent() {
        return this.menuItem;
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        if (!FocusUtils.areNewFocusAPIsAvailable()) {
            ActionMap map = SwingUtilities.getUIActionMap(this.menuItem);
            map.put("oracle.bali.ewt.olaf.MenuClearAction", MenuClearAction.getInstance());
        }
    }

    protected void uninstallKeyboardActions() {
        if (!FocusUtils.areNewFocusAPIsAvailable()) {
            ActionMap map = SwingUtilities.getUIActionMap(this.menuItem);
            map.put("oracle.bali.ewt.olaf.MenuClearAction", null);
        }
        super.uninstallKeyboardActions();
    }

    private class GProxy
    extends GraphicsProxy {
        private Graphics _g;

        public GProxy() {
            super(null);
        }

        public Graphics getGraphics() {
            return this._g;
        }

        public void setColor(Color color) {
            if (color == ColorScheme.__sControlText) {
                UIDefaults defaults = OracleUIUtils.getUIDefaults(OracleMenuUI.this.getComponent());
                color = defaults.getColor("controlText");
            }
            super.setColor(color);
        }

        public void setGraphics(Graphics g) {
            this._g = g;
        }
    }
}

