/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.CellRendererPane;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIDefaults;
import oracle.bali.ewt.graphics.ImageSet;
import oracle.bali.ewt.olaf.AbstractButtonPaintContext;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleFocusPainter;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.olaf.PainterButton;
import oracle.bali.ewt.painter.FixedAlignmentPainter;
import oracle.bali.ewt.painter.ImageSetPainter;
import oracle.bali.ewt.painter.MarginBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterJoiner;
import oracle.bali.ewt.plaf.UIUtils;
import oracle.bali.ewt.util.ImmInsets;

class OracleComboBoxButton
extends PainterButton {
    private JComboBox _comboBox;
    private JList _listBox;
    private CellRendererPane _rendererPane;
    private boolean _iconOnly;
    private static Painter _sPainter;
    private static Painter _sIconOnlyPainter;
    private static ImmInsets _sIconInsets;
    private static ImmInsets _sIconArmedInsets;
    private static ImmInsets _sInsets;
    private static ImmInsets _sArmedInsets;

    public OracleComboBoxButton(JComboBox cb, CellRendererPane pane) {
        super((Painter)null);
        this._comboBox = cb;
        this._rendererPane = pane;
        this.setFocusable(false);
        this.setModel(this.model);
        this.setBackground(null);
        this.setForeground(null);
    }

    void setList(JList list) {
        this._listBox = list;
    }

    public void updateUI() {
        super.updateUI();
        PaintCtxt context = new PaintCtxt(this);
        OracleUIUtils.putPaintContext(this, context);
    }

    public boolean isOpaque() {
        return false;
    }

    public boolean hasPaintFocus() {
        if (this._comboBox != null) {
            return this._comboBox.hasFocus();
        }
        return false;
    }

    public Painter getPainter() {
        if (this.isIconOnly()) {
            if (_sIconOnlyPainter == null) {
                _sIconOnlyPainter = new FixedAlignmentPainter(this._getImageSetPainter());
            }
            return _sIconOnlyPainter;
        }
        if (_sPainter == null) {
            _sPainter = new PainterJoiner(new FixedAlignmentPainter(this._getImageSetPainter()), new MarginBorderPainter(new OracleFocusPainter(null, true)), 10, true);
        }
        return _sPainter;
    }

    public final boolean isIconOnly() {
        return this._iconOnly;
    }

    public final void setIconOnly(boolean isIconOnly) {
        this._iconOnly = isIconOnly;
    }

    public boolean isEnabled() {
        if (this._comboBox != null) {
            return this._comboBox.isEnabled();
        }
        return super.isEnabled();
    }

    protected void processMouseEvent(MouseEvent e) {
        if (this.isEnabled() && e.getID() == 501) {
            if (this._comboBox.isEditable()) {
                this._comboBox.getEditor().getEditorComponent().requestFocus();
            } else {
                this._comboBox.requestFocus();
            }
        }
        super.processMouseEvent(e);
    }

    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(this.getForeground());
        JComboBox comboBox = this._comboBox;
        PaintContext context = OracleUIUtils.getPaintContext(this);
        if (!this.isIconOnly() && comboBox != null) {
            boolean swapEnabled;
            boolean isArmed;
            Insets insets = this.getInsets();
            int width = this.getWidth() - (insets.left + insets.right);
            int height = this.getHeight() - (insets.top + insets.bottom);
            ImmInsets focusInsets = OracleFocusPainter.getFocusInsets();
            int left = insets.left + focusInsets.left;
            int top = insets.top + focusInsets.top;
            boolean bl = isArmed = (context.getPaintState() & 2) != 0;
            if (isArmed) {
                ++top;
                --height;
                ++left;
                --width;
            }
            int right = left + (width - 1) - (focusInsets.left + focusInsets.right);
            int bottom = top + (height - 1) - (focusInsets.top + focusInsets.bottom);
            ListCellRenderer<Object> renderer = comboBox.getRenderer();
            boolean renderPressed = this.getModel().isPressed();
            Component c = renderer.getListCellRendererComponent(this._listBox, comboBox.getSelectedItem(), -1, renderPressed, false);
            CellRendererPane rendererPane = this._rendererPane;
            c.setFont(rendererPane.getFont());
            c.setBackground(this.getBackground());
            c.setForeground(this.getForeground());
            boolean bl2 = swapEnabled = comboBox.isEnabled() != c.isEnabled();
            if (swapEnabled) {
                c.setEnabled(!c.isEnabled());
            }
            int cWidth = width - (insets.right + 14);
            rendererPane.paintComponent(g, c, this, left += 2, top -= 2, cWidth -= 2, height);
            if (swapEnabled) {
                c.setEnabled(!c.isEnabled());
            }
        }
        UIUtils.paint(g, this.getPainter(), context, this);
    }

    private Painter _getImageSetPainter() {
        return new ShadowBorder(new ImageSetPainter());
    }

    static {
        _sIconInsets = ImmInsets.getEmptyInsets();
        _sIconArmedInsets = new ImmInsets(1, 1, -1, -1);
        _sInsets = new ImmInsets(0, 0, 1, 0);
        _sArmedInsets = new ImmInsets(1, 1, 0, -1);
    }

    static class ShadowBorder
    extends MarginBorderPainter {
        public ShadowBorder(Painter wrappedPainter) {
            super(wrappedPainter);
        }

        protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
            JComponent comp = context.getComponent();
            JComboBox combo = (JComboBox)comp.getParent();
            int state = context.getPaintState();
            boolean isDisabled = (state & 1) != 0;
            boolean isArmed = (state & 2) != 0;
            boolean isInactive = (state & 4) != 0;
            boolean isEditable = combo.isEditable();
            Rectangle oldBounds = g.getClipBounds();
            g.setClip(oldBounds.x - 1, oldBounds.y - 2, oldBounds.width + 2, oldBounds.height + 4);
            y = -1;
            int right = x + width;
            int bottom = y + comp.getSize().height;
            Color savedColor = g.getColor();
            UIDefaults defaults = context.getPaintUIDefaults();
            if (!isInactive) {
                if (isArmed && isEditable) {
                    Color shadow = defaults.getColor(ColorScheme.DARK_INTENSITY);
                    g.setColor(shadow);
                    g.drawLine(x + 1, y - 1, x + 1, bottom - 1);
                    g.drawLine(x + 2, y - 1, x + 2, bottom - 1);
                } else if (isEditable) {
                    Color outline = defaults.getColor(ColorScheme.NORMAL_INTENSITY);
                    Color highlight = isDisabled ? combo.getBackground() : Color.white;
                    g.setColor(outline);
                    g.drawLine(x, y, x + 1, y);
                    g.drawLine(right, y, right - 1, y);
                    g.drawLine(x, y, x, bottom);
                    g.drawLine(right, y, right, bottom - 1);
                    g.drawLine(x, bottom, right - 1, bottom);
                    g.drawLine(x, bottom - 1, x + 1, bottom - 1);
                    g.drawLine(right, bottom - 1, right - 1, bottom - 1);
                    g.setColor(highlight);
                    g.drawLine(x + 2, y, right - 2, y);
                    g.drawLine(x + 1, y + 1, x + 1, bottom - 2);
                }
            } else if (isEditable) {
                Color outline = defaults.getColor(ColorScheme.NORMAL_INTENSITY);
                Color back = combo.getBackground();
                g.setColor(back);
                g.drawLine(x + 1, y - 1, right - 1, y - 1);
                g.drawLine(x, y, right, y);
                g.drawLine(x + 1, bottom + 1, right - 1, bottom + 1);
                g.drawLine(right, x, right, bottom);
                g.setColor(outline);
                g.drawLine(x - 1, y - 1, x - 1, bottom + 1);
                g.drawLine(x, y - 1, x, y - 1);
                g.drawLine(x, bottom + 1, x, bottom + 1);
            }
            g.setColor(savedColor);
            g.setClip(oldBounds.x, oldBounds.y, oldBounds.width, oldBounds.height);
        }
    }

    private class PaintCtxt
    extends AbstractButtonPaintContext {
        public PaintCtxt(OracleComboBoxButton button) {
            super(button, true);
        }

        public int getPaintState() {
            int state = super.getPaintState();
            if (OracleComboBoxButton.this.hasPaintFocus()) {
                state |= 0x40;
            }
            if (OracleComboBoxButton.this._comboBox != null && OracleComboBoxButton.this._comboBox.isPopupVisible()) {
                state |= 2;
            }
            return state;
        }

        public Object getPaintData(Object key) {
            if (IMAGESET_KEY.equals(key)) {
                return (ImageSet)this.getPaintUIDefaults().get("ComboBox.arrowSet");
            }
            if (MarginBorderPainter.MARGIN_KEY.equals(key)) {
                boolean isArmed;
                boolean bl = isArmed = (this.getPaintState() & 2) != 0;
                if (OracleComboBoxButton.this.isIconOnly()) {
                    return isArmed ? _sIconArmedInsets : _sIconInsets;
                }
                return isArmed ? _sArmedInsets : _sInsets;
            }
            return super.getPaintData(key);
        }
    }
}

