/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.olaf.BrowserColorScheme;
import oracle.bali.ewt.olaf.ClassInstantiator;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.ewt.plaf.StringInstantiator;

public class BrowserLookAndFeel
extends OracleLookAndFeel {
    private static Color _sLightBeige = new ColorUIResource(new Color(-52));
    private static Color _sDarkBeige = new ColorUIResource(new Color(-2959184));
    private static Color _sDarkestBeige = new ColorUIResource(new Color(-6710938));
    private static Color _sDarkestBlue = new ColorUIResource(new Color(-16764058));
    private static Color _sDarkBlue = new ColorUIResource(new Color(-13408615));
    private static Color _sLightBlue = new ColorUIResource(new Color(-10053172));
    private static Color _sLightestBlue = new ColorUIResource(new Color(-6697729));
    private static Color _sTextFieldChoiceHighlightColor = new ColorUIResource(new Color(-863993728));
    private static BrowserColorScheme _sDefaultScheme;
    private static BrowserColorScheme _sCurrentScheme;
    private static BrowserColorScheme[] _sAvailableSchemes;

    public String getName() {
        return "Oracle Browser Look and Feel";
    }

    public String getID() {
        return "Browser";
    }

    public String getDescription() {
        return "The Oracle Browser Look and Feel";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public static ColorScheme getColorScheme() {
        return _sCurrentScheme;
    }

    public static void setColorScheme(Color matchColor) {
        _sCurrentScheme = (BrowserColorScheme)BrowserLookAndFeel.__getColorScheme((ColorScheme[])_sAvailableSchemes, matchColor);
    }

    public static void setColorScheme(String schemeName) {
        BrowserColorScheme newScheme = (BrowserColorScheme)BrowserLookAndFeel.__getColorScheme((ColorScheme[])_sAvailableSchemes, schemeName);
        if (newScheme == null) {
            newScheme = _sDefaultScheme;
        }
        _sCurrentScheme = newScheme;
    }

    public static ColorScheme[] getAvailableColorSchemes() {
        return (ColorScheme[])_sAvailableSchemes.clone();
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        Object[] uiDefaults = new String[]{"PanelUI", "oracle.bali.ewt.olaf.BrowserPanelUI"};
        table.putDefaults(uiDefaults);
        ClassInstantiator.putInstantiators(table, (String[])uiDefaults);
        table.put("UIDefaults.light", (Object)null);
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        String s = "oracle.bali.ewt.olaf.OracleUIUtils#imageInst|";
        table.put("checkboxStrip", new StringInstantiator(s + "browserCheckboxStrip.gif"));
        table.put("radioButtonStrip", new StringInstantiator(s + "browserRadioButtonStrip.gif"));
    }

    protected void installColors(UIDefaults defaults) {
        Color sand = _sCurrentScheme.getDefiningColor();
        ColorUIResource black = new ColorUIResource(Color.black);
        ColorUIResource white = new ColorUIResource(Color.white);
        defaults.put("BrowserLookAndFeel.SAND", sand);
        defaults.put(LookAndFeel.ACTIVE_CAPTION, _sDarkBlue);
        defaults.put(LookAndFeel.ACTIVE_CAPTION_TEXT, white);
        defaults.put(LookAndFeel.INACTIVE_CAPTION_BORDER, black);
        defaults.put(LookAndFeel.INFO, new Color(255, 255, 225));
        defaults.put(LookAndFeel.ACTIVE_CAPTION_BORDER, _sDarkestBeige);
        defaults.put(LookAndFeel.INACTIVE_CAPTION, _sLightBlue);
        defaults.put(LookAndFeel.INACTIVE_CAPTION_TEXT, sand);
        defaults.put(LookAndFeel.WINDOW_TEXT, black);
        defaults.put(LookAndFeel.MENU, sand);
        defaults.put(LookAndFeel.MENU_TEXT, black);
        defaults.put(LookAndFeel.TEXT, white);
        defaults.put(LookAndFeel.TEXT_TEXT, black);
        defaults.put(LookAndFeel.TEXT_HIGHLIGHT_TEXT, white);
        defaults.put(LookAndFeel.TEXT_INACTIVE_TEXT, _sDarkestBeige);
        defaults.put(LookAndFeel.CONTROL, sand);
        defaults.put(LookAndFeel.CONTROL_TEXT, black);
        defaults.put(LookAndFeel.CONTROL_LT_HIGHLIGHT, sand);
        defaults.put(LookAndFeel.NORMAL_INTENSITY, _sDarkBeige);
        defaults.put(LookAndFeel.CONTROL_SHADOW, _sDarkBeige);
        defaults.put(LookAndFeel.CONTROL_DK_SHADOW, _sDarkestBeige);
        defaults.put(ColorScheme.CONTROL_SHADOW_DARK, _sDarkestBeige);
        defaults.put(LookAndFeel.DARK_INTENSITY, _sTextFieldChoiceHighlightColor);
        defaults.put(LookAndFeel.CONTROL_HIGHLIGHT, _sDarkBeige);
        defaults.put(LookAndFeel.SCROLLBAR, _sDarkBeige);
        defaults.put(LookAndFeel.INFO_TEXT, black);
        defaults.put(LookAndFeel.CONTROL_INACTIVE_TEXT, _sDarkestBeige);
        defaults.put(LookAndFeel.SECONDARY_TEXT_HIGHLIGHT, _sDarkBeige);
        defaults.put(LookAndFeel.LIGHT_INTENSITY, _sLightBeige);
        defaults.put(LookAndFeel.VERY_DARK_INTENSITY, _sDarkestBeige);
        defaults.put(LookAndFeel.LIGHT_LOOK, sand);
        defaults.put(LookAndFeel.DARK_LOOK, sand);
        defaults.put(LookAndFeel.VERY_DARK_LOOK, _sDarkestBeige);
        defaults.put(LookAndFeel.DESKTOP, white);
    }

    protected Object[] getColorComponentDefaults(UIDefaults table) {
        Color sand;
        ColorUIResource white = new ColorUIResource(Color.white);
        ColorUIResource black = new ColorUIResource(Color.black);
        Color dialogColor = sand = table.getColor("BrowserLookAndFeel.SAND");
        ColorUIResource buttonColor = new ColorUIResource(new Color(-857480244));
        Object[] defaults = new Object[]{"Panel.background", null, "Button.background", buttonColor, "Button.foreground", table.get("controlText"), "Button.lightBorder", _sTextFieldChoiceHighlightColor, "Button.darkBorder", new Color(-10079488), "ToggleButton.background", buttonColor, "ToggleButton.foreground", table.get("controlText"), "ToggleButton.darkBorder", black, "ToggleButton.lightBorder", white, "RadioButton.background", null, "CheckBox.background", null, "MenuBar.background", white, "Menu.foreground", table.get("controlText"), "Menu.background", white, "MenuItem.background", white, "RadioButtonMenuItem.background", white, "CheckBoxMenuItem.background", white, "Label.background", null, "Label.foreground", table.get("controlText"), "List.selectionBackground", table.get("textHighlight"), "List.selectionForeground", table.get("textHighlightText"), "List.background", table.get("text"), "List.foreground", table.get("textText"), "ComboBox.background", table.get("control"), "ComboBox.foreground", table.get("controlText"), "ComboBox.selectedBackground", table.get("textHighlight"), "ComboBox.selectedForeground", table.get("textHighlightText"), "ComboBox.disabledBackground", table.get("control"), "ComboBox.disabledForeground", table.get("textInactiveText"), "InternalFrame.background", sand, "FileChooser.background", dialogColor, "DesktopIcon.background", table.get("control"), "TextField.caretForeground", table.get("textText"), "TextField.inactiveForeground", table.get("textInactiveText"), "TextField.selectionBackground", table.get("textHighlight"), "TextField.selectionForeground", table.get("textHighlightText"), "TextField.background", table.get("text"), "TextField.foreground", table.get("textText"), "PasswordField.caretForeground", table.get("textText"), "PasswordField.inactiveForeground", table.get("textInactiveText"), "PasswordField.selectionBackground", table.get("textHighlight"), "PasswordField.selectionForeground", table.get("textHighlightText"), "PasswordField.background", table.get("text"), "PasswordField.foreground", table.get("textText"), "TextArea.caretForeground", table.get("textText"), "TextArea.inactiveForeground", table.get("textInactiveText"), "TextArea.selectionBackground", table.get("textHighlight"), "TextArea.selectionForeground", table.get("textHighlightText"), "TextArea.background", table.get("text"), "TextArea.foreground", table.get("textText"), "TextPane.caretForeground", table.get("textText"), "TextPane.inactiveForeground", table.get("textInactiveText"), "TextPane.selectionBackground", table.get("textHighlight"), "TextPane.selectionForeground", table.get("textHighlightText"), "TextPane.background", table.get("text"), "TextPane.foreground", table.get("textText"), "EditorPane.caretForeground", table.get("textText"), "EditorPane.inactiveForeground", table.get("textInactiveText"), "EditorPane.selectionBackground", table.get("textHighlight"), "EditorPane.selectionForeground", table.get("textHighlightText"), "EditorPane.background", table.get("text"), "EditorPane.foreground", table.get("textText"), "ScrollBar.background", table.get("scrollbar"), "ScrollBar.foreground", table.get("controlDkShadow"), "ScrollBar.track", table.get("scrollbar"), "ScrollBar.trackHighlight", table.get("controlDkShadow"), "ScrollBar.thumb", table.get("control"), "ScrollBar.thumbHighlight", table.get("controlHighlight"), "ScrollBar.thumbDarkShadow", table.get("controlDkShadow"), "ScrollBar.thumbLightShadow", table.get("controlShadow"), "TitledBorder.titleColor", black, "TitledBorder.lineColor", _sDarkBlue, "ToolBar.background", sand, "ToolBar.foreground", table.get("controlText"), "ToolBar.dockingColor", table.get("control"), "ToolBar.floatingColor", table.get("control"), "ToolBar.lightBorder", _sDarkBeige, "ToolTip.background", table.get("info"), "ToolTip.foreground", table.get("infoText"), "ScrollPane.background", null, "SplitPane.background", null, "SplitPane.border", null, "Slider.foreground", table.get("controlText"), "Slider.background", null, "Slider.sliderColor", sand, "Tree.background", table.get("text"), "Tree.hash", table.get("controlShadow"), "Tree.textSelectionColor", table.get("textHighlightText"), "Tree.textNonSelectionColor", table.get("textText"), "Tree.borderSelectionColor", table.get("textText"), "Tree.backgroundSelectionColor", table.get("textHighlight"), "Tree.backgroundNonSelectionColor", null, "ProgressBar.foreground", table.get("textHighlight"), "ProgressBar.background", table.get("text"), "ProgressBar.textSelectionColor", table.get("textHighlightText"), "ProgressBar.textNonSelectionColor", table.get("textText"), "TabbedPane.background", sand, "TabbedPane.lightHighlight", _sDarkBlue, "TabbedPane.shadow", _sDarkBlue, "TabbedPane.darkShadow", _sDarkBlue, "TabbedPane.notSelectedColor", _sDarkBeige, "TabbedPane.selectedColor", _sDarkBlue, "TabbedPane.inactiveSelectedColor", _sLightBlue, "TabbedPane.lightBorder", _sDarkBlue, "TabbedPane.normalColor", _sDarkBlue, "TabbedPane.selectedTextColor", white, "TabbedPane.changeCornerColor", Boolean.FALSE, "TabbedPane.cornerPixel", white, "OptionPane.background", dialogColor, "Table.background", table.get("text"), "Table.gridColor", table.get("controlShadow"), "Table.focusCellBackground", table.get("text"), "Table.focusCellForeground", table.get("controlText"), "TableHeader.foreground", _sDarkBlue, "TableHeader.background", _sDarkBeige, "Separator.background", null, "Separator.foreground", table.get("controlShadowDark"), "PopupMenuSeparator.background", white, "PopupMenuSeparator.foreground", table.get(ColorScheme.NORMAL_INTENSITY), "Window.lightBorder", _sDarkBeige, "EWTGrayPane.background", sand, "EWTGrayPane.lightBorder", _sDarkBeige, "EWTDialog.background", dialogColor};
        return defaults;
    }

    protected String[] getSystemColors() {
        String[] fixedSystemColors = new String[]{"textHighlight", "#0000FF", "selectedFocus", "#FFFFFF", "windowBorder", "#000000", "info", "#FFFFCC", "desktop", "#f7f7e7"};
        return fixedSystemColors;
    }

    static {
        _sCurrentScheme = _sDefaultScheme = new BrowserColorScheme();
        _sAvailableSchemes = new BrowserColorScheme[]{_sDefaultScheme};
    }
}

