/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.header;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import oracle.bali.ewt.header.Header;

class AutoScroller
implements ActionListener {
    private static final int _INITIAL_SCROLLING_DELAY = 200;
    private static final int _REPEAT_SCROLLING_DELAY = 100;
    private static AutoScroller _sAutoScroller;
    private Timer _timer = new Timer(200, this);
    private Header _scrollee;
    private boolean _decrease;
    private boolean _cancel;
    private int _newIndex;

    public static AutoScroller getAutoScroller() {
        if (_sAutoScroller == null) {
            _sAutoScroller = new AutoScroller();
        }
        return _sAutoScroller;
    }

    public void schedule(Header scrollee, boolean decrease) {
        this._scrollee = scrollee;
        this._decrease = decrease;
        this._cancel = false;
        this._timer.setDelay(200);
        this._timer.start();
    }

    public void actionPerformed(ActionEvent e) {
        if (this._cancel || this._scrollee == null) {
            return;
        }
        Point origin = this._scrollee.getCanvasOrigin();
        if (this._decrease) {
            int pos = this._scrollee._isHorizontal() ? -origin.x : -origin.y;
            this._newIndex = this._scrollee.getGeometryManager().getItemAt(pos);
            if (this._newIndex != -1) {
                this._newIndex = this._scrollee.getPreviousVisibleItem(this._newIndex);
            }
        } else {
            Dimension size = this._scrollee.getInnerSize();
            int pos = this._scrollee._isHorizontal() ? -origin.x + size.width : -origin.y + size.height;
            this._newIndex = this._scrollee.getGeometryManager().getItemAt(pos);
            if (this._newIndex != -1) {
                this._scrollee.scrollItemIntoView(this._newIndex);
                this._scrollee.growItemSelection(this._newIndex);
                this._newIndex = this._scrollee.getNextVisibleItem(this._newIndex);
            }
        }
        if (this._newIndex == -1) {
            return;
        }
        this._scrollee.scrollItemIntoView(this._newIndex);
        this._timer.setDelay(100);
        this._timer.restart();
    }

    public void cancel() {
        this._cancel = true;
        this._scrollee = null;
        this._timer.stop();
    }

    public void cancel(Header possibleTarget) {
        if (this._scrollee == possibleTarget) {
            this.cancel();
        }
    }

    public Header getScrollee() {
        return this._scrollee;
    }

    protected AutoScroller() {
    }

    protected int getNewIndex() {
        return this._newIndex;
    }

    protected boolean isCancelled() {
        return this._cancel;
    }
}

