/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import oracle.bali.ewt.grid.AbstractGridSelectionManager;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.CellRange;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.share.collection.Range;

public class GeneralGridSelectionManager
extends AbstractGridSelectionManager {
    public static final int NONE = 0;
    public static final int SINGLE = 1;
    public static final int MULTIPLE = 2;
    protected static final int REPLACE = 0;
    protected static final int SUBTRACT = 1;
    protected static final int ADD = 2;
    private TwoDSelection _selection;
    private int _cellConstraint;
    private int _rowConstraint;
    private int _columnConstraint;
    private static GridSelectionManager _nullSelectionManager;

    public GeneralGridSelectionManager() {
        this(1, 1, 1);
    }

    public GeneralGridSelectionManager(int columnConstraint, int rowConstraint, int cellConstraint) {
        this._columnConstraint = columnConstraint;
        this._rowConstraint = rowConstraint;
        this._cellConstraint = cellConstraint;
    }

    public TwoDSelection getSelection() {
        if (this._selection == null) {
            this._selection = TwoDSelection.getEmptySelection();
        }
        return this._selection;
    }

    public void addSelection(TwoDSelection sel) throws PropertyVetoException {
        TwoDSelection sel2 = this._promote(sel);
        this._changeSelection(sel2, 2, false);
    }

    public void removeSelection(TwoDSelection sel) throws PropertyVetoException {
        TwoDSelection sel2 = this._promote(sel);
        this._changeSelection(sel2, 1, false);
    }

    public final void setSelection(TwoDSelection sel) throws PropertyVetoException {
        this.setSelection(sel, null);
    }

    public void setSelection(TwoDSelection sel, Cell fallbackCell) throws PropertyVetoException {
        if (sel == null) {
            sel = TwoDSelection.getEmptySelection();
        }
        TwoDSelection sel2 = this._promote(sel);
        if (fallbackCell == null || this.meetsConstraints(sel2)) {
            this._changeSelection(sel2, 0, false);
        } else {
            this._changeSelection(this._promote(new TwoDSelection(fallbackCell)), 0, false);
        }
    }

    public static GridSelectionManager createSingleColumnSelectionManager() {
        return new GeneralGridSelectionManager(1, 0, 0);
    }

    public static GridSelectionManager createSingleRowSelectionManager() {
        return new GeneralGridSelectionManager(0, 1, 0);
    }

    public static GridSelectionManager createSingleCellSelectionManager() {
        return new GeneralGridSelectionManager(0, 0, 1);
    }

    public static GridSelectionManager createMultipleColumnSelectionManager() {
        return new GeneralGridSelectionManager(2, 0, 0);
    }

    public static GridSelectionManager createMultipleRowSelectionManager() {
        return new GeneralGridSelectionManager(0, 2, 0);
    }

    public static GridSelectionManager createMultipleCellSelectionManager() {
        return new GeneralGridSelectionManager(0, 0, 2);
    }

    public static GridSelectionManager getNullGridSelectionManager() {
        if (_nullSelectionManager == null) {
            _nullSelectionManager = new GeneralGridSelectionManager(0, 0, 0){

                public void addPropertyChangeListener(PropertyChangeListener listener) {
                }

                public void removePropertyChangeListener(PropertyChangeListener listener) {
                }

                public void addVetoableChangeListener(VetoableChangeListener listener) {
                }

                public void removeVetoableChangeListener(VetoableChangeListener listener) {
                }
            };
        }
        return _nullSelectionManager;
    }

    protected TwoDSelection modifySelection(TwoDSelection oldSelection, TwoDSelection newSelection, int how) {
        TwoDSelection result;
        newSelection = this.constrain(newSelection);
        switch (how) {
            case 1: {
                result = oldSelection.subtract(newSelection);
                break;
            }
            case 2: {
                result = this._add(oldSelection, newSelection);
                break;
            }
            case 0: {
                if (this.meetsConstraints(newSelection)) {
                    result = newSelection;
                    break;
                }
                result = oldSelection;
                break;
            }
            default: {
                result = new TwoDSelection();
            }
        }
        return result;
    }

    protected void rowsAdded(int start, int number) {
        TwoDSelection result;
        TwoDSelection sel = this.getSelection();
        if (!sel.equals(result = sel.addRows(start, number))) {
            try {
                this._changeSelection(result, 0, true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    protected void rowsRemoved(int start, int number) {
        TwoDSelection result;
        TwoDSelection sel = this.getSelection();
        if (!sel.equals(result = sel.removeRows(start, number))) {
            try {
                this._changeSelection(result, 0, true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    protected void columnsAdded(int start, int number) {
        TwoDSelection result;
        TwoDSelection sel = this.getSelection();
        if (!sel.equals(result = sel.addColumns(start, number))) {
            try {
                this._changeSelection(result, 0, true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    protected void columnsRemoved(int start, int number) {
        TwoDSelection result;
        TwoDSelection sel = this.getSelection();
        if (!sel.equals(result = sel.removeColumns(start, number))) {
            try {
                this._changeSelection(result, 0, true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private TwoDSelection _promote(TwoDSelection sel) {
        CellRange[] crs = sel.getCellRanges();
        if (this._cellConstraint == 0 && crs != null && crs.length > 0) {
            OneDSelection rowSelection = null;
            OneDSelection columnSelection = null;
            if (this._rowConstraint != 0) {
                rowSelection = new OneDSelection(CellRange.rowRangesFromCellRanges(crs));
            } else if (this._columnConstraint != 0) {
                columnSelection = new OneDSelection(CellRange.columnRangesFromCellRanges(crs));
            }
            if (rowSelection != null) {
                return new TwoDSelection(null, rowSelection);
            }
            if (columnSelection != null) {
                return new TwoDSelection(columnSelection, null);
            }
            return sel;
        }
        return sel;
    }

    protected TwoDSelection constrain(TwoDSelection sel) {
        if (this.meetsConstraints(sel)) {
            return sel;
        }
        CellRange[] crs = sel.getCellRanges();
        OneDSelection rowSel = sel.getRowSelection();
        OneDSelection columnSel = sel.getColumnSelection();
        if (this._cellConstraint == 0) {
            crs = null;
        } else if (this._cellConstraint == 1) {
            if (crs != null && crs.length > 0) {
                CellRange[] newcrs = new CellRange[]{new CellRange(crs[0].getLowerLimit())};
                crs = newcrs;
            } else {
                crs = null;
            }
        }
        if (this._rowConstraint == 0 || rowSel.isEmpty()) {
            rowSel = null;
        } else if (this._rowConstraint == 1) {
            rowSel = new OneDSelection(rowSel.getSingleItem());
        }
        if (this._columnConstraint == 0 || columnSel.isEmpty()) {
            columnSel = null;
        } else if (this._columnConstraint == 1) {
            columnSel = new OneDSelection(columnSel.getSingleItem());
        }
        return new TwoDSelection(columnSel, rowSel, crs);
    }

    private void _changeSelection(TwoDSelection selection, int how, boolean force) throws PropertyVetoException {
        TwoDSelection newSelection;
        TwoDSelection oldSelection = this.getSelection();
        if (oldSelection.equals(newSelection = this.modifySelection(oldSelection, selection, how))) {
            return;
        }
        if (!force) {
            this.fireVetoableChange("selection", oldSelection, newSelection);
        }
        this._selection = newSelection;
        this.firePropertyChange("selection", oldSelection, newSelection);
    }

    private TwoDSelection _add(TwoDSelection original, TwoDSelection sel) {
        CellRange[] cellRanges = null;
        Range[] columnRanges = null;
        Range[] rowRanges = null;
        CellRange[] cr = sel.getCellRanges();
        Range[] colr = sel.getColumnSelection().getRanges();
        Range[] rowr = sel.getRowSelection().getRanges();
        if (cr != null && cr.length > 0) {
            cellRanges = this._addCellRanges(original, sel);
        } else if (colr != null && colr.length > 0) {
            columnRanges = this._addColumnRanges(original, sel);
        } else if (rowr != null && rowr.length > 0) {
            rowRanges = this._addRowRanges(original, sel);
        }
        OneDSelection columnSelection = null;
        OneDSelection rowSelection = null;
        if (columnRanges != null && columnRanges.length > 0) {
            columnSelection = new OneDSelection(columnRanges);
        }
        if (rowRanges != null && rowRanges.length > 0) {
            rowSelection = new OneDSelection(rowRanges);
        }
        return new TwoDSelection(columnSelection, rowSelection, cellRanges);
    }

    private CellRange[] _addCellRanges(TwoDSelection original, TwoDSelection sel) {
        if (this._cellConstraint != 0) {
            CellRange[] cellRanges = sel.getCellRanges();
            CellRange[] myCellRanges = original.getCellRanges();
            if (cellRanges != null && cellRanges.length > 0) {
                if (this._cellConstraint == 1) {
                    CellRange[] newCellRanges = new CellRange[]{cellRanges[0]};
                    return newCellRanges;
                }
                if (this._cellConstraint == 2) {
                    return CellRange.addCellRanges(myCellRanges, cellRanges);
                }
            } else if (myCellRanges != null && myCellRanges.length > 0) {
                return myCellRanges;
            }
        }
        return null;
    }

    private Range[] _addColumnRanges(TwoDSelection original, TwoDSelection sel) {
        if (this._columnConstraint != 0) {
            Range[] columnRanges = sel.getColumnSelection().getRanges();
            Range[] newColumnRanges = null;
            Range[] myColumnRanges = original.getColumnSelection().getRanges();
            if (columnRanges != null && columnRanges.length > 0) {
                if (this._columnConstraint == 1) {
                    newColumnRanges = new Range[]{columnRanges[0]};
                    return newColumnRanges;
                }
                if (this._columnConstraint == 2) {
                    return Range.addRanges((Range[])myColumnRanges, (Range[])columnRanges);
                }
            } else if (myColumnRanges != null && myColumnRanges.length > 0) {
                return myColumnRanges;
            }
        }
        return null;
    }

    private Range[] _addRowRanges(TwoDSelection original, TwoDSelection sel) {
        if (this._rowConstraint != 0) {
            Range[] rowRanges = sel.getRowSelection().getRanges();
            Range[] myRowRanges = original.getRowSelection().getRanges();
            if (rowRanges != null && rowRanges.length > 0) {
                if (this._rowConstraint == 1) {
                    Range[] newRowRanges = new Range[]{rowRanges[0]};
                    return newRowRanges;
                }
                if (this._rowConstraint == 2) {
                    return Range.addRanges((Range[])myRowRanges, (Range[])rowRanges);
                }
            } else if (myRowRanges != null && myRowRanges.length > 0) {
                return myRowRanges;
            }
        }
        return null;
    }

    protected boolean meetsConstraints(TwoDSelection sel) {
        CellRange[] cellRanges = sel.getCellRanges();
        Range[] columnRanges = sel.getColumnSelection().getRanges();
        Range[] rowRanges = sel.getRowSelection().getRanges();
        int cellCount = cellRanges == null || cellRanges.length == 0 ? 0 : (cellRanges.length > 1 ? 2 : (cellRanges[0].getUpperLimit().equals(cellRanges[0].getLowerLimit()) ? 1 : 2));
        int columnCount = columnRanges == null || columnRanges.length == 0 ? 0 : (columnRanges.length > 1 ? 2 : (columnRanges[0].getUpperLimit() == columnRanges[0].getLowerLimit() ? 1 : 2));
        int rowCount = rowRanges == null || rowRanges.length == 0 ? 0 : (rowRanges.length > 1 ? 2 : (rowRanges[0].getUpperLimit() == rowRanges[0].getLowerLimit() ? 1 : 2));
        return cellCount <= this._cellConstraint && columnCount <= this._columnConstraint && rowCount <= this._rowConstraint;
    }
}

