/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.graphics;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import oracle.bali.ewt.graphics.HitTestMask;
import oracle.bali.ewt.graphics.ImageLoader;
import oracle.bali.ewt.graphics.ImageSet;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.graphics.TransparencyTester;

public class SynthesizingImageSet
implements ImageSet {
    private static final int _COMPUTING_TRANSPARENCY = -1;
    private static final int _IS_NOT_TRANSPARENT = 0;
    private static final int _IS_TRANSPARENT = 1;
    private transient boolean _imageLoaded;
    private transient int _width;
    private transient int _height;
    private transient Image[] _images = new Image[64];
    private transient int _isTransparent = -1;
    private transient HitTestMask _hitTester;
    private int _synthMask;

    public SynthesizingImageSet(Image baseImage) {
        this(baseImage, 63);
    }

    public SynthesizingImageSet(Image baseImage, int synthesizableMask) {
        if (baseImage == null) {
            throw new IllegalArgumentException();
        }
        this._images[0] = baseImage;
        this._synthMask = synthesizableMask;
    }

    public Dimension getSize() {
        this._loadImageIfNecessary();
        return new Dimension(this._width, this._height);
    }

    public void paintImage(int imageState, Graphics g, int x, int y, ImageObserver observer) {
        this._loadImageIfNecessary();
        g.drawImage(this._getImage(imageState), x, y, observer);
    }

    public boolean contains(int x, int y) {
        if (x >= 0 && y >= 0 && x < this._width && y < this._height) {
            if (this.isTransparent()) {
                if (this._hitTester == null) {
                    this._hitTester = new HitTestMask(this._images[0]);
                }
                return this._hitTester.contains(x, y);
            }
            return true;
        }
        return false;
    }

    public boolean isTransparent() {
        if (this._isTransparent == -1) {
            TransparencyTester transparencyTester = new TransparencyTester(this._images[0]);
            this._isTransparent = transparencyTester.isTransparent() ? 1 : 0;
        }
        return this._isTransparent != 0;
    }

    public int getAvailableImageFlags() {
        return this._synthMask;
    }

    private Image _getImage(int imageState) {
        Image gotImage = this._images[imageState];
        if (gotImage == null) {
            int synthesizableState = imageState & this._synthMask;
            gotImage = this._images[synthesizableState];
            if (gotImage == null) {
                gotImage = this._images[0];
                if ((synthesizableState & 1) != 0) {
                    gotImage = ImageUtils.createDisabledImage(gotImage);
                }
            }
            this._images[imageState] = gotImage;
        }
        return gotImage;
    }

    private void _loadImageIfNecessary() {
        if (!this._imageLoaded) {
            Image baseImage = this._images[0];
            ImageLoader loader = new ImageLoader(baseImage);
            loader.start();
            this._imageLoaded = loader.waitFor();
            this._width = baseImage.getWidth(loader);
            this._height = baseImage.getHeight(loader);
        }
    }
}

