/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.oracle;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PrintGraphics;
import java.awt.print.PrinterGraphics;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.plaf.ComponentUI;
import oracle.bali.ewt.elaf.EWTPivotGridUI;
import oracle.bali.ewt.elaf.EWTTableUI;
import oracle.bali.ewt.elaf.basic.BasicTableGeometryHelper;
import oracle.bali.ewt.elaf.oracle.OracleEWTTableUI;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.NullPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.table.SpreadTable;

public class OracleEWTPivotGridUI
extends EWTPivotGridUI {
    private static OracleEWTPivotGridUI _sInstance;
    private static OracleEWTTableUI _sTableUI;
    private static Painter[] _sCornerPainters;

    private OracleEWTPivotGridUI() {
    }

    public static ComponentUI createUI(JComponent component) {
        if (_sInstance == null) {
            _sInstance = new OracleEWTPivotGridUI();
            _sTableUI = (OracleEWTTableUI)OracleEWTTableUI.createUI(component);
        }
        return _sInstance;
    }

    public void installUI(JComponent component) {
        LookAndFeel.installColors(component, "EWTPivotGrid.background", "EWTPivotGrid.foreground");
        _sTableUI.installUI(component);
        component.setBorder(null);
        component.setOpaque(true);
    }

    public Painter getCornerPainter(JComponent component, int which) {
        Painter painter = null;
        if (which >= 0 && which <= 3) {
            painter = _sCornerPainters[which];
            if (painter == null) {
                painter = new _CornerP(which);
            }
            OracleEWTPivotGridUI._sCornerPainters[which] = painter;
        }
        if (painter == null) {
            painter = NullPainter.getPainter();
        }
        return painter;
    }

    public void updateGeometry(JComponent component) {
        BasicTableGeometryHelper.updateGeometry((SpreadTable)component);
    }

    static {
        _sCornerPainters = new Painter[4];
    }

    private class _CornerP
    extends AbstractPainter {
        private int _corner;

        public _CornerP(int which) {
            this._corner = which;
        }

        public Dimension getMinimumSize(PaintContext context) {
            return new Dimension(0, 0);
        }

        public int getRepaintFlags(PaintContext context) {
            return 128;
        }

        public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
            boolean raised;
            Object data;
            Color savedColor = g.getColor();
            UIDefaults defaults = context.getPaintUIDefaults();
            int bottom = y + height - 1;
            int right = x + width - 1;
            Color control = defaults.getColor("control");
            Color shadow = defaults.getColor("normalIntensity");
            Color darkShadow = defaults.getColor("EWTPivot.darkShadow");
            g.setColor(control);
            g.fillRect(x, y, width, height);
            int state = context.getPaintState();
            Color borderColor = null;
            if (this._corner == 3 && (state & 1) == 0 && (data = context.getPaintData("table.cornerBorderColor")) instanceof Color) {
                borderColor = (Color)data;
            }
            if (borderColor == null) {
                if ((state & 4) == 0) {
                    g.setColor(darkShadow);
                } else {
                    g.setColor(shadow);
                }
            } else {
                g.setColor(borderColor);
            }
            g.drawLine(x, bottom, right, bottom);
            g.drawLine(right, y, right, bottom);
            data = context.getPaintData(EWTTableUI.KEY_DRAW_RAISED);
            boolean bl = raised = data instanceof Boolean ? (Boolean)data : true;
            if (raised && (state & 4) == 0) {
                g.setColor(Color.white);
                g.drawLine(x, y, x, bottom - 1);
                g.drawLine(x + 1, y, x + 1, bottom - 2);
                g.drawLine(x, y, right - 1, y);
                g.drawLine(x, y + 1, right - 2, y + 1);
                g.drawLine(x, bottom - 2, right - 1, bottom - 2);
                g.drawLine(right - 2, y, right - 2, bottom - 2);
                g.setColor(shadow);
                g.drawLine(x + 1, bottom - 1, right - 1, bottom - 1);
                g.drawLine(right - 1, y + 1, right - 1, bottom - 1);
            } else {
                g.setColor(control);
                g.drawLine(x, y, x, bottom - 1);
                g.drawLine(x, y, right - 1, y);
                if (borderColor == null) {
                    if (g instanceof PrintGraphics || g instanceof PrinterGraphics) {
                        g.setColor(darkShadow);
                    } else {
                        g.setColor(shadow);
                    }
                } else {
                    g.setColor(borderColor);
                }
                g.drawLine(right, y, right, y);
                g.drawLine(x, bottom, x, bottom);
            }
        }
    }
}

