/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.javacompiler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import oracle.jdevimpl.javacompiler.JDevJavaFileManager;
import oracle.jdevimpl.javacompiler.JavaCompilerLog;

class AnnotationProcessorClassLoader
extends ClassLoader {
    private JDevJavaFileManager fileManager;
    private StandardLocation path;
    private String allowedApFileName;
    private Set<String> allowedAps;
    private JavaCompilerLog log;

    AnnotationProcessorClassLoader(JDevJavaFileManager fileManager, StandardLocation path, String allowedApFileName, JavaCompilerLog log) {
        super(fileManager.getJavacClassLoader());
        this.fileManager = fileManager;
        this.path = path;
        this.allowedApFileName = allowedApFileName;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class findClassOnPath(String name) throws IOException {
        Class<?> loadedClass = this.findLoadedClass(name);
        if (loadedClass != null) {
            return loadedClass;
        }
        JavaFileObject classFile = this.fileManager.getJavaFileForInput(this.path, name, JavaFileObject.Kind.CLASS);
        if (classFile != null) {
            InputStream inputStream = null;
            try {
                inputStream = classFile.openInputStream();
                int available = inputStream.available();
                byte[] bytes = new byte[available];
                int read = inputStream.read(bytes);
                if (available != read) {
                    throw new IOException("Incomplete read");
                }
                Class<?> clazz = this.defineClass(name, bytes, 0, bytes.length);
                return clazz;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        return null;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            Class<?> loadedClass = ClassLoader.getSystemClassLoader().loadClass(name);
            if (loadedClass != null) {
                if (resolve) {
                    this.resolveClass(loadedClass);
                }
                return loadedClass;
            }
        }
        catch (ClassNotFoundException loadedClass) {
            // empty catch block
        }
        try {
            Class found = this.findClassOnPath(name);
            if (found != null) {
                if (resolve) {
                    this.resolveClass(found);
                }
                return found;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return super.loadClass(name, resolve);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Vector<URL> resourceList = new Vector<URL>();
        if ((name = name.replace('\\', '/')).endsWith("/")) {
            return resourceList.elements();
        }
        boolean parseAnnotationProcessors = "META-INF/services/javax.annotation.processing.Processor".equals(name);
        int index = name.lastIndexOf(47);
        String packageName = "";
        if (index > 0) {
            packageName = name.substring(0, index);
            packageName = packageName.replace('/', '.');
            name = name.substring(index + 1);
        }
        HashSet<JavaFileObject.Kind> kinds = new HashSet<JavaFileObject.Kind>(1);
        kinds.add(JavaFileObject.Kind.OTHER);
        Iterable<JavaFileObject> resourceIter = this.fileManager.list(this.path, packageName, kinds, false);
        for (JavaFileObject resource : resourceIter) {
            String resourceName = resource.getName();
            if (!name.equals(resourceName)) continue;
            try {
                boolean addUrl = false;
                if (!parseAnnotationProcessors || this.allowedApFileName == null) {
                    addUrl = true;
                } else if (this.hasOnlyAllowedAnnotationProcessors(resource)) {
                    addUrl = true;
                } else {
                    String resourcePath = resource.toUri().getPath();
                    Pattern pattern1 = Pattern.compile("^.*/oracle/built/.*/classes/META-INF/services/javax.annotation.processing.Processor$");
                    Matcher matcher1 = pattern1.matcher(resourcePath);
                    boolean emitWarning = matcher1.matches();
                    if (!emitWarning) {
                        Pattern pattern2 = Pattern.compile("^.*/oracle/jdeveloper/.*/extensions/.*!/META-INF/services/javax.annotation.processing.Processor$");
                        Matcher matcher2 = pattern2.matcher(resourcePath);
                        emitWarning = matcher2.matches();
                    }
                    if (emitWarning) {
                        String msg = resourcePath + " has been ignored because it has annotation processors not listed in " + this.allowedApFileName;
                        if (this.log != null) {
                            this.log.warning(null, 0L, 0L, 0, msg);
                        } else {
                            System.out.println(msg);
                        }
                    }
                }
                if (!addUrl) continue;
                File file = new File(resource.toUri());
                String path = (file = file.getCanonicalFile()).getPath().replace('\\', '/');
                String urlName = path.indexOf("!/") > 0 ? "jar:file:" + path : "file:" + path;
                URL url = new URL(null, urlName, new ApClURLStreamHandler(urlName));
                resourceList.add(url);
            }
            catch (FileNotFoundException fnfe) {}
        }
        return resourceList.elements();
    }

    private boolean hasOnlyAllowedAnnotationProcessors(JavaFileObject resource) {
        List<String> lines;
        if (this.allowedApFileName == null) {
            return true;
        }
        if (this.allowedAps == null) {
            this.initializeAllowedAps();
        }
        if ((lines = this.readProcessorFile(resource)) != null) {
            for (String line : lines) {
                if (this.allowedAps.contains(line)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readProcessorFile(JavaFileObject resource) {
        List<String> lines = null;
        BufferedReader bufferedReader = null;
        InputStreamReader resourceReader = null;
        InputStream resourceInputStream = null;
        try {
            try {
                resourceInputStream = resource.openInputStream();
                resourceReader = new InputStreamReader(resourceInputStream, "UTF-8");
                bufferedReader = new BufferedReader(resourceReader);
                lines = this.readLines(bufferedReader);
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                } else if (resourceReader != null) {
                    resourceReader.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeAllowedAps() {
        block9: {
            assert (this.allowedApFileName != null);
            this.allowedAps = new HashSet<String>();
            try {
                File file = new File(this.allowedApFileName);
                file = file.getCanonicalFile();
                if (!file.exists()) break block9;
                BufferedReader bufferedReader = null;
                FileReader fileReader = null;
                try {
                    fileReader = new FileReader(file);
                    bufferedReader = new BufferedReader(fileReader);
                    this.allowedAps.addAll(this.readLines(bufferedReader));
                }
                finally {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    } else if (fileReader != null) {
                        fileReader.close();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private List<String> readLines(BufferedReader bufferedReader) throws IOException {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = bufferedReader.readLine()) != null) {
            int index = line.indexOf(35);
            if (index >= 0) {
                line = line.substring(0, index);
            }
            if ((line = line.trim()).length() == 0) continue;
            lines.add(line);
        }
        return lines;
    }

    private static class ApClURLStreamHandler
    extends URLStreamHandler {
        String name;

        ApClURLStreamHandler(String name) {
            this.name = name;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            URLConnection connection = new URL(this.name).openConnection();
            connection.setUseCaches(false);
            return connection;
        }
    }
}

