/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.externaltools;

import java.util.Collection;
import oracle.ide.Context;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.extension.rules.RuleEngine;
import oracle.ide.externaltools.ExternalTool;
import oracle.ide.externaltools.ExternalToolScanner;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ModelUtil;

public class LazyScanner
extends ExternalToolScanner {
    private ExternalToolScanner _instance;
    private HashStructure _hash;
    public static final String SHORT_NAME = "name";
    public static final String RULE = "rule";
    public static final String ID = "id";

    public LazyScanner(HashStructure hash) {
        this._hash = hash;
    }

    @Override
    public String getId() {
        return this._hash.getString(ID);
    }

    @Override
    public String getName() {
        return this._hash.getString(SHORT_NAME);
    }

    @Override
    public boolean canScan() {
        String rule = this._hash.getString(RULE);
        if (ModelUtil.hasLength((String)rule)) {
            return RuleEngine.getInstance().evaluateRule(rule, Context.newIdeContext());
        }
        return true;
    }

    @Override
    public ExternalTool[] findTools(Collection<ExternalTool> existingTools) {
        ExternalToolScanner scanner = this.getInstance();
        if (scanner == null) {
            return new ExternalTool[0];
        }
        return scanner.findTools(existingTools);
    }

    public String toString() {
        return this.getName();
    }

    private ExternalToolScanner getInstance() {
        if (this._instance == null) {
            this._instance = (ExternalToolScanner)LazyClassAdapter.getInstance((HashStructure)this._hash).createInstance(ExternalToolScanner.class, "#text");
        }
        return this._instance;
    }

    public HashStructure getHashStructure() {
        return this._hash;
    }
}

