/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.externaltools.macro;

import java.io.File;
import java.util.ArrayList;
import oracle.ide.externaltools.ExternalToolType;
import oracle.ide.externaltools.macro.MacroExpander;
import oracle.ide.externaltools.macro.MacroFieldInsightProvider;
import oracle.ide.externaltools.macro.MacroRegistry;
import oracle.ide.externaltools.macro.ParameterizedMacro;
import oracle.javatools.controls.completionfield.CompletionTextField;
import oracle.javatools.controls.completionfield.FieldInsightProvider;
import oracle.javatools.controls.completionfield.FileSystemFieldInsightProvider;
import oracle.javatools.util.Pair;

public class MacroTextField
extends CompletionTextField {
    private boolean _validateFile = false;
    private boolean _validateDirectory = false;
    private transient MacroRegistry _registry;
    private int[][] _invalidRanges = null;

    public MacroTextField() {
    }

    public MacroTextField(boolean validateDirectory, boolean validateFile) {
        this._validateFile = validateFile;
        this._validateDirectory = validateDirectory;
    }

    public void configure(MacroRegistry registry, ExternalToolType type, boolean onlyDirectories) {
        this._registry = registry;
        this.getPopupHandler().registerInsightProvider((FieldInsightProvider)new MacroFieldInsightProvider(registry, type, onlyDirectories));
        this.getPopupHandler().registerInsightProvider((FieldInsightProvider)new FileSystemFieldInsightProvider(onlyDirectories));
        this.getPopupHandler().setAlignWithField(true);
    }

    protected boolean isTextValid() {
        this._invalidRanges = null;
        boolean LOOKING_FOR_DOLLAR = false;
        boolean LOOKING_FOR_OPEN_BRACE = true;
        int LOOKING_FOR_CLOSE_BRACE_OR_COLON = 2;
        int LOOKING_FOR_EQUALS = 3;
        int LOOKING_FOR_CLOSE_BRACE = 4;
        int mode = 0;
        String text = this.getText();
        ArrayList<Pair> badRanges = new ArrayList<Pair>();
        int lastStart = -1;
        MacroExpander macro = null;
        boolean foundMacros = false;
        block7: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (mode) {
                case 0: {
                    if (c != '$') continue block7;
                    lastStart = i + 1;
                    mode = 1;
                    continue block7;
                }
                case 1: {
                    if (c != '{') continue block7;
                    lastStart = i + 1;
                    mode = 2;
                    continue block7;
                }
                case 2: {
                    if (c == '}' || c == ':') {
                        String macroText = text.substring(lastStart, i);
                        macro = this._registry.findMacro(macroText);
                        if (macro == null) {
                            badRanges.add(new Pair((Object)lastStart, (Object)(i - 1)));
                        }
                        foundMacros = true;
                        lastStart = i + 1;
                    }
                    if (c == '}') {
                        mode = 0;
                        continue block7;
                    }
                    if (c != ':') continue block7;
                    mode = 3;
                    continue block7;
                }
                case 3: {
                    if (c != '=') continue block7;
                    String parameterName = text.substring(lastStart, i);
                    if (macro == null || !(macro instanceof ParameterizedMacro)) {
                        badRanges.add(new Pair((Object)lastStart, (Object)(i - 1)));
                    } else {
                        ParameterizedMacro pm = (ParameterizedMacro)macro;
                        if (pm.findParameter(parameterName) == null) {
                            badRanges.add(new Pair((Object)lastStart, (Object)(i - 1)));
                        }
                    }
                    lastStart = i + 1;
                    mode = 4;
                    continue block7;
                }
                case 4: {
                    if (c == '}') {
                        mode = 0;
                    }
                    lastStart = i + 1;
                }
            }
        }
        if (mode != 0) {
            badRanges.add(new Pair((Object)lastStart, (Object)(text.length() - 1)));
        }
        if (foundMacros && badRanges.size() > 0) {
            int[][] ranges = new int[badRanges.size()][2];
            for (int i = 0; i < badRanges.size(); ++i) {
                ranges[i][0] = (Integer)((Pair)badRanges.get(i)).getFirst();
                ranges[i][1] = (Integer)((Pair)badRanges.get(i)).getSecond();
            }
            this._invalidRanges = ranges;
            return false;
        }
        if (!foundMacros && (this._validateFile || this._validateDirectory)) {
            text = text.trim();
            File f = new File(text);
            if (this._validateFile && this._validateDirectory) {
                return f.exists();
            }
            if (this._validateDirectory) {
                return f.isDirectory();
            }
            if (this._validateFile) {
                return f.isFile();
            }
        }
        return true;
    }

    protected int[][] getInvalidCharacterRanges() {
        if (this._invalidRanges == null) {
            return super.getInvalidCharacterRanges();
        }
        return this._invalidRanges;
    }
}

