/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.rest.connection.RestDownload;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestSecurity;

public class RestCache {
    private static final RestCache INSTANCE = new RestCache();
    private Map<String, RestModule> _moduleMap = null;
    private Map<String, RestSecurity> _privilegeMap = null;

    public static RestCache getInstance() {
        return INSTANCE;
    }

    private RestCache() {
    }

    public boolean containsModule(String string) {
        if (this._moduleMap == null) {
            this.downloadModules();
        }
        return this._moduleMap.containsKey(string);
    }

    public RestModule getModule(String string) {
        if (string != null && this._moduleMap != null) {
            return this._moduleMap.get(string);
        }
        return null;
    }

    public boolean containsPrivilege(String string) {
        if (this._privilegeMap == null) {
            this.downloadPrivileges();
        }
        return this._privilegeMap.containsKey(string);
    }

    public RestSecurity getPrivilege(String string) {
        if (string != null && this._privilegeMap != null) {
            return this._privilegeMap.get(string);
        }
        return null;
    }

    public void resetCache() {
        this._moduleMap = null;
        this._privilegeMap = null;
    }

    private void downloadModules() {
        if (this._moduleMap == null) {
            this._moduleMap = new HashMap<String, RestModule>();
        } else {
            this._moduleMap.clear();
        }
        List<RestModule> list = new RestDownload().downloadModules();
        if (list != null) {
            for (RestModule restModule : list) {
                this._moduleMap.put(restModule.getName(), restModule);
            }
        }
    }

    private void downloadPrivileges() {
        if (this._privilegeMap == null) {
            this._privilegeMap = new HashMap<String, RestSecurity>();
        } else {
            this._privilegeMap.clear();
        }
        List<RestSecurity> list = new RestDownload().downloadPrivileges();
        if (list != null) {
            for (RestSecurity restSecurity : list) {
                this._privilegeMap.put(restSecurity.getName(), restSecurity);
            }
        }
    }
}

