/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.ui.RestTablePanel;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.ide.util.ResourceUtils;

public class RestModulePanel
extends JPanel {
    private static final int MIN_SIZE = 0;
    private static final int MAX_SIZE = 10000;
    private static final int DEFAULT_PAGINATION_SIZE = 25;
    private List<String> _existingNames;
    private JTextField _name;
    private JTextField _uriPrefix;
    private JLabel _modURIExample;
    private JCheckBox _publish;
    private JComboBox _privilege;
    private NumericSpinBox _pagination;
    private RestTablePanel _origins;
    private RestModule _module;
    private List<String> _errMsg;

    public RestModulePanel() {
        this.createPanel();
    }

    public RestModulePanel(RestModule restModule) {
        this._module = restModule;
        this.createPanel();
    }

    private void initializeComponents() {
        this._name = new JTextField();
        this._uriPrefix = new JTextField();
        this._modURIExample = new JLabel();
        Font font = this._modURIExample.getFont();
        this._modURIExample.setFont(font.deriveFont(font.getStyle() | 1, font.getSize()));
        this._publish = new JCheckBox();
        this._privilege = new JComboBox();
        List<String> list = RestUtils.getPrivilegeNames(null);
        if (list != null && list.isEmpty()) {
            list.add(0, RestArb.getString("SELECT_PRIVILEGE"));
        }
        this._pagination = new NumericSpinBox(0, 10000);
        if (this._module != null) {
            this._name.setText(this._module.getName());
            this._uriPrefix.setText(this._module.getURIPrefix());
            String string = this._uriPrefix.getText();
            if (!RestUtils.emptyValue(string) && !string.startsWith("/")) {
                string = "/" + string;
            }
            this._modURIExample.setText(string);
            this._publish.setSelected(this._module.isPublished());
            if (this._module.getPaginationSize() == 0L && this._module.getURL() == null) {
                this._pagination.setValue((Number)25);
            } else {
                this._pagination.setValue((Number)this._module.getPaginationSize());
            }
        } else {
            this._pagination.setValue((Number)25);
        }
        this._origins = new RestTablePanel(RestArb.getString("ORIGINS_ALLOWED"), null, this._module != null ? this._module.getOrigins() : null);
        this._name.requestFocusInWindow();
    }

    private void createPanel() {
        this.initializeComponents();
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel(RestArb.getString("URI_EXAMPLE_LABEL"));
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        JLabel jLabel6 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._name, (String)RestArb.getString("MODULE_NAME"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._uriPrefix, (String)RestArb.getString("URI_PREFIX"));
        ResourceUtils.resLabel((JLabel)jLabel5, (Component)this._privilege, (String)RestArb.getString("REQUIRED_PRIVILEGES"));
        ResourceUtils.resLabel((JLabel)jLabel6, (Component)this._pagination, (String)RestArb.getString("PAGINATION_SIZE"));
        ResourceUtils.resButton((AbstractButton)this._publish, (String)RestArb.getString("PUBLISH"));
        URI uRI = RestUtils.getBaseURI();
        String string = "";
        if (uRI != null) {
            string = uRI.toString();
            string = string.substring(0, string.length() - 1);
        } else {
            string = RestArb.getString("HTTP_EXAMPLE_HOST_PORT");
        }
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this._modURIExample, (String)string);
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 0, 0, 6), 0, 0));
        jPanel.add((Component)this._name, new GridBagConstraints(1, n, 1, 1, 1.0, 0.5, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        n = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jLabel2, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 8, 6), 0, 0));
        jPanel2.add((Component)this._uriPrefix, new GridBagConstraints(1, n, 2, 1, 0.5, 1.0, 23, 2, new Insets(8, 0, 8, 8), 0, 0));
        jPanel2.add((Component)jLabel3, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(4, 8, 8, 6), 0, 0));
        jPanel2.add((Component)jLabel4, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(4, 0, 8, 0), 0, 0));
        jPanel2.add((Component)this._modURIExample, new GridBagConstraints(2, n, 1, 1, 0.5, 1.0, 23, 2, new Insets(4, 0, 8, 8), 0, 0));
        UIUtils.makeTitledBorder((JComponent)jPanel2, (String)RestArb.getString("URI_TITLE"));
        n = 0;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)jLabel6, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 0, 8, 6), 0, 0));
        jPanel3.add((Component)this._pagination, new GridBagConstraints(1, n, 1, 1, 1.0, 0.5, 23, 0, new Insets(8, 0, 8, 8), 0, 0));
        n = 0;
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.add((Component)jPanel, new GridBagConstraints(0, n, 2, 1, 1.0, 0.5, 23, 2, new Insets(8, 8, 8, 8), 0, 0));
        jPanel4.add((Component)jPanel2, new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.5, 23, 2, new Insets(8, 8, 8, 8), 0, 0));
        jPanel4.add((Component)this._publish, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 0, 8), 0, 0));
        jPanel4.add((Component)jPanel3, new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.5, 23, 2, new Insets(8, 8, 0, 8), 0, 0));
        n = 0;
        JPanel jPanel5 = new JPanel(new GridBagLayout());
        jPanel5.add((Component)this._origins, new GridBagConstraints(0, ++n, 1, 6, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel5.add(Box.createGlue(), new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        n = 0;
        this.add((Component)jPanel4, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.1, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jPanel5, new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 23, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addListeners();
    }

    public void addListeners() {
        if (this._uriPrefix != null && this._uriPrefix.getKeyListeners().length == 0) {
            this._uriPrefix.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    String string = RestModulePanel.this._uriPrefix.getText();
                    if (string != null && !string.isEmpty() && !string.startsWith("/")) {
                        string = "/" + string;
                    }
                    RestModulePanel.this._modURIExample.setText(string);
                }
            });
        }
    }

    public void removeListeners() {
        if (this._uriPrefix != null) {
            KeyListener[] keyListenerArray;
            for (KeyListener keyListener : keyListenerArray = this._uriPrefix.getKeyListeners()) {
                this._uriPrefix.removeKeyListener(keyListener);
            }
        }
    }

    public boolean validInfo() {
        if (this._errMsg == null) {
            this._errMsg = new ArrayList<String>();
        } else {
            this._errMsg.clear();
        }
        boolean bl = false;
        boolean bl2 = false;
        String string = this._name.getText();
        String string2 = this._uriPrefix.getText();
        if (RestUtils.emptyValue(string)) {
            this.setErrorMessage(RestArb.format("VALUE_REQUIRED", RestArb.getString("LABEL_MODULE_NAME")));
        } else if (this.isExistModuleName(string)) {
            this.setErrorMessage(RestArb.format("VALUE_ALREADY_EXIST", RestArb.getString("LABEL_MODULE_NAME")));
        }
        if (this._errMsg.size() > 0) {
            bl = true;
        }
        try {
            new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.setErrorMessage(RestArb.format("URI_SYNTAX_ERROR", RestArb.getString("LABEL_URI_PREFIX")));
            bl2 = true;
        }
        if (this._errMsg.size() > 0) {
            if (bl) {
                this._name.requestFocusInWindow();
            } else if (bl2) {
                this._uriPrefix.requestFocusInWindow();
            }
        }
        return this._errMsg.size() == 0;
    }

    public RestModule getValues() {
        if (this._module == null) {
            this._module = new RestModule();
        }
        String string = this._name.getText() != null ? this._name.getText().trim() : "";
        this._module.setName(string);
        String string2 = this._uriPrefix.getText() != null ? this._uriPrefix.getText().trim() : "";
        this._module.setURIPrefix(string2);
        this._module.setPublished(this._publish.isSelected());
        this._module.setPaginationSize(this._pagination.getIntValue());
        this._module.setPrivilege((String)this._privilege.getSelectedItem());
        this._module.setOrigins(this._origins.getValues());
        return this._module;
    }

    public String getErrorMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this._errMsg) {
            stringBuffer.append(string).append("\n");
        }
        return stringBuffer.toString();
    }

    private void setErrorMessage(String string) {
        if (this._errMsg == null) {
            this._errMsg = new ArrayList<String>();
        }
        this._errMsg.add(string);
    }

    public void setExistingNames(List<String> list) {
        this._existingNames = list;
    }

    public boolean isExistModuleName(String string) {
        if (this._existingNames == null || this._existingNames.isEmpty()) {
            return false;
        }
        return this._existingNames.contains(string);
    }
}

