/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.navigator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestResourceHandler;
import oracle.dbtools.rest.model.RestSecurity;
import oracle.dbtools.rest.model.RestTemplate;
import oracle.dbtools.rest.navigator.RestFolder;
import oracle.dbtools.rest.navigator.RestHandlerNode;
import oracle.dbtools.rest.navigator.RestModuleFolder;
import oracle.dbtools.rest.navigator.RestModuleNode;
import oracle.dbtools.rest.navigator.RestSecurityFolder;
import oracle.dbtools.rest.navigator.RestSecurityNode;
import oracle.dbtools.rest.navigator.RestTemplateNode;
import oracle.dbtools.util.Logger;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;

public class RestRoot
extends DefaultContainer {
    private static RestRoot INSTANCE;
    private boolean _initialize = false;
    private List<String> _roles;
    private List<String> _schemas;

    public static synchronized RestRoot getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RestRoot();
        }
        return INSTANCE;
    }

    private RestRoot() {
    }

    public void newRestfulServices() {
        this.initializeRoot();
    }

    public List<RestModule> getModules() {
        Iterator iterator;
        ArrayList<RestModule> arrayList = new ArrayList<RestModule>();
        RestModuleFolder restModuleFolder = this.getModuleFolder();
        if (restModuleFolder != null && (iterator = restModuleFolder.getChildren()) != null) {
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                RestModule restModule = ((RestModuleNode)((Object)iterator2.next())).getModule();
                arrayList.add(restModule);
            }
        }
        return arrayList;
    }

    public List<RestSecurity> getPrivileges() {
        Iterator iterator;
        ArrayList<RestSecurity> arrayList = new ArrayList<RestSecurity>();
        RestSecurityFolder restSecurityFolder = this.getPrivilegeFolder();
        if (restSecurityFolder != null && (iterator = restSecurityFolder.getChildren()) != null) {
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                RestSecurity restSecurity = ((RestSecurityNode)((Object)iterator2.next())).getSecurity();
                arrayList.add(restSecurity);
            }
        }
        return arrayList;
    }

    public List<String> getRoles() {
        return this._roles;
    }

    public List<String> getSchemas() {
        return this._schemas;
    }

    private void initializeRoot() {
        this._initialize = true;
        this.openImpl();
    }

    protected void openImpl() {
        if (!this._initialize) {
            return;
        }
        this.loadRESTfulServices(null, null);
    }

    private void loadRESTfulServices(List<RestModule> list, List<RestSecurity> list2) {
        final RestRoot restRoot = this;
        final List<RestModule> list3 = list;
        final List<RestSecurity> list4 = list2;
        RaptorTask<List<Element>> raptorTask = new RaptorTask<List<Element>>("LoadRest", true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected List<Element> doWork() {
                ArrayList<Element> arrayList = new ArrayList<Element>();
                try {
                    RestModuleFolder restModuleFolder = new RestModuleFolder(RestArb.getString("MODULES_FOLDER"), RestArb.getString("MODULES_FOLDER"), RestArb.getIcon("MODULE_FOLDER_ICON"));
                    restModuleFolder.setURL(URLFactory.newURL((String)"sqldev.rest", (String)RestArb.getString("MODULES_FOLDER")));
                    if (list3 != null && !list3.isEmpty()) {
                        RestRoot.this.loadRestModules(restModuleFolder, list3);
                    }
                    RestSecurityFolder restSecurityFolder = new RestSecurityFolder(RestArb.getString("PRIVILEGES_FOLDER"), RestArb.getString("PRIVILEGES_FOLDER"), RestArb.getIcon("PRIVILEGE_FOLDER_ICON"));
                    restSecurityFolder.setURL(URLFactory.newURL((String)"sqldev.rest", (String)RestArb.getString("PRIVILEGES_FOLDER")));
                    if (list4 != null && !list4.isEmpty()) {
                        RestRoot.this.loadRestPrivileges(restSecurityFolder, list4);
                    }
                    arrayList.add((Element)restModuleFolder);
                    arrayList.add((Element)restSecurityFolder);
                }
                catch (Exception exception) {
                    Logger.warn(RestRoot.class, (String)exception.getMessage());
                }
                return arrayList;
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter((RaptorTask)raptorTask){
            final /* synthetic */ RaptorTask val$task;
            {
                this.val$task = raptorTask;
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                super.taskCancelled(raptorTaskEvent);
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                super.taskFailed(raptorTaskEvent);
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            List list;
                            if (restRoot.size() > 0) {
                                restRoot.removeAll(true);
                                UpdateMessage.fireStructureChanged((Subject)restRoot);
                            }
                            if ((list = (List)val$task.getResult()) != null) {
                                for (Element element : list) {
                                    restRoot.add(element);
                                }
                                UpdateMessage.fireChildrenAdded((Subject)restRoot, (Collection)list);
                                restRoot.markDirty(false);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            Logger.warn(RestRoot.class, (String)interruptedException.getMessage());
                        }
                        catch (ExecutionException executionException) {
                            Logger.warn(RestRoot.class, (String)executionException.getMessage());
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    try {
                        SwingUtilities.invokeLater(runnable);
                    }
                    catch (Exception exception) {
                        Logger.warn(RestRoot.class, (String)exception.getMessage());
                    }
                }
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    public void closeImpl() {
        this.removeAll();
    }

    public String getShortLabel() {
        return RestArb.getString("REST_ROOT_NODE");
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public Icon getIcon() {
        return RestArb.getIcon("REST_ICON");
    }

    public String getToolTipText() {
        return RestArb.getString("REST_TOOLTIP");
    }

    public void loadData(List<RestModule> list, List<RestSecurity> list2) {
        this.loadRESTfulServices(list, list2);
    }

    public void loadRoles(List<String> list) {
        this._roles = list;
    }

    public void loadSchemas(List<String> list) {
        this._schemas = list;
    }

    public RestModuleNode createModuleNode(RestModule restModule) {
        return this.createModuleNode(this.getModuleFolder(), restModule);
    }

    private RestModuleFolder getModuleFolder() {
        RestModuleFolder restModuleFolder = null;
        Iterator iterator = this.getChildren();
        if (iterator != null) {
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                RestFolder restFolder = (RestFolder)((Object)iterator2.next());
                if (!(restFolder instanceof RestModuleFolder)) continue;
                restModuleFolder = (RestModuleFolder)restFolder;
                break;
            }
        }
        return restModuleFolder;
    }

    private RestSecurityFolder getPrivilegeFolder() {
        RestSecurityFolder restSecurityFolder = null;
        Iterator iterator = this.getChildren();
        if (iterator != null) {
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                RestFolder restFolder = (RestFolder)((Object)iterator2.next());
                if (!(restFolder instanceof RestSecurityFolder)) continue;
                restSecurityFolder = (RestSecurityFolder)restFolder;
                break;
            }
        }
        return restSecurityFolder;
    }

    private void loadRestModules(RestModuleFolder restModuleFolder, List<RestModule> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (RestModule restModule : list) {
            this.createModuleNode(restModuleFolder, restModule);
        }
    }

    private RestModuleNode createModuleNode(RestModuleFolder restModuleFolder, RestModule restModule) {
        RestModuleNode restModuleNode = new RestModuleNode(restModule);
        this.addChildNode(restModuleFolder, restModuleNode, restModule.getName());
        List<RestTemplate> list = restModule.getTemplates();
        if (list != null && !list.isEmpty()) {
            for (RestTemplate restTemplate : list) {
                RestTemplateNode restTemplateNode = new RestTemplateNode(restTemplate);
                restTemplateNode.setParentURIPrefix(restModule.getURIPrefix());
                this.addChildNode(restModuleNode, restTemplateNode, restTemplate.getURIPattern());
                HashMap<RestResourceHandler.HTTP_METHOD_TYPE, RestResourceHandler> hashMap = restTemplate.getResourceHandlers();
                if (hashMap == null || hashMap.isEmpty()) continue;
                for (RestResourceHandler.HTTP_METHOD_TYPE hTTP_METHOD_TYPE : hashMap.keySet()) {
                    RestResourceHandler restResourceHandler = hashMap.get((Object)hTTP_METHOD_TYPE);
                    if (restResourceHandler == null) continue;
                    RestHandlerNode restHandlerNode = new RestHandlerNode(restResourceHandler);
                    restHandlerNode.setTemplateURI(restTemplate.getURIPattern());
                    restHandlerNode.setModuleURI(restTemplateNode.getParentURIPrefix());
                    this.addChildNode(restTemplateNode, restHandlerNode, restHandlerNode.getShortLabel());
                }
            }
        }
        return restModuleNode;
    }

    private void loadRestPrivileges(RestSecurityFolder restSecurityFolder, List<RestSecurity> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (RestSecurity restSecurity : list) {
            RestSecurityNode restSecurityNode = new RestSecurityNode(restSecurity);
            this.addChildNode(restSecurityFolder, restSecurityNode, restSecurity.getName());
        }
    }

    private void addChildNode(RestFolder restFolder, RestFolder restFolder2, String string) {
        try {
            restFolder2.setURL(new URL(restFolder.getURL() + "/" + string));
            restFolder.add((Element)restFolder2);
            restFolder.markDirty(false);
        }
        catch (Exception exception) {
            Logger.warn(RestRoot.class, (String)exception.getMessage());
        }
    }
}

