/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.connection;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.plugin.api.json.objects.JSONArray;
import oracle.dbtools.plugin.api.json.objects.JSONNode;
import oracle.dbtools.plugin.api.json.objects.JSONObject;
import oracle.dbtools.raptor.cloud.connection.JSONNodeHandler;
import oracle.dbtools.raptor.cloud.connection.JSONUtils;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.connection.RestConnErrorDialog;
import oracle.dbtools.rest.connection.RestConnection;
import oracle.dbtools.rest.connection.RestXMLResponseHandler;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestSecurity;
import oracle.dbtools.rest.utils.RestJSONUtil;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.dbtools.rest.utils.RestXMLUtil;
import oracle.dbtools.util.Logger;
import org.apache.http.client.ResponseHandler;

public class RestDownload {
    private static final String FILTER_PRIVILEGE = "oracle.dbtools.sqldev";

    public static boolean downloadRestAdmin() {
        return new RestDownload().downloadAdmin();
    }

    public static RestModule downloadModule(RestModule restModule) {
        if (restModule != null && restModule.getURL() != null) {
            return new RestDownload().downloadModule(restModule.getURL());
        }
        return null;
    }

    public static RestSecurity downloadPrivilege(RestSecurity restSecurity) {
        if (restSecurity != null && restSecurity.getURL() != null) {
            return new RestDownload().downloadPrivilege(restSecurity.getURL());
        }
        return null;
    }

    private boolean downloadAdmin() {
        if (RestConnection.getInstance().isConnectionOpen()) {
            try {
                List<RestModule> list = this.downloadModules();
                List<RestSecurity> list2 = this.downloadPrivileges();
                List<String> list3 = this.downloadRoles();
                RestUtils.loadAdmin(list, list2);
                RestUtils.loadRoles(list3);
                return true;
            }
            catch (Exception exception) {
                Logger.warn(RestDownload.class, (String)exception.getMessage());
            }
        } else {
            String string = RestArb.getString("ERROR_RETRIEVE_REST").concat(System.getProperty("line.separator")).concat(RestConnection.getInstance().getConnectionError());
            RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), string);
        }
        return false;
    }

    public List<RestModule> downloadModules() {
        List<String> list = this.downloadModulesURL();
        if (list != null && !list.isEmpty()) {
            ArrayList<RestModule> arrayList = new ArrayList<RestModule>();
            for (String string : list) {
                RestModule restModule = this.downloadModule(string);
                if (restModule == null) continue;
                arrayList.add(restModule);
            }
            return arrayList;
        }
        return null;
    }

    public List<RestSecurity> downloadPrivileges() {
        List<String> list = this.downloadPrivilegesURL();
        if (list != null && !list.isEmpty()) {
            ArrayList<RestSecurity> arrayList = new ArrayList<RestSecurity>();
            for (String string : list) {
                RestSecurity restSecurity = this.downloadPrivilege(string);
                if (restSecurity == null) continue;
                arrayList.add(restSecurity);
            }
            return arrayList;
        }
        return null;
    }

    private List<String> downloadModulesURL() {
        if (RestConnection.getInstance().isConnectionOpen()) {
            try {
                List list = (List)RestConnection.getInstance().getConnection().executeQuery("/rt/modules/", (ResponseHandler)new JSONNodeHandler<List<String>>(){

                    protected List<String> build(JSONNode jSONNode) throws IOException {
                        JSONObject jSONObject = (JSONObject)jSONNode;
                        ArrayList<String> arrayList = new ArrayList<String>();
                        try {
                            JSONArray jSONArray = (JSONArray)JSONUtils.getValue((JSONObject)jSONObject, (String)"items");
                            for (Object t : jSONArray.values()) {
                                JSONObject jSONObject2 = (JSONObject)t;
                                JSONObject jSONObject3 = (JSONObject)JSONUtils.getValue((JSONObject)jSONObject2, (String)"uri");
                                this.checkJSONElement(jSONObject3, "uri");
                                String string = (String)JSONUtils.getValue((JSONObject)jSONObject3, (String)"$ref");
                                this.checkJSONElement(string, "$ref");
                                String string2 = (String)JSONUtils.getValue((JSONObject)jSONObject2, (String)"title");
                                this.checkJSONElement(string2, "title");
                                arrayList.add(string);
                            }
                            return arrayList;
                        }
                        catch (Exception exception) {
                            RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), RestArb.getString("ERROR_RETRIEVE_REST"), exception);
                            Logger.warn(RestDownload.class, (String)exception.getMessage());
                            return null;
                        }
                    }
                });
                return list;
            }
            catch (Exception exception) {
                RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), RestArb.getString("ERROR_RETRIEVE_REST"), exception);
                Logger.warn(RestDownload.class, (String)exception.getMessage());
            }
        }
        return null;
    }

    private RestModule downloadModule(final String string) {
        if (string == null) {
            return null;
        }
        if (RestConnection.getInstance().isConnectionOpen()) {
            try {
                RestModule restModule = (RestModule)RestConnection.getInstance().getConnection().executeQuery(new URI(string), (ResponseHandler)new RestXMLResponseHandler<RestModule>(){

                    @Override
                    protected RestModule load(InputStream inputStream) throws IOException {
                        RestModule restModule = null;
                        try {
                            restModule = RestXMLUtil.getModule(inputStream, this.getCharacterSetName());
                            if (restModule != null) {
                                restModule.setURL(string);
                                restModule.setEntityTag(this.getEntityTag());
                            }
                        }
                        catch (Exception exception) {
                            RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), RestArb.format("ERROR_RETRIEVE", RestArb.getString("LABEL_MODULE")), exception);
                            Logger.warn(RestDownload.class, (String)(RestArb.format("ERROR_RETRIEVE", RestArb.getString("LABEL_MODULE")) + "\n" + string + "\n" + exception.getMessage()));
                        }
                        return restModule;
                    }
                });
                return restModule;
            }
            catch (Exception exception) {
                RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), RestArb.format("ERROR_RETRIEVE", RestArb.getString("LABEL_MODULE")), exception);
                Logger.warn(RestDownload.class, (String)(RestArb.format("ERROR_RETRIEVE", RestArb.getString("LABEL_MODULE")) + "\n" + string + "\n" + exception.getMessage()));
            }
        } else {
            String string2 = RestArb.format("ERROR_RETRIEVE", RestArb.getString("LABEL_MODULE")).concat(System.getProperty("line.separator")).concat(RestConnection.getInstance().getConnectionError());
            RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), string2);
        }
        return null;
    }

    private List<String> downloadPrivilegesURL() {
        if (RestConnection.getInstance().isConnectionOpen()) {
            try {
                List list = (List)RestConnection.getInstance().getConnection().executeQuery("/oauth2/scopes/", (ResponseHandler)new JSONNodeHandler<List<String>>(){

                    protected List<String> build(JSONNode jSONNode) throws IOException {
                        JSONObject jSONObject = (JSONObject)jSONNode;
                        ArrayList<String> arrayList = new ArrayList<String>();
                        try {
                            JSONArray jSONArray = (JSONArray)JSONUtils.getValue((JSONObject)jSONObject, (String)"items");
                            for (Object t : jSONArray.values()) {
                                JSONObject jSONObject2 = (JSONObject)t;
                                JSONObject jSONObject3 = (JSONObject)JSONUtils.getValue((JSONObject)jSONObject2, (String)"uri");
                                this.checkJSONElement(jSONObject3, "uri");
                                String string = (String)JSONUtils.getValue((JSONObject)jSONObject3, (String)"$ref");
                                this.checkJSONElement(string, "$ref");
                                String string2 = (String)JSONUtils.getValue((JSONObject)jSONObject2, (String)"name");
                                this.checkJSONElement(string2, "name");
                                if (string2.equalsIgnoreCase(RestDownload.FILTER_PRIVILEGE)) continue;
                                arrayList.add(string);
                            }
                            return arrayList;
                        }
                        catch (Exception exception) {
                            RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), RestArb.getString("ERROR_RETRIEVE_REST"), exception);
                            Logger.warn(RestDownload.class, (String)exception.getMessage());
                            return null;
                        }
                    }
                });
                return list;
            }
            catch (Exception exception) {
                RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), RestArb.getString("ERROR_RETRIEVE_REST"), exception);
                Logger.warn(RestDownload.class, (String)exception.getMessage());
            }
        }
        return null;
    }

    private RestSecurity downloadPrivilege(final String string) {
        if (string == null || RestUtils.emptyValue(string)) {
            Logger.warn(RestDownload.class, (String)"Privilege URL is null");
            return null;
        }
        if (RestConnection.getInstance().isConnectionOpen()) {
            try {
                RestSecurity restSecurity = (RestSecurity)RestConnection.getInstance().getConnection().executeQuery(new URI(string), (ResponseHandler)new JSONNodeHandler<RestSecurity>(){

                    protected RestSecurity build(JSONNode jSONNode) throws IOException {
                        try {
                            JSONObject jSONObject = (JSONObject)jSONNode;
                            RestSecurity restSecurity = RestJSONUtil.getPrivilege(jSONObject);
                            restSecurity.setEntityTag(this.getEntityTag());
                            restSecurity.setURL(string);
                            return restSecurity;
                        }
                        catch (Exception exception) {
                            RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), RestArb.format("ERROR_RETRIEVE", RestArb.getString("LABEL_PRIVILEGE")), exception);
                            Logger.warn(RestDownload.class, (String)(RestArb.format("ERROR_RETRIEVE", RestArb.getString("LABEL_PRIVILEGE")) + "\n" + string + "\n" + exception.getMessage()));
                            return null;
                        }
                    }
                });
                return restSecurity;
            }
            catch (Exception exception) {
                RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), RestArb.format("ERROR_RETRIEVE", RestArb.getString("LABEL_PRIVILEGE")), exception);
                Logger.warn(RestDownload.class, (String)(RestArb.format("ERROR_RETRIEVE", RestArb.getString("LABEL_PRIVILEGE")) + "\n" + string + "\n" + exception.getMessage()));
            }
        } else {
            String string2 = RestArb.format("ERROR_RETRIEVE", RestArb.getString("LABEL_PRIVILEGE")).concat(System.getProperty("line.separator")).concat(RestConnection.getInstance().getConnectionError());
            RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), string2);
        }
        return null;
    }

    private List<String> downloadRoles() {
        if (RestConnection.getInstance().isConnectionOpen()) {
            try {
                List list = (List)RestConnection.getInstance().getConnection().executeQuery("/oauth2/roles/", (ResponseHandler)new JSONNodeHandler<List<String>>(){

                    protected List<String> build(JSONNode jSONNode) throws IOException {
                        try {
                            JSONObject jSONObject = (JSONObject)jSONNode;
                            ArrayList<String> arrayList = new ArrayList<String>();
                            JSONArray jSONArray = (JSONArray)JSONUtils.getValue((JSONObject)jSONObject, (String)"items");
                            for (Object t : jSONArray.values()) {
                                JSONObject jSONObject2 = (JSONObject)t;
                                String string = (String)JSONUtils.getValue((JSONObject)jSONObject2, (String)"name");
                                arrayList.add(string);
                            }
                            return arrayList;
                        }
                        catch (Exception exception) {
                            RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), RestArb.format("ERROR_RETRIEVE", RestArb.getString("LABEL_ROLE")), exception);
                            Logger.warn(RestDownload.class, (String)exception.getMessage());
                            return null;
                        }
                    }
                });
                return list;
            }
            catch (Exception exception) {
                RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), RestArb.format("ERROR_RETRIEVE", RestArb.getString("LABEL_ROLE")), exception);
                Logger.warn(RestDownload.class, (String)exception.getMessage());
            }
        } else {
            String string = RestArb.format("ERROR_RETRIEVE", RestArb.getString("LABEL_ROLE")).concat(System.getProperty("line.separator")).concat(RestConnection.getInstance().getConnectionError());
            RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), string);
        }
        return null;
    }
}

