/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.connection;

import java.awt.Component;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import oracle.dbtools.raptor.cloud.connection.CConnection;
import oracle.dbtools.raptor.cloud.connection.CConnectionType;
import oracle.dbtools.raptor.cloud.connection.CConnections;
import oracle.dbtools.raptor.cloud.connection.rest.RestConnectionType;
import oracle.dbtools.raptor.cloud.controls.CloudConnectionSelector;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.connection.RestConnErrorDialog;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpUriRequest;

public class RestConnection {
    private static RestConnection _instance;
    private CConnection _connection = null;
    private String _connectionName;
    private String _prevConnName;
    private String _errMsg;
    private boolean _isAPEXREST;
    private static final String ERR_REASON_DESCRIP = "error_description*=";

    public static synchronized RestConnection getInstance() {
        if (_instance == null) {
            _instance = new RestConnection();
        }
        return _instance;
    }

    public boolean connect() {
        this._connectionName = CloudConnectionSelector.getConnection((String)RestArb.getString("CONNECTION_TITLE"), (String)RestArb.getString("SELECT_CONNECTION"), (String)this._prevConnName, (CConnectionType)RestConnectionType.getInstance());
        if (this._connectionName != null && !this._connectionName.isEmpty()) {
            WaitCursor waitCursor = new WaitCursor((Component)Ide.getMainWindow());
            try {
                waitCursor.show();
                this._connection = CConnections.getInstance((CConnectionType)RestConnectionType.getInstance()).getConnection(this._connectionName, true);
                if (this._connection != null && this._connection.isOpen()) {
                    this._prevConnName = this._connectionName;
                    boolean bl = true;
                    return bl;
                }
                this._isAPEXREST = false;
            }
            catch (Exception exception) {
                waitCursor.hide();
                RestConnErrorDialog.displayMessage(RestArb.getString("CONNECT_ERROR_TITLE"), RestArb.format("CONNECT_FAILED", this.getConnectionName()), exception);
                Logger.warn(RestConnection.class, (String)exception.getMessage());
            }
            finally {
                waitCursor.hide();
            }
        }
        return false;
    }

    public void disconnect() {
        if (this.isConnectionOpen()) {
            if (this._connectionName != null) {
                CConnections.getInstance((CConnectionType)RestConnectionType.getInstance()).closeConnection(this._connectionName);
                this._connectionName = null;
            } else {
                Logger.warn(RestConnection.class, (String)"Connection name is null");
            }
        }
    }

    public boolean delete(String string, String string2, String string3) {
        boolean bl = false;
        try {
            HttpDelete httpDelete = null;
            httpDelete = this._connection.createDelete(new URI(string));
            bl = (Boolean)this._connection.executeRequest((HttpUriRequest)httpDelete, (ResponseHandler)new ResponseHandler<Boolean>(){

                public Boolean handleResponse(HttpResponse httpResponse) {
                    String string;
                    String string2;
                    StatusLine statusLine = httpResponse.getStatusLine();
                    int n = statusLine.getStatusCode();
                    if (n == 204) {
                        return new Boolean(true);
                    }
                    String string3 = "";
                    Header header = httpResponse.getFirstHeader("Error-Reason");
                    if (header != null && !RestUtils.emptyValue(string2 = header.getValue()) && !RestUtils.emptyValue(string = RestConnection.this.getErrorReasonDetails(string2))) {
                        string3 = "\n" + string;
                    }
                    string2 = RestArb.format("RESPONSE_STATUS", Integer.toString(n), statusLine.getReasonPhrase()) + string3;
                    RestConnection.this.setErrorMessage(string2);
                    Logger.warn(RestConnection.class, (String)string2);
                    return new Boolean(false);
                }
            });
        }
        catch (Exception exception) {
            String string4 = RestArb.format("ERROR_DELETE_URL", string3);
            RestConnErrorDialog.displayMessage(RestArb.getString("REST_ADMIN_TITLE"), string4, exception);
            Logger.warn(RestConnection.class, (String)exception.getMessage());
        }
        return bl;
    }

    public boolean isConnectionOpen() {
        return this._connection != null && this._connection.isOpen();
    }

    public String getConnectionName() {
        return this._connectionName;
    }

    private void setErrorMessage(String string) {
        this._errMsg = string;
    }

    public String getErrorMessage() {
        if (this._errMsg != null) {
            return this._errMsg;
        }
        return "";
    }

    public URI getURI() {
        if (this._connection != null) {
            return this._connection.getRoot();
        }
        return null;
    }

    public CConnection getConnection() {
        return this._connection;
    }

    public String getConnectionError() {
        if (this._connection == null || this._connectionName == null) {
            return RestArb.getString("NOT_CONNECTED");
        }
        return RestArb.format("CONNECT_FAILED", this._connectionName);
    }

    public String getErrorReasonDetails(String string) {
        if (RestUtils.emptyValue(string)) {
            return null;
        }
        String string2 = null;
        String string3 = "";
        int n = string.indexOf(ERR_REASON_DESCRIP);
        if (n != -1) {
            n += ERR_REASON_DESCRIP.length();
            int n2 = string.indexOf(39);
            if (n2 != -1 && (n2 = string.indexOf(39, n = n2 + 1)) != -1) {
                String string4 = string.substring(n, n2);
                String string5 = string.substring(++n2);
                try {
                    if (!RestUtils.emptyValue(string5)) {
                        String string6 = RestUtils.emptyValue(string4) ? "UTF-8" : string4;
                        string3 = URLDecoder.decode(string5, string6);
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Logger.warn(RestConnection.class, (String)unsupportedEncodingException.getMessage());
                }
                string2 = RestUtils.emptyValue(string3) ? "" : string3;
            }
        }
        return string2;
    }

    public void setAPEXRestfulServices(boolean bl) {
        this._isAPEXREST = bl;
    }

    public boolean isAPEXRestfulServices() {
        return this._isAPEXREST;
    }
}

