/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.autorest.ui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.autorest.AutoRestArb;
import oracle.dbtools.autorest.model.RestSchemaData;

public class RestSchemaDetailsPanel
extends JPanel {
    private transient RestSchemaData schemaDataModel;
    private List<String> existingNames;
    private ArrayList<String> _errMsg;
    private ArrayList<String> ignorePropertyList = new ArrayList();
    private transient SchemaDataModelListener schemaDataModelListener = new SchemaDataModelListener();
    private transient EnableCheckBoxListener enableCheckBoxListener = new EnableCheckBoxListener();
    private transient AuthReqCheckBoxListener authReqCheckBoxListener = new AuthReqCheckBoxListener();
    private transient CommitCheckBoxListener commitCheckBoxListener = new CommitCheckBoxListener();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel enableLabel = new JLabel();
    private JCheckBox enableCheckBox = new JCheckBox();
    private JLabel aliasLabel = new JLabel();
    private JTextField aliasTextField = new JTextField();
    private JLabel objectURIExample = new JLabel();
    private JCheckBox authReqCheckBox = new JCheckBox();
    private JLabel authReqLabel = new JLabel();
    private JCheckBox commitCheckBox = new JCheckBox();
    private JLabel commitLabel = new JLabel();

    public RestSchemaDetailsPanel(RestSchemaData restSchemaData) {
        this.schemaDataModel = restSchemaData;
        restSchemaData.addPropertyChangeListener(this.schemaDataModelListener);
        this.jbInit();
    }

    private void jbInit() {
        this.setName("RestSchemaDetailsPanel");
        this.enableLabel.setName("enableLabel");
        this.enableCheckBox.setName("enableCheckBox");
        this.aliasLabel.setName("aliasLabel");
        this.aliasTextField.setName("aliasTextField");
        this.objectURIExample.setName("objectURIExample");
        this.authReqCheckBox.setName("authReqCheckBox");
        this.authReqLabel.setName("authReqLabel");
        this.commitCheckBox.setName("commitCheckBox");
        this.commitLabel.setName("commitLabel");
        this.setLayout(this.gridBagLayout1);
        this.enableLabel.setText("Enable object");
        this.enableLabel.setText(AutoRestArb.get("PANEL_SCHEMA_DETAILS_ENABLE_SCHEMA"));
        this.enableLabel.setLabelFor(this.enableCheckBox);
        this.enableCheckBox.addItemListener(this.enableCheckBoxListener);
        this.aliasLabel.setText("Schema alias");
        this.aliasLabel.setText(AutoRestArb.get("PANEL_SCHEMA_DETAILS_SCHEMA_ALIAS"));
        this.aliasLabel.setLabelFor(this.aliasTextField);
        this.objectURIExample.setText("http://host:port/ords/");
        this.authReqLabel.setText("Authorisation Required");
        this.authReqLabel.setText(AutoRestArb.get("PANEL_SCHEMA_DETAILS_AUTHORISATION_REQUIRED"));
        this.authReqLabel.setLabelFor(this.authReqCheckBox);
        this.authReqCheckBox.addItemListener(this.authReqCheckBoxListener);
        this.commitLabel.setText("Commit");
        this.commitLabel.setText(AutoRestArb.get("PANEL_SCHEMA_DETAILS_COMMIT"));
        this.commitLabel.setLabelFor(this.commitCheckBox);
        this.commitCheckBox.addItemListener(this.commitCheckBoxListener);
        this.add((Component)this.enableLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.enableCheckBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.aliasLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.aliasTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.authReqCheckBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.authReqLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.initialise();
    }

    public void addListeners() {
    }

    public void removeListeners() {
    }

    public boolean validInfo() {
        Matcher matcher;
        if (this._errMsg == null) {
            this._errMsg = new ArrayList();
        } else {
            this._errMsg.clear();
        }
        boolean bl = false;
        Pattern pattern = Pattern.compile("\\p{Lower}([\\p{Lower}\\p{Digit}#$_])*$");
        String string = this.aliasTextField.getText();
        if (string.length() == 0) {
            this.setErrorMessage(AutoRestArb.format("VALUE_REQUIRED", AutoRestArb.getString("LABEL_MODULE_NAME")));
        }
        if (!(matcher = pattern.matcher(string)).matches()) {
            String string2 = AutoRestArb.format("INVALID_ALIAS", string);
            this.setErrorMessage(string2);
        }
        if (this._errMsg.size() > 0) {
            bl = true;
        }
        if (this._errMsg.size() > 0 && bl) {
            this.aliasTextField.requestFocusInWindow();
        }
        return this._errMsg.size() == 0;
    }

    public RestSchemaData getValues() {
        String string = this.aliasTextField.getText() != null ? this.aliasTextField.getText().trim() : "";
        this.schemaDataModel.setSchemaAlias(string);
        return this.schemaDataModel;
    }

    public String getErrorMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this._errMsg) {
            stringBuffer.append(string).append("\n");
        }
        return stringBuffer.toString();
    }

    private void setErrorMessage(String string) {
        if (this._errMsg == null) {
            this._errMsg = new ArrayList();
        }
        this._errMsg.add(string);
    }

    public void setExistingNames(List<String> list) {
        this.existingNames = list;
    }

    public boolean isExistModuleName(String string) {
        if (this.existingNames == null || this.existingNames.isEmpty()) {
            return false;
        }
        return this.existingNames.contains(string);
    }

    private void initialise() {
        if (this.schemaDataModel != null) {
            this.aliasTextField.setText(this.schemaDataModel.getSchemaAlias());
            this.enableCheckBox.setSelected(this.schemaDataModel.isEnabled());
            this.commitCheckBox.setSelected(this.schemaDataModel.isCommit());
            this.authReqCheckBox.setSelected(this.schemaDataModel.isAuthorisationRequired());
        }
    }

    public void updatePanel() {
        this.initialise();
    }

    private class SchemaDataModelListener
    implements PropertyChangeListener {
        private SchemaDataModelListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChangeImpl(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            ArrayList arrayList = RestSchemaDetailsPanel.this.ignorePropertyList;
            synchronized (arrayList) {
                if (!RestSchemaDetailsPanel.this.ignorePropertyList.contains(string)) {
                    try {
                        if (string.equals("schemaAlias")) {
                            RestSchemaDetailsPanel.this.aliasTextField.setText(RestSchemaDetailsPanel.this.schemaDataModel.getSchemaAlias());
                        } else if (string.equals("enabled")) {
                            RestSchemaDetailsPanel.this.enableCheckBox.setSelected(RestSchemaDetailsPanel.this.schemaDataModel.isEnabled());
                        } else if (string.equals("commit")) {
                            RestSchemaDetailsPanel.this.commitCheckBox.setSelected(RestSchemaDetailsPanel.this.schemaDataModel.isCommit());
                        } else if (string.equals("authorisationRequired")) {
                            RestSchemaDetailsPanel.this.authReqCheckBox.setSelected(RestSchemaDetailsPanel.this.schemaDataModel.isAuthorisationRequired());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
            if (EventQueue.isDispatchThread()) {
                this.propertyChangeImpl(propertyChangeEvent);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SchemaDataModelListener.this.propertyChangeImpl(propertyChangeEvent);
                    }
                });
            }
        }
    }

    private class CommitCheckBoxListener
    implements ItemListener {
        private CommitCheckBoxListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ArrayList arrayList = RestSchemaDetailsPanel.this.ignorePropertyList;
            synchronized (arrayList) {
                if (!RestSchemaDetailsPanel.this.ignorePropertyList.contains("commit")) {
                    try {
                        RestSchemaDetailsPanel.this.ignorePropertyList.add("commit");
                        RestSchemaDetailsPanel.this.schemaDataModel.setCommit(RestSchemaDetailsPanel.this.commitCheckBox.isSelected());
                    }
                    finally {
                        RestSchemaDetailsPanel.this.ignorePropertyList.remove("commit");
                    }
                }
            }
        }
    }

    private class AuthReqCheckBoxListener
    implements ItemListener {
        private AuthReqCheckBoxListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ArrayList arrayList = RestSchemaDetailsPanel.this.ignorePropertyList;
            synchronized (arrayList) {
                if (!RestSchemaDetailsPanel.this.ignorePropertyList.contains("authorisationRequired")) {
                    try {
                        RestSchemaDetailsPanel.this.ignorePropertyList.add("authorisationRequired");
                        RestSchemaDetailsPanel.this.schemaDataModel.setAuthorisationRequired(RestSchemaDetailsPanel.this.authReqCheckBox.isSelected());
                        if (RestSchemaDetailsPanel.this.authReqCheckBox.isSelected()) {
                            RestSchemaDetailsPanel.this.authReqCheckBox.setText(" Required role name: oracle.dbtools.role.autorest." + RestSchemaDetailsPanel.this.schemaDataModel.getSchemaName());
                        } else {
                            RestSchemaDetailsPanel.this.authReqCheckBox.setText("");
                        }
                    }
                    finally {
                        RestSchemaDetailsPanel.this.ignorePropertyList.remove("authorisationRequired");
                    }
                }
            }
        }
    }

    private class EnableCheckBoxListener
    implements ItemListener {
        private EnableCheckBoxListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ArrayList arrayList = RestSchemaDetailsPanel.this.ignorePropertyList;
            synchronized (arrayList) {
                if (!RestSchemaDetailsPanel.this.ignorePropertyList.contains("enabled")) {
                    try {
                        RestSchemaDetailsPanel.this.ignorePropertyList.add("enabled");
                        RestSchemaDetailsPanel.this.schemaDataModel.setEnabled(RestSchemaDetailsPanel.this.enableCheckBox.isSelected());
                    }
                    finally {
                        RestSchemaDetailsPanel.this.ignorePropertyList.remove("enabled");
                    }
                }
            }
        }
    }
}

