/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.autorest.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class RestSchemaData {
    public static final String ALIAS_BAD_CHARACTER_PATTERN = "[:/?#\\[\\]@!$&'()*+,;=]";
    public static final String ALIAS_CONTAINS_BAD_CHARACTER_PATTERN = "^.*[:/?#\\[\\]@!$&'()*+,;=].*$";
    public static final String PER_SCHEMA_ROLE_PREFIX = "oracle.dbtools.role.autorest.";
    public static final String OBJECT_TYPE_TABLE = "TABLE";
    public static final String OBJECT_TYPE_MVIEW = "MVIEW";
    public static final String OBJECT_TYPE_VIEW = "VIEW";
    public static final String OBJECT_ENABLED = "ENABLED";
    public static final String OBJECT_DISABLED = "DISABLED";
    public static final String SCHEMA_ENABLED = "ENABLED";
    public static final String SCHEMA_DISABLED = "DISABLED";
    public static final String AUTH_ENABLED = "ENABLED";
    public static final String AUTH_DISABLED = "DISABLED";
    public static final String PROP_ALLOWED = "allowed";
    public static final String PROP_COMMIT = "commit";
    public static final String PROP_ENABLED = "enabled";
    public static final String PROP_AUTH_REQ = "authorisationRequired";
    public static final String PROP_OPERATIONS = "operations";
    public static final String PROP_SCHEMA_ALIAS = "schemaAlias";
    public static final String PROP_SCHEMA_NAME = "schemaName";
    public static final String PROP_VERSION = "version";
    public static final String[] operationIDs = new String[]{"OP_GET_SCHEMA_METADATA", "OP_QUERY_OBJECT_DATA", "OP_INSERT_OBJECT_ROW", "OP_UPDATE_OBJECT_ROW", "OP_DELETE_OBJECT_ROW", "OP_BULK_UPDATE_ROWS"};
    public static final String[] operationNames = new String[]{"PANEL_OPERATIONS_GET_SCHEMA_METADATA", "PANEL_OPERATIONS_QUERY_OBJECT_DATA", "PANEL_OPERATIONS_INSERT_OBJECT_ROW", "PANEL_OPERATIONS_UPDATE_OBJECT_ROW", "PANEL_OPERATIONS_DELETE_OBJECT_ROW", "PANEL_OPERATIONS_BULK_UPDATE_ROWS"};
    private boolean commit;
    private String version;
    private String schemaName;
    private String schemaAlias;
    private boolean authorisationRequired;
    private boolean enabled;
    private Boolean[] allowed;
    private String[] operations;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public void setVersion(String string) {
        String string2 = this.version;
        this.version = string;
        this.propertyChangeSupport.firePropertyChange(PROP_VERSION, string2, string);
    }

    public String getVersion() {
        return this.version;
    }

    public synchronized void setSchemaName(String string) {
        String string2 = this.schemaName;
        this.schemaName = string;
        this.propertyChangeSupport.firePropertyChange(PROP_SCHEMA_NAME, string2, string);
    }

    public synchronized String getSchemaName() {
        return this.schemaName;
    }

    public synchronized String getOwner() {
        return this.getSchemaName();
    }

    public synchronized void setSchemaAlias(String string) {
        String string2 = this.schemaAlias;
        this.schemaAlias = string;
        this.propertyChangeSupport.firePropertyChange(PROP_SCHEMA_ALIAS, string2, string);
    }

    public synchronized String getSchemaAlias() {
        return this.schemaAlias;
    }

    public void setCommit(boolean bl) {
        boolean bl2 = this.commit;
        this.commit = bl;
        this.propertyChangeSupport.firePropertyChange(PROP_COMMIT, bl2, bl);
    }

    public boolean isCommit() {
        return this.commit;
    }

    public synchronized void setEnabled(boolean bl) {
        boolean bl2 = this.enabled;
        this.enabled = bl;
        this.propertyChangeSupport.firePropertyChange(PROP_ENABLED, bl2, bl);
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    public void setAuthorisationRequired(boolean bl) {
        boolean bl2 = this.authorisationRequired;
        this.authorisationRequired = bl;
        this.propertyChangeSupport.firePropertyChange(PROP_AUTH_REQ, bl2, bl);
    }

    public boolean isAuthorisationRequired() {
        return this.authorisationRequired;
    }

    public void setAllowed(Boolean[] booleanArray) {
        Boolean[] booleanArray2 = this.allowed;
        this.allowed = booleanArray;
        this.propertyChangeSupport.firePropertyChange(PROP_ALLOWED, booleanArray2, booleanArray);
    }

    public Boolean[] getAllowed() {
        return this.allowed;
    }

    public int getAllowedMask() {
        int n = 0;
        if (this.allowed != null) {
            for (int i = 0; i < this.allowed.length; ++i) {
                if (this.allowed[i] == null || !this.allowed[i].booleanValue()) continue;
                n |= 1 << i;
            }
        }
        if (this.authorisationRequired) {
            n |= 1 << operationNames.length;
        }
        return n;
    }

    public void setOperations(String[] stringArray) {
        String[] stringArray2 = this.operations;
        this.operations = stringArray;
        this.propertyChangeSupport.firePropertyChange(PROP_OPERATIONS, stringArray2, stringArray);
    }

    public String[] getOperations() {
        return this.operations;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }
}

