/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.autorest.model;

import java.util.List;
import java.util.Map;
import oracle.dbtools.autorest.AutoRestArb;
import oracle.dbtools.autorest.generator.AutoRestCodeGenerator;
import oracle.dbtools.autorest.model.AutoRestListTask;
import oracle.dbtools.autorest.model.AutoRestRowTask;
import oracle.dbtools.autorest.model.RestObjectData;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.utils.DBObject;

public class RestObjectDataInitialiser
implements Runnable {
    private RestObjectData objectDataModel;
    private DBObject dbObj;
    private AutoRestListTask membersMapTask;
    private AutoRestRowTask objectDataMapTask;

    public RestObjectDataInitialiser(RestObjectData restObjectData, DBObject dBObject) {
        this.objectDataModel = restObjectData;
        this.dbObj = dBObject;
        try {
            this.objectDataModel.setOwner(dBObject.getConnection().getSchema());
        }
        catch (Throwable throwable) {
            this.objectDataModel.setOwner(dBObject.getSchemaName());
        }
        restObjectData.setObjectName(dBObject.getObjectName());
        restObjectData.setVersion(dBObject.getDBVersion());
        this.membersMapTask = new TableColumnsListTask(){

            @Override
            public String getTemplateName() {
                return "MEMBER_LIST";
            }

            @Override
            public String[] getResultColumnNames() {
                return new String[]{"MEMBER_NAME", "MEMBER_ALIAS", "VISIBLE", "TYPE"};
            }
        };
        this.objectDataMapTask = new TableRowMapTask(){

            @Override
            public String getTemplateName() {
                return "OBJECT_METADATA";
            }
        };
    }

    @Override
    public void run() {
        try {
            int n;
            this.membersMapTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    try {
                        Map map = (Map)RestObjectDataInitialiser.this.membersMapTask.getResult();
                        List list = (List)map.get("MEMBER_NAME");
                        RestObjectDataInitialiser.this.objectDataModel.setMemberNames(list.toArray(new String[list.size()]));
                        List list2 = (List)map.get("MEMBER_ALIAS");
                        RestObjectDataInitialiser.this.objectDataModel.setMemberAliases(list2.toArray(new String[list2.size()]));
                        List list3 = (List)map.get("VISIBLE");
                        Boolean[] booleanArray = new Boolean[list3.size()];
                        for (int i = 0; i < booleanArray.length; ++i) {
                            booleanArray[i] = ((String)list3.get(i)).equals("ENABLED");
                        }
                        RestObjectDataInitialiser.this.objectDataModel.setVisible(booleanArray);
                        List list4 = (List)map.get("TYPE");
                        RestObjectDataInitialiser.this.objectDataModel.setMemberTypes(list4.toArray(new String[list4.size()]));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            RaptorTaskManager.getInstance().addTask((RaptorTask)this.objectDataMapTask);
            RaptorTaskManager.getInstance().addTask((RaptorTask)this.membersMapTask);
            this.objectDataModel.setCommit(true);
            Map map = (Map)this.objectDataMapTask.getResult();
            if (map.size() == 0) {
                this.objectDataModel.setObjectType("TABLE");
                this.objectDataModel.setObjectAlias(this.objectDataModel.getObjectName().toLowerCase());
                this.objectDataModel.setEnabled(Boolean.FALSE);
                this.objectDataModel.setAuthorisationRequired(Boolean.TRUE);
                this.objectDataModel.setAllowedSchemaDefault(true);
                n = 0xFFFFFF;
            } else {
                this.objectDataModel.setObjectType(map.get("TYPE") == null ? "TABLE" : (String)map.get("TYPE"));
                this.objectDataModel.setObjectAlias(map.get("OBJECT_ALIAS") == null ? this.objectDataModel.getObjectName().toLowerCase() : (String)map.get("OBJECT_ALIAS"));
                this.objectDataModel.setEnabled(map.get("STATUS") == null ? Boolean.FALSE.booleanValue() : ((String)map.get("STATUS")).equals("ENABLED"));
                this.objectDataModel.setAuthorisationRequired(map.get("AUTO_REST_AUTH") == null ? true : ((String)map.get("AUTO_REST_AUTH")).equalsIgnoreCase("enabled"));
                this.objectDataModel.setAllowedSchemaDefault(map.get("OPS_ALLOWED") == null);
                n = map.get("OPS_ALLOWED") == null ? 0xFFFFFF : Integer.valueOf((String)map.get("OPS_ALLOWED"));
            }
            String[] stringArray = new String[RestObjectData.operationNames.length];
            Boolean[] booleanArray = new Boolean[RestObjectData.operationNames.length];
            for (int i = 0; i < RestObjectData.operationNames.length; ++i) {
                stringArray[i] = AutoRestArb.getString(RestObjectData.operationNames[i]);
                booleanArray[i] = (n & 1 << i) != 0;
            }
            this.objectDataModel.setOperations(stringArray);
            this.objectDataModel.setAllowed(booleanArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private abstract class TableRowMapTask
    extends AutoRestRowTask {
        public abstract String getTemplateName();

        @Override
        public String getQuery() {
            AutoRestCodeGenerator autoRestCodeGenerator = AutoRestCodeGenerator.getInstance();
            String string = RestObjectDataInitialiser.this.dbObj.getSchemaName();
            String string2 = RestObjectDataInitialiser.this.dbObj.getObjectName();
            String string3 = RestObjectDataInitialiser.this.dbObj.getDBVersion();
            String string4 = autoRestCodeGenerator.generate(string3, this.getTemplateName(), "owner", string, "object", string2);
            return string4;
        }

        @Override
        public DBObject getDBObject() {
            return RestObjectDataInitialiser.this.dbObj;
        }
    }

    private abstract class TableColumnsListTask
    extends AutoRestListTask {
        public abstract String getTemplateName();

        @Override
        public String getQuery() {
            if (this.getTemplateName() == null) {
                return "";
            }
            AutoRestCodeGenerator autoRestCodeGenerator = AutoRestCodeGenerator.getInstance();
            String string = RestObjectDataInitialiser.this.dbObj.getSchemaName();
            String string2 = RestObjectDataInitialiser.this.dbObj.getObjectName();
            String string3 = RestObjectDataInitialiser.this.dbObj.getDBVersion();
            String string4 = autoRestCodeGenerator.generate(string3, this.getTemplateName(), "owner", string, "object", string2);
            return string4;
        }

        @Override
        public DBObject getDBObject() {
            return RestObjectDataInitialiser.this.dbObj;
        }
    }
}

