/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.autorest.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;

public abstract class AutoRestRowTask
extends DatabaseQueryTask<Map<String, String>> {
    public AutoRestRowTask() {
        super("RowTask", IRaptorTaskRunMode.NO_GUI, false, false);
    }

    public String getConnectionName() {
        return this.getDBObject().getConnectionName();
    }

    public abstract String getQuery();

    public abstract DBObject getDBObject();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> doWork() throws TaskException {
        ResultSet resultSet = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = this.getDBObject().getConnection();
        Connections.getInstance().lock(connection);
        try {
            DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
            dBUtil.setRaiseError(true);
            String string = this.getQuery();
            resultSet = dBUtil.executeOracleQuery(string, null);
            try {
                if (resultSet == null) {
                    throw new TaskException(new Throwable("executeOracleQuery failed: " + string));
                }
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                if (resultSet.next()) {
                    for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                        String string2 = resultSetMetaData.getColumnName(i);
                        String string3 = resultSet.getString(string2);
                        hashMap.put(string2, string3);
                    }
                }
            }
            finally {
                DBUtil.closeResultSet((ResultSet)resultSet);
            }
        }
        catch (Throwable throwable) {
            throw new TaskException(throwable);
        }
        finally {
            DBUtil.getConnectionResolver().unlock(connection);
        }
        return hashMap;
    }
}

