/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.autorest.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;

public abstract class AutoRestListTask
extends DatabaseQueryTask<Map<String, List<String>>> {
    public AutoRestListTask() {
        super("ListTask", IRaptorTaskRunMode.NO_GUI, false, false);
    }

    public String getConnectionName() {
        return this.getDBObject().getConnectionName();
    }

    public abstract String getQuery();

    public abstract DBObject getDBObject();

    public abstract String[] getResultColumnNames();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, List<String>> doWork() throws TaskException {
        ResultSet resultSet = null;
        TreeMap<String, List<String>> treeMap = new TreeMap<String, List<String>>();
        for (String string : this.getResultColumnNames()) {
            treeMap.put(string, new Vector());
        }
        Connection connection = this.getDBObject().getConnection();
        Connections.getInstance().lock(connection);
        try {
            DBUtil throwable = DBUtil.getInstance((Connection)connection);
            throwable.setRaiseError(true);
            String string = this.getQuery();
            resultSet = throwable.executeOracleQuery(string, null);
            try {
                if (resultSet == null) {
                    throw new TaskException(new Throwable("executeOracleQuery failed: " + string));
                }
                while (resultSet.next()) {
                    for (String string2 : this.getResultColumnNames()) {
                        String string3 = resultSet.getString(string2);
                        ((List)treeMap.get(string2)).add(string3);
                    }
                }
            }
            finally {
                DBUtil.closeResultSet((ResultSet)resultSet);
            }
        }
        catch (Throwable throwable) {
            throw new TaskException(throwable);
        }
        finally {
            DBUtil.getConnectionResolver().unlock(connection);
        }
        return treeMap;
    }
}

