/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.autorest.controllers;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;
import oracle.dbtools.autorest.wizard.AutoRestObjectWizard;
import oracle.dbtools.autorest.wizard.AutoRestSchemaWizard;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.ui.CustomTree;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.ide.model.Node;

public class AutoRestController
implements Controller {
    public static final int REST_ENABLE_SCHEMA_SERVICE_ID = Ide.findOrCreateCmdID((String)"rest.ENABLE_SCHEMA_SERVICE");
    public static final int REST_DROP_SCHEMA_SERVICE_ID = Ide.findOrCreateCmdID((String)"rest.DROP_SCHEMA_SERVICE");
    public static final int REST_ENABLE_OBJECT_SERVICE_ID = Ide.findOrCreateCmdID((String)"rest.ENABLE_OBJECT_SERVICE");
    private static AutoRestController INSTANCE;

    public static synchronized AutoRestController getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AutoRestController();
        }
        return INSTANCE;
    }

    private AutoRestController() {
        this.initActions();
    }

    public void initActions() {
    }

    public void restDisconnect() {
    }

    private void enableTableRestViaWizard(Context context) {
        Node node = context.getNode();
        if (node instanceof ObjectNode) {
            AutoRestObjectWizard.getInstance().launchEnableRESTForObject(context);
        }
    }

    private void enableSchemaRestViaWizard(Context context) {
        Element element = context.getElement();
        if (element instanceof DatabaseConnection) {
            DatabaseConnection databaseConnection = (DatabaseConnection)element;
            try {
                if (!databaseConnection.isConnectionOpen()) {
                    databaseConnection.getConnection();
                }
                databaseConnection.getConnection();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            AutoRestSchemaWizard.getInstance().launchEnableRESTForSchema(context);
        }
    }

    public void attachMouseListener(CustomTree customTree) {
        customTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && (DBConfig.getInstance().getBoolean("OPEN_ON_SINGLE_CLICK").booleanValue() || mouseEvent.getClickCount() == 2) && mouseEvent.getSource() instanceof CustomTree) {
                    CustomTree customTree = (CustomTree)mouseEvent.getSource();
                    customTree.getLastSelectedPathComponent();
                }
            }
        });
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == REST_ENABLE_SCHEMA_SERVICE_ID) {
            this.enableSchemaRestViaWizard(context);
        } else if (n != REST_DROP_SCHEMA_SERVICE_ID && n == REST_ENABLE_OBJECT_SERVICE_ID) {
            this.enableTableRestViaWizard(context);
        }
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        int n = ideAction.getCommandId();
        if (n == REST_ENABLE_SCHEMA_SERVICE_ID) {
            bl = true;
        } else if (n == REST_DROP_SCHEMA_SERVICE_ID) {
            bl = true;
        } else if (n == REST_ENABLE_OBJECT_SERVICE_ID) {
            bl = true;
        }
        return bl;
    }
}

