/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectInfoPrompter;
import oracle.jdeveloper.cm.ConnectionDescriptor;

public class ConnectInformationDialog
implements ConnectInfoPrompter,
ActionListener {
    protected ConnectionDescriptor _descriptor;
    protected Panel _contentPane;
    boolean _cancelled = false;
    protected Dialog dialog;
    private static final int DEFAULT_FIELD_SIZE = 25;

    @Override
    public void promptUser(ConnectionDescriptor descriptor) throws CMException {
        this._descriptor = descriptor;
        try {
            this.run();
        }
        catch (Exception e) {
            throw new CMException("Caught exception while displaying Connect dialog.");
        }
        if (this._cancelled) {
            throw new CMException("User canceled Connect dialog.");
        }
    }

    protected void addComponent(Panel contentPane, Component component, GridBagLayout gridbag, GridBagConstraints c, String componentName) {
        if (null != componentName) {
            component.setName(componentName);
        }
        gridbag.setConstraints(component, c);
        contentPane.add(component);
    }

    protected String getFieldValue(String componentName) {
        Component[] c = null;
        try {
            c = this._contentPane.getComponents();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (int i = 0; i < c.length; ++i) {
            String name = c[i].getName();
            if (null == name || !name.equals(componentName)) continue;
            return ((TextField)c[i]).getText();
        }
        return null;
    }

    protected void run() {
        this._contentPane = new Panel();
        TextField tf = null;
        String s = null;
        Panel p = null;
        Button b = null;
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this._contentPane.setLayout(gridbag);
        c.ipady = 0;
        c.insets = new Insets(0, 5, 0, 0);
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.addComponent(this._contentPane, new Label("Username:"), gridbag, c, null);
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.fill = 2;
        s = this._descriptor.getUsername();
        s = null == s ? "" : s;
        tf = new TextField(s, 25);
        tf.addActionListener(this);
        this.addComponent(this._contentPane, tf, gridbag, c, "username");
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        this.addComponent(this._contentPane, new Label("Password:"), gridbag, c, null);
        c.weightx = 1.0;
        c.fill = 2;
        c.gridwidth = 0;
        tf = new TextField(25);
        tf.setEchoChar('*');
        tf.addActionListener(this);
        this.addComponent(this._contentPane, tf, gridbag, c, "password");
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        this.addComponent(this._contentPane, new Label("Role:"), gridbag, c, null);
        c.weightx = 1.0;
        c.fill = 2;
        c.gridwidth = 0;
        s = this._descriptor.getRole();
        s = null == s ? "" : s;
        tf = new TextField(s, 25);
        tf.addActionListener(this);
        this.addComponent(this._contentPane, tf, gridbag, c, "role");
        this.dialog = new Dialog(new Frame(), this._descriptor.getConnectionName(), true);
        this.dialog.setResizable(false);
        this.dialog.add((Component)this._contentPane, "Center");
        p = new Panel();
        b = new Button("OK");
        b.setActionCommand("OK");
        b.addActionListener(this);
        p.add(b);
        b = new Button("Cancel");
        b.setActionCommand("Cancel");
        b.addActionListener(this);
        p.add(b);
        this.dialog.add((Component)p, "South");
        this.dialog.pack();
        try {
            this._centerDialog();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dialog.setVisible(true);
        if (!this._cancelled) {
            this._descriptor.put("user", this.getFieldValue("username"));
            this._descriptor.put("password", this.getFieldValue("password"));
            this._descriptor.put("Role", this.getFieldValue("role"));
        }
        this.dialog.dispose();
    }

    private void _centerDialog() throws Exception {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.dialog.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.dialog.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("Cancel")) {
            this._cancelled = true;
            this.dialog.setVisible(false);
        } else if (cmd.equals("OK")) {
            this._cancelled = false;
            this.dialog.setVisible(false);
        } else {
            try {
                String srcName = ((Component)e.getSource()).getName();
                if (null != srcName && (srcName.equals("username") || srcName.equals("password") || srcName.equals("role"))) {
                    this._cancelled = false;
                    this.dialog.setVisible(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

